/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.DefaultLdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.PoolableLdapConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnectionPool
extends GenericObjectPool<LdapConnection> {
    private static Logger LOG = LoggerFactory.getLogger(LdapConnectionPool.class);
    private PoolableLdapConnectionFactory factory;

    public LdapConnectionPool(LdapConnectionConfig connectionConfig, LdapApiService apiService, long timeout) {
        this(connectionConfig, apiService, timeout, null);
    }

    public LdapConnectionPool(LdapConnectionConfig connectionConfig, LdapApiService apiService, long timeout, GenericObjectPool.Config poolConfig) {
        this(LdapConnectionPool.newPoolableConnectionFactory(connectionConfig, apiService, timeout), poolConfig);
    }

    public LdapConnectionPool(PoolableLdapConnectionFactory factory) {
        this(factory, null);
    }

    public LdapConnectionPool(PoolableLdapConnectionFactory factory, GenericObjectPool.Config poolConfig) {
        super((PoolableObjectFactory)factory, poolConfig == null ? new GenericObjectPool.Config() : poolConfig);
        this.factory = factory;
    }

    public LdapApiService getLdapApiService() {
        return this.factory.getLdapApiService();
    }

    public LdapConnection getConnection() throws LdapException {
        LdapConnection connection;
        try {
            connection = (LdapConnection)super.borrowObject();
        }
        catch (LdapException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("An unexpected exception was thrown: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        return connection;
    }

    public LdapConnection getUnboundConnection() throws LdapException {
        LdapConnection connection = this.getConnection();
        connection.unBind();
        return connection;
    }

    private static PoolableLdapConnectionFactory newPoolableConnectionFactory(LdapConnectionConfig connectionConfig, LdapApiService apiService, long timeout) {
        DefaultLdapConnectionFactory connectionFactory = new DefaultLdapConnectionFactory(connectionConfig);
        connectionFactory.setLdapApiService(apiService);
        connectionFactory.setTimeOut(timeout);
        return new PoolableLdapConnectionFactory(connectionFactory);
    }

    public void releaseConnection(LdapConnection connection) throws LdapException {
        try {
            super.returnObject((Object)connection);
        }
        catch (LdapException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("An unexpected exception was thrown: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

