/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.IOException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.DefaultLdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolableLdapConnectionFactory
implements PoolableObjectFactory<LdapConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(PoolableLdapConnectionFactory.class);
    private LdapConnectionFactory connectionFactory;

    public PoolableLdapConnectionFactory(LdapConnectionConfig config) {
        this(new DefaultLdapConnectionFactory(config));
    }

    public PoolableLdapConnectionFactory(LdapConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void activateObject(LdapConnection connection) {
        LOG.debug("Activating {}", (Object)connection);
    }

    public void destroyObject(LdapConnection connection) {
        LOG.debug("Destroying {}", (Object)connection);
        try {
            connection.unBind();
        }
        catch (LdapException e) {
            LOG.error("unable to unbind connection: {}", (Object)e.getMessage());
            LOG.debug("unable to unbind connection:", (Throwable)e);
        }
        try {
            connection.close();
        }
        catch (IOException e) {
            LOG.error("unable to close connection: {}", (Object)e.getMessage());
            LOG.debug("unable to close connection:", (Throwable)e);
        }
    }

    public LdapApiService getLdapApiService() {
        return this.connectionFactory.getLdapApiService();
    }

    public LdapConnection makeObject() throws LdapException {
        LOG.debug("Creating a LDAP connection");
        return this.connectionFactory.newLdapConnection();
    }

    public void passivateObject(LdapConnection connection) throws LdapException {
        LOG.debug("Passivating {}", (Object)connection);
        this.connectionFactory.bindConnection(this.connectionFactory.configureConnection(connection));
    }

    public boolean validateObject(LdapConnection connection) {
        LOG.debug("Validating {}", (Object)connection);
        if (connection.isConnected()) {
            try {
                return connection.lookup(Dn.ROOT_DSE, "1.1") != null;
            }
            catch (LdapException le) {
                return false;
            }
        }
        return false;
    }
}

