/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.parsers.ParserMonitor;
import org.apache.directory.api.ldap.model.schema.parsers.ParserMonitorAdapter;
import org.apache.directory.api.ldap.model.schema.parsers.ReusableAntlrSchemaLexer;
import org.apache.directory.api.ldap.model.schema.parsers.ReusableAntlrSchemaParser;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaParser<T extends SchemaObject> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSchemaParser.class);
    protected ParserMonitor monitor = new ParserMonitorAdapter();
    protected ReusableAntlrSchemaParser parser;
    protected ReusableAntlrSchemaLexer lexer;
    private Class<T> schemaObjectType;
    private I18n errorCodeOnNull;
    private I18n errorCodeOnParseExceptionWithPosition;
    private I18n errorCodeOnParseException;

    protected AbstractSchemaParser(Class<T> schemaObjectType, I18n errorCodeOnNull, I18n errorCodeOnParseExceptionWithPosition, I18n errorCodeOnParseException) {
        this.schemaObjectType = schemaObjectType;
        this.errorCodeOnNull = errorCodeOnNull;
        this.errorCodeOnParseExceptionWithPosition = errorCodeOnParseExceptionWithPosition;
        this.errorCodeOnParseException = errorCodeOnParseException;
        this.lexer = new ReusableAntlrSchemaLexer(new StringReader(""));
        this.parser = new ReusableAntlrSchemaParser(this.lexer);
    }

    protected void reset(String spec) {
        StringReader in = new StringReader(spec);
        this.lexer.prepareNextInput(in);
        this.parser.resetState();
    }

    public void setParserMonitor(ParserMonitor parserMonitor) {
        this.monitor = parserMonitor;
        this.parser.setParserMonitor(parserMonitor);
    }

    public void setQuirksMode(boolean enabled) {
        this.parser.setQuirksMode(enabled);
    }

    public boolean isQuirksMode() {
        return this.parser.isQuirksMode();
    }

    public synchronized T parse(String schemaDescription) throws ParseException {
        LOG.debug("Parsing a {} : {}", (Object)this.schemaObjectType.getClass().getSimpleName(), (Object)schemaDescription);
        if (schemaDescription == null) {
            LOG.error(I18n.err(this.errorCodeOnNull, new Object[0]));
            throw new ParseException("Null", 0);
        }
        this.reset(schemaDescription);
        try {
            T schemaObject = this.doParse();
            schemaObject.setSpecification(schemaDescription);
            this.updateSchemaName((SchemaObject)schemaObject);
            return schemaObject;
        }
        catch (RecognitionException re) {
            ParseException parseException = this.wrapRecognitionException(schemaDescription, re);
            throw parseException;
        }
        catch (TokenStreamRecognitionException tsre) {
            if (tsre.recog != null) {
                ParseException parseException = this.wrapRecognitionException(schemaDescription, tsre.recog);
                throw parseException;
            }
            ParseException parseException = this.wrapTokenStreamException(schemaDescription, (TokenStreamException)((Object)tsre));
            throw parseException;
        }
        catch (TokenStreamException tse) {
            ParseException parseException = this.wrapTokenStreamException(schemaDescription, tse);
            throw parseException;
        }
    }

    private ParseException wrapRecognitionException(String schemaDescription, RecognitionException re) {
        String msg = I18n.err(this.errorCodeOnParseExceptionWithPosition, schemaDescription, re.getMessage(), re.getColumn());
        LOG.error(msg);
        ParseException parseException = new ParseException(msg, re.getColumn());
        parseException.initCause(re);
        return parseException;
    }

    private ParseException wrapTokenStreamException(String schemaDescription, TokenStreamException tse) {
        String msg = I18n.err(this.errorCodeOnParseException, schemaDescription, tse.getMessage());
        LOG.error(msg);
        ParseException parseException = new ParseException(msg, 0);
        parseException.initCause(tse);
        return parseException;
    }

    protected abstract T doParse() throws RecognitionException, TokenStreamException;

    private void updateSchemaName(SchemaObject schemaObject) {
        List<String> schemaExtension = schemaObject.getExtension("X-SCHEMA");
        if (schemaExtension != null) {
            String schemaName = schemaExtension.get(0);
            if (Strings.isEmpty(schemaName)) {
                schemaObject.setSchemaName("other");
            } else {
                schemaObject.setSchemaName(schemaName);
            }
        } else {
            schemaObject.setSchemaName("other");
        }
    }
}

