/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.factory;

import java.util.Collection;
import java.util.Iterator;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.factory.Messagefactory;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.ModifyRequest;

public final class ModifyRequestFactory
implements Messagefactory {
    public static final ModifyRequestFactory INSTANCE = new ModifyRequestFactory();

    private ModifyRequestFactory() {
    }

    private void encodeValues(Asn1Buffer buffer, Iterator<Value> values) {
        if (values.hasNext()) {
            Value value = values.next();
            this.encodeValues(buffer, values);
            if (value.isHumanReadable()) {
                BerValue.encodeOctetString(buffer, value.getString());
            } else {
                BerValue.encodeOctetString(buffer, value.getBytes());
            }
        }
    }

    private void encodeModifications(Asn1Buffer buffer, Iterator<Modification> modifications) {
        if (modifications.hasNext()) {
            Modification modification = modifications.next();
            this.encodeModifications(buffer, modifications);
            int start = buffer.getPos();
            Attribute attribute = modification.getAttribute();
            if (modification.getAttribute().size() != 0) {
                this.encodeValues(buffer, modification.getAttribute().iterator());
                BerValue.encodeSet(buffer, start);
            } else if (modification.getOperation() != ModificationOperation.INCREMENT_ATTRIBUTE) {
                BerValue.encodeSet(buffer, start);
            }
            BerValue.encodeOctetString(buffer, attribute.getUpId());
            BerValue.encodeSequence(buffer, start);
            BerValue.encodeEnumerated(buffer, modification.getOperation().getValue());
            BerValue.encodeSequence(buffer, start);
        }
    }

    @Override
    public void encodeReverse(LdapApiService codec, Asn1Buffer buffer, Message message) {
        int start = buffer.getPos();
        ModifyRequest modifyRequest = (ModifyRequest)message;
        Collection<Modification> modifications = modifyRequest.getModifications();
        if (modifications != null && !modifications.isEmpty()) {
            this.encodeModifications(buffer, modifications.iterator());
            BerValue.encodeSequence(buffer, start);
        }
        BerValue.encodeOctetString(buffer, modifyRequest.getName().getName());
        BerValue.encodeSequence(buffer, (byte)102, start);
    }
}

