/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.response;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.dsmlv2.AbstractDsmlMessageDecorator;
import org.apache.directory.api.dsmlv2.AbstractGrammar;
import org.apache.directory.api.dsmlv2.DsmlControl;
import org.apache.directory.api.dsmlv2.DsmlDecorator;
import org.apache.directory.api.dsmlv2.Dsmlv2Container;
import org.apache.directory.api.dsmlv2.Dsmlv2StatesEnum;
import org.apache.directory.api.dsmlv2.Grammar;
import org.apache.directory.api.dsmlv2.GrammarAction;
import org.apache.directory.api.dsmlv2.GrammarTransition;
import org.apache.directory.api.dsmlv2.ParserUtils;
import org.apache.directory.api.dsmlv2.Tag;
import org.apache.directory.api.dsmlv2.response.AddResponseDsml;
import org.apache.directory.api.dsmlv2.response.BatchResponseDsml;
import org.apache.directory.api.dsmlv2.response.BindResponseDsml;
import org.apache.directory.api.dsmlv2.response.CompareResponseDsml;
import org.apache.directory.api.dsmlv2.response.DelResponseDsml;
import org.apache.directory.api.dsmlv2.response.ErrorResponse;
import org.apache.directory.api.dsmlv2.response.ExtendedResponseDsml;
import org.apache.directory.api.dsmlv2.response.ModDNResponseDsml;
import org.apache.directory.api.dsmlv2.response.ModifyResponseDsml;
import org.apache.directory.api.dsmlv2.response.SearchResponse;
import org.apache.directory.api.dsmlv2.response.SearchResponseDsml;
import org.apache.directory.api.dsmlv2.response.SearchResultDoneDsml;
import org.apache.directory.api.dsmlv2.response.SearchResultEntryDsml;
import org.apache.directory.api.dsmlv2.response.SearchResultReferenceDsml;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.AddResponseImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.BindResponseImpl;
import org.apache.directory.api.ldap.model.message.CompareResponse;
import org.apache.directory.api.ldap.model.message.CompareResponseImpl;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.DeleteResponse;
import org.apache.directory.api.ldap.model.message.DeleteResponseImpl;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.message.ModifyDnResponseImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.ModifyResponseImpl;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ReferralImpl;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultDoneImpl;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.api.ldap.model.message.SearchResultReferenceImpl;
import org.apache.directory.api.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.api.util.Base64;
import org.apache.directory.api.util.Strings;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class Dsmlv2ResponseGrammar
extends AbstractGrammar
implements Grammar {
    private static Dsmlv2ResponseGrammar instance = new Dsmlv2ResponseGrammar();
    private static final Set<String> DSMLV2_DESCR_TAGS = new HashSet<String>();
    private final GrammarAction batchResponseCreation = new GrammarAction("Create Batch Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            BatchResponseDsml batchResponse = new BatchResponseDsml();
            container.setBatchResponse(batchResponse);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                batchResponse.setRequestID(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
        }
    };
    private final GrammarAction addResponseCreation = new GrammarAction("Create Add Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            AddResponseDsml addResponse = new AddResponseDsml(container.getLdapCodecService(), (AddResponse)new AddResponseImpl());
            container.getBatchResponse().addResponse(addResponse);
            LdapResult ldapResult = addResponse.getLdapResult();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                addResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    ldapResult.setMatchedDn(new Dn(new String[]{attributeValue}));
                }
                catch (LdapInvalidDnException lide) {
                    throw new XmlPullParserException(lide.getMessage(), xpp, (Throwable)lide);
                }
            }
        }
    };
    private final GrammarAction authResponseCreation = new GrammarAction("Create Auth Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            BindResponseDsml bindResponse = new BindResponseDsml(container.getLdapCodecService(), (BindResponse)new BindResponseImpl());
            container.getBatchResponse().addResponse(bindResponse);
            LdapResult ldapResult = bindResponse.getLdapResult();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                bindResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    ldapResult.setMatchedDn(new Dn(new String[]{attributeValue}));
                }
                catch (LdapInvalidDnException lide) {
                    throw new XmlPullParserException(lide.getMessage(), xpp, (Throwable)lide);
                }
            }
        }
    };
    private final GrammarAction compareResponseCreation = new GrammarAction("Create Compare Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            CompareResponseDsml compareResponse = new CompareResponseDsml(container.getLdapCodecService(), (CompareResponse)new CompareResponseImpl());
            container.getBatchResponse().addResponse(compareResponse);
            LdapResult ldapResult = compareResponse.getLdapResult();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                compareResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    ldapResult.setMatchedDn(new Dn(new String[]{attributeValue}));
                }
                catch (LdapInvalidDnException lide) {
                    throw new XmlPullParserException(lide.getMessage(), xpp, (Throwable)lide);
                }
            }
        }
    };
    private final GrammarAction delResponseCreation = new GrammarAction("Create Del Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            DelResponseDsml delResponse = new DelResponseDsml(container.getLdapCodecService(), (DeleteResponse)new DeleteResponseImpl());
            container.getBatchResponse().addResponse(delResponse);
            LdapResult ldapResult = delResponse.getLdapResult();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                delResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    ldapResult.setMatchedDn(new Dn(new String[]{attributeValue}));
                }
                catch (LdapInvalidDnException lide) {
                    throw new XmlPullParserException(lide.getMessage(), xpp, (Throwable)lide);
                }
            }
        }
    };
    private final GrammarAction modifyResponseCreation = new GrammarAction("Create Modify Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ModifyResponseDsml modifyResponse = new ModifyResponseDsml(container.getLdapCodecService(), (ModifyResponse)new ModifyResponseImpl());
            container.getBatchResponse().addResponse(modifyResponse);
            LdapResult ldapResult = modifyResponse.getLdapResult();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                modifyResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    ldapResult.setMatchedDn(new Dn(new String[]{attributeValue}));
                }
                catch (LdapInvalidDnException lide) {
                    throw new XmlPullParserException(lide.getMessage(), xpp, (Throwable)lide);
                }
            }
        }
    };
    private final GrammarAction modDNResponseCreation = new GrammarAction("Create Mod Dn Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ModDNResponseDsml modDNResponse = new ModDNResponseDsml(container.getLdapCodecService(), (ModifyDnResponse)new ModifyDnResponseImpl());
            container.getBatchResponse().addResponse(modDNResponse);
            LdapResult ldapResult = modDNResponse.getLdapResult();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                modDNResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    ldapResult.setMatchedDn(new Dn(new String[]{attributeValue}));
                }
                catch (LdapInvalidDnException lide) {
                    throw new XmlPullParserException(lide.getMessage(), xpp, (Throwable)lide);
                }
            }
        }
    };
    private final GrammarAction extendedResponseCreation = new GrammarAction("Create Extended Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtendedResponseDsml extendedResponse = null;
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            extendedResponse = attributeValue != null ? new ExtendedResponseDsml(container.getLdapCodecService(), (ExtendedResponse)new ExtendedResponseImpl(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp))) : new ExtendedResponseDsml(container.getLdapCodecService(), (ExtendedResponse)new ExtendedResponseImpl(-1));
            container.getBatchResponse().addResponse(extendedResponse);
            LdapResult ldapResult = extendedResponse.getLdapResult();
            attributeValue = xpp.getAttributeValue("", "matchedDN");
            if (attributeValue != null) {
                try {
                    ldapResult.setMatchedDn(new Dn(new String[]{attributeValue}));
                }
                catch (LdapInvalidDnException lide) {
                    throw new XmlPullParserException(lide.getMessage(), xpp, (Throwable)lide);
                }
            }
        }
    };
    private final GrammarAction errorResponseCreation = new GrammarAction("Create Error Response"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ErrorResponse errorResponse = null;
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                errorResponse = new ErrorResponse(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp), null);
                container.getBatchResponse().addResponse(errorResponse);
            }
            if ((attributeValue = xpp.getAttributeValue("", "type")) == null) throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03005, (Object[])new Object[0]), xpp, null);
            if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.NOT_ATTEMPTED))) {
                errorResponse.setErrorType(ErrorResponse.ErrorResponseType.NOT_ATTEMPTED);
                return;
            } else if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.COULD_NOT_CONNECT))) {
                errorResponse.setErrorType(ErrorResponse.ErrorResponseType.COULD_NOT_CONNECT);
                return;
            } else if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.CONNECTION_CLOSED))) {
                errorResponse.setErrorType(ErrorResponse.ErrorResponseType.CONNECTION_CLOSED);
                return;
            } else if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.MALFORMED_REQUEST))) {
                errorResponse.setErrorType(ErrorResponse.ErrorResponseType.MALFORMED_REQUEST);
                return;
            } else if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.GATEWAY_INTERNAL_ERROR))) {
                errorResponse.setErrorType(ErrorResponse.ErrorResponseType.GATEWAY_INTERNAL_ERROR);
                return;
            } else if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.AUTHENTICATION_FAILED))) {
                errorResponse.setErrorType(ErrorResponse.ErrorResponseType.AUTHENTICATION_FAILED);
                return;
            } else if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.UNRESOLVABLE_URI))) {
                errorResponse.setErrorType(ErrorResponse.ErrorResponseType.UNRESOLVABLE_URI);
                return;
            } else {
                if (!attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.OTHER))) throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03004, (Object[])new Object[0]), xpp, null);
                errorResponse.setErrorType(ErrorResponse.ErrorResponseType.OTHER);
            }
        }
    };
    private final GrammarAction errorResponseAddMessage = new GrammarAction("Add Message to Error Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ErrorResponse errorResponse = (ErrorResponse)container.getBatchResponse().getCurrentResponse();
            XmlPullParser xpp = container.getParser();
            try {
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    errorResponse.setMessage(nextText.trim());
                }
            }
            catch (IOException ioe) {
                throw new XmlPullParserException(ioe.getMessage(), xpp, (Throwable)ioe);
            }
        }
    };
    private static final GrammarAction ERROR_RESPONSE_ADD_DETAIL;
    private final GrammarAction ldapResultControlCreation = new GrammarAction("Create Control for LDAP Result"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            AbstractDsmlMessageDecorator message = (AbstractDsmlMessageDecorator)container.getBatchResponse().getCurrentResponse();
            if (message instanceof SearchResponseDsml) {
                Dsmlv2ResponseGrammar.this.createAndAddControl(container, ((SearchResponse)((Object)((SearchResponseDsml)message).getDecorated())).getSearchResultDone());
            } else {
                Dsmlv2ResponseGrammar.this.createAndAddControl(container, message);
            }
        }
    };
    private final GrammarAction searchResultEntryControlCreation = new GrammarAction("Create Control for Search Result Entry"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResponse response = (SearchResponse)((Object)((SearchResponseDsml)container.getBatchResponse().getCurrentResponse()).getDecorated());
            Dsmlv2ResponseGrammar.this.createAndAddControl(container, response.getCurrentSearchResultEntry());
        }
    };
    private final GrammarAction searchResultReferenceControlCreation = new GrammarAction("Create Control for Search Result Reference"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResponse response = (SearchResponse)((Object)((SearchResponseDsml)container.getBatchResponse().getCurrentResponse()).getDecorated());
            Dsmlv2ResponseGrammar.this.createAndAddControl(container, response.getCurrentSearchResultReference());
        }
    };
    private final GrammarAction ldapResultControlValueCreation = new GrammarAction("Add ControlValue to Control for LDAP Result"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            AbstractDsmlMessageDecorator response = (AbstractDsmlMessageDecorator)container.getBatchResponse().getCurrentResponse();
            if (response instanceof SearchResponseDsml) {
                SearchResponse searchResponse = (SearchResponse)((Object)response.getDecorated());
                Dsmlv2ResponseGrammar.this.createAndAddControlValue(container, searchResponse.getSearchResultDone());
            } else {
                Dsmlv2ResponseGrammar.this.createAndAddControlValue(container, response);
            }
        }
    };
    private final GrammarAction searchResultEntryControlValueCreation = new GrammarAction("Add ControlValue to Control for Search Result Entry"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResponse response = (SearchResponse)container.getBatchResponse().getCurrentResponse().getDecorated();
            Dsmlv2ResponseGrammar.this.createAndAddControlValue(container, response.getCurrentSearchResultEntry());
        }
    };
    private final GrammarAction searchResultReferenceControlValueCreation = new GrammarAction("Add ControlValue to Control for Search Result Entry"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResponseDsml response = (SearchResponseDsml)container.getBatchResponse().getCurrentResponse();
            Dsmlv2ResponseGrammar.this.createAndAddControlValue(container, ((SearchResponse)((Object)response.getDecorated())).getCurrentSearchResultReference());
        }
    };
    private final GrammarAction ldapResultAddResultCode = new GrammarAction("Add ResultCode to LDAP Result"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            DsmlDecorator<? extends Response> ldapResponse = container.getBatchResponse().getCurrentResponse();
            LdapResult ldapResult = null;
            if (ldapResponse.getDecorated() instanceof SearchResponse) {
                SearchResponse searchResponse = (SearchResponse)ldapResponse.getDecorated();
                ldapResult = searchResponse.getSearchResultDone().getLdapResult();
            } else {
                ldapResult = ((ResultResponse)ldapResponse.getDecorated()).getLdapResult();
            }
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "code");
            if (attributeValue != null) {
                try {
                    ldapResult.setResultCode(ResultCodeEnum.getResultCode((int)Integer.parseInt(attributeValue)));
                }
                catch (NumberFormatException nfe) {
                    throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03009, (Object[])new Object[0]), xpp, (Throwable)nfe);
                }
            } else {
                throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03010, (Object[])new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "descr");
            if (attributeValue != null && !DSMLV2_DESCR_TAGS.contains(attributeValue)) {
                throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03011, (Object[])new Object[]{attributeValue}), xpp, null);
            }
        }
    };
    private final GrammarAction ldapResultAddErrorMessage = new GrammarAction("Add Error Message to LDAP Result"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            DsmlDecorator<? extends Response> ldapResponse = container.getBatchResponse().getCurrentResponse();
            LdapResult ldapResult = null;
            if (ldapResponse.getDecorated() instanceof SearchResponse) {
                SearchResponse searchResponse = (SearchResponse)ldapResponse.getDecorated();
                ldapResult = searchResponse.getSearchResultDone().getLdapResult();
            } else {
                ldapResult = ((ResultResponse)ldapResponse.getDecorated()).getLdapResult();
            }
            XmlPullParser xpp = container.getParser();
            try {
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    ldapResult.setDiagnosticMessage(nextText.trim());
                }
            }
            catch (IOException ioe) {
                throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03008, (Object[])new Object[]{ioe.getMessage()}), xpp, (Throwable)ioe);
            }
        }
    };
    private final GrammarAction ldapResultAddReferral = new GrammarAction("Add Referral to LDAP Result"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            block7: {
                DsmlDecorator<? extends Response> ldapResponse = container.getBatchResponse().getCurrentResponse();
                LdapResult ldapResult = null;
                if (ldapResponse.getDecorated() instanceof SearchResponse) {
                    SearchResponse searchResponse = (SearchResponse)ldapResponse.getDecorated();
                    ldapResult = searchResponse.getSearchResultDone().getLdapResult();
                } else {
                    ldapResult = ((ResultResponse)ldapResponse.getDecorated()).getLdapResult();
                }
                if (ldapResult.getReferral() == null) {
                    ldapResult.setReferral((Referral)new ReferralImpl());
                }
                XmlPullParser xpp = container.getParser();
                try {
                    String nextText = xpp.nextText();
                    if (nextText.equals("")) break block7;
                    try {
                        String urlStr = nextText.trim();
                        LdapUrl ldapUrl = new LdapUrl(urlStr);
                        ldapResult.getReferral().addLdapUrl(ldapUrl.toString());
                    }
                    catch (LdapURLEncodingException luee) {
                        throw new XmlPullParserException(luee.getMessage(), xpp, (Throwable)luee);
                    }
                }
                catch (IOException ioe) {
                    throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03008, (Object[])new Object[]{ioe.getMessage()}), xpp, (Throwable)ioe);
                }
            }
        }
    };
    private final GrammarAction searchResponseCreation = new GrammarAction("Create Search Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            XmlPullParser xpp = container.getParser();
            SearchResponse searchResponse = null;
            String attributeValue = xpp.getAttributeValue("", "requestID");
            searchResponse = attributeValue != null ? new SearchResponse(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp)) : new SearchResponse();
            container.getBatchResponse().addResponse(new SearchResponseDsml(container.getLdapCodecService(), (Message)searchResponse));
        }
    };
    private final GrammarAction searchResultEntryCreation = new GrammarAction("Add Search Result Entry to Search Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResultEntryDsml searchResultEntry = new SearchResultEntryDsml(container.getLdapCodecService(), (SearchResultEntry)new SearchResultEntryImpl());
            SearchResponseDsml searchResponse = (SearchResponseDsml)container.getBatchResponse().getCurrentResponse();
            searchResponse.addResponse(searchResultEntry);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                searchResultEntry.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "dn")) != null) {
                try {
                    searchResultEntry.setObjectName(new Dn(new String[]{attributeValue}));
                }
                catch (LdapInvalidDnException lide) {
                    throw new XmlPullParserException(lide.getMessage(), xpp, (Throwable)lide);
                }
            } else {
                throw new XmlPullParserException("dn attribute is required", xpp, null);
            }
        }
    };
    private final GrammarAction searchResultReferenceCreation = new GrammarAction("Add Search Result Reference to Search Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResultReferenceDsml searchResultReference = new SearchResultReferenceDsml(container.getLdapCodecService(), (SearchResultReference)new SearchResultReferenceImpl());
            SearchResponseDsml searchResponseDsml = (SearchResponseDsml)container.getBatchResponse().getCurrentResponse();
            searchResponseDsml.addResponse(searchResultReference);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                searchResultReference.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
        }
    };
    private final GrammarAction searchResultDoneCreation = new GrammarAction("Add Search Result Done to Search Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResultDoneDsml searchResultDone = new SearchResultDoneDsml(container.getLdapCodecService(), (SearchResultDone)new SearchResultDoneImpl());
            SearchResponseDsml searchResponseDsml = (SearchResponseDsml)container.getBatchResponse().getCurrentResponse();
            searchResponseDsml.addResponse(searchResultDone);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                searchResultDone.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    searchResultDone.getLdapResult().setMatchedDn(new Dn(new String[]{attributeValue}));
                }
                catch (LdapInvalidDnException lide) {
                    throw new XmlPullParserException(lide.getMessage(), xpp, (Throwable)lide);
                }
            }
        }
    };
    private final GrammarAction searchResultEntryAddAttr = new GrammarAction("Add Attr to Search Result Entry"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResponse searchResponse = (SearchResponse)container.getBatchResponse().getCurrentResponse().getDecorated();
            SearchResultEntryDsml searchResultEntry = searchResponse.getCurrentSearchResultEntry();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue != null) {
                try {
                    searchResultEntry.addAttribute(attributeValue);
                }
                catch (LdapException le) {
                    throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03012, (Object[])new Object[0]), xpp, (Throwable)le);
                }
            } else {
                throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03012, (Object[])new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction searchResultEntryAddValue = new GrammarAction("Add a Value to an Attr of a Search Result Entry"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResponse searchResponse = (SearchResponse)container.getBatchResponse().getCurrentResponse().getDecorated();
            SearchResultEntryDsml searchResultEntry = searchResponse.getCurrentSearchResultEntry();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                try {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        searchResultEntry.addAttributeValue(Base64.decode((char[])nextText.toCharArray()));
                    } else {
                        searchResultEntry.addAttributeValue(nextText);
                    }
                }
                catch (LdapException le) {
                    throw new XmlPullParserException(le.getMessage(), xpp, (Throwable)le);
                }
            }
            catch (IOException ioe) {
                throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03008, (Object[])new Object[]{ioe.getMessage()}), xpp, (Throwable)ioe);
            }
        }
    };
    private final GrammarAction searchResultReferenceAddRef = new GrammarAction("Add a Ref to a Search Result Reference"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResponse searchResponse = (SearchResponse)container.getBatchResponse().getCurrentResponse().getDecorated();
            SearchResultReferenceDsml searchResultReference = searchResponse.getCurrentSearchResultReference();
            XmlPullParser xpp = container.getParser();
            try {
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    LdapUrl ldapUrl = new LdapUrl(nextText);
                    searchResultReference.getReferral().addLdapUrl(ldapUrl.toString());
                }
            }
            catch (IOException ioe) {
                throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03008, (Object[])new Object[]{ioe.getMessage()}), xpp, (Throwable)ioe);
            }
            catch (LdapURLEncodingException luee) {
                throw new XmlPullParserException(luee.getMessage(), xpp, (Throwable)luee);
            }
        }
    };
    private final GrammarAction extendedResponseAddResultCode = this.ldapResultAddResultCode;
    private final GrammarAction extendedResponseAddErrorMessage = this.ldapResultAddErrorMessage;
    private final GrammarAction extendedResponseAddReferral = this.ldapResultAddReferral;
    private final GrammarAction extendedResponseAddResponseName = new GrammarAction("Add Response Name to Extended Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtendedResponse extendedResponse = (ExtendedResponse)container.getBatchResponse().getCurrentResponse();
            XmlPullParser xpp = container.getParser();
            try {
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    extendedResponse.setResponseName(Oid.fromString((String)nextText.trim()).toString());
                }
            }
            catch (IOException ioe) {
                throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03008, (Object[])new Object[]{ioe.getMessage()}), xpp, (Throwable)ioe);
            }
            catch (DecoderException de) {
                throw new XmlPullParserException(de.getMessage(), xpp, (Throwable)de);
            }
        }
    };
    private final GrammarAction extendedResponseAddResponse = new GrammarAction("Add Response to Extended Response"){

        @Override
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtendedResponseDsml extendedResponse = (ExtendedResponseDsml)container.getBatchResponse().getCurrentResponse();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                    extendedResponse.setResponseValue(Base64.decode((char[])nextText.trim().toCharArray()));
                } else {
                    extendedResponse.setResponseValue(Strings.getBytesUtf8((String)nextText.trim()));
                }
            }
            catch (IOException ioe) {
                throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03008, (Object[])new Object[]{ioe.getMessage()}), xpp, (Throwable)ioe);
            }
        }
    };

    private Dsmlv2ResponseGrammar() {
        this.name = Dsmlv2ResponseGrammar.class.getName();
        this.transitions = (HashMap[])Array.newInstance(HashMap.class, 300);
        this.transitions[Dsmlv2StatesEnum.INIT_GRAMMAR_STATE.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.INIT_GRAMMAR_STATE.ordinal()].put(new Tag("batchResponse", 0), new GrammarTransition(Dsmlv2StatesEnum.INIT_GRAMMAR_STATE, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, this.batchResponseCreation));
        this.transitions[Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP.ordinal()].put(new Tag("addResponse", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, Dsmlv2StatesEnum.LDAP_RESULT, this.addResponseCreation));
        this.transitions[Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP.ordinal()].put(new Tag("authResponse", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, Dsmlv2StatesEnum.LDAP_RESULT, this.authResponseCreation));
        this.transitions[Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP.ordinal()].put(new Tag("compareResponse", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, Dsmlv2StatesEnum.LDAP_RESULT, this.compareResponseCreation));
        this.transitions[Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP.ordinal()].put(new Tag("delResponse", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, Dsmlv2StatesEnum.LDAP_RESULT, this.delResponseCreation));
        this.transitions[Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP.ordinal()].put(new Tag("modifyResponse", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, Dsmlv2StatesEnum.LDAP_RESULT, this.modifyResponseCreation));
        this.transitions[Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP.ordinal()].put(new Tag("modDNResponse", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, Dsmlv2StatesEnum.LDAP_RESULT, this.modDNResponseCreation));
        this.transitions[Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP.ordinal()].put(new Tag("extendedResponse", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, Dsmlv2StatesEnum.EXTENDED_RESPONSE, this.extendedResponseCreation));
        this.transitions[Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP.ordinal()].put(new Tag("errorResponse", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, Dsmlv2StatesEnum.ERROR_RESPONSE, this.errorResponseCreation));
        this.transitions[Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP.ordinal()].put(new Tag("searchResponse", 0), new GrammarTransition(Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, Dsmlv2StatesEnum.SEARCH_RESPONSE, this.searchResponseCreation));
        this.transitions[Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP.ordinal()].put(new Tag("batchResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, Dsmlv2StatesEnum.GRAMMAR_END, null));
        this.transitions[Dsmlv2StatesEnum.ERROR_RESPONSE.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.MESSAGE_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.DETAIL_START.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.DETAIL_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.ERROR_RESPONSE.ordinal()].put(new Tag("message", 0), new GrammarTransition(Dsmlv2StatesEnum.ERROR_RESPONSE, Dsmlv2StatesEnum.MESSAGE_END, this.errorResponseAddMessage));
        this.transitions[Dsmlv2StatesEnum.ERROR_RESPONSE.ordinal()].put(new Tag("detail", 0), new GrammarTransition(Dsmlv2StatesEnum.ERROR_RESPONSE, Dsmlv2StatesEnum.DETAIL_START, ERROR_RESPONSE_ADD_DETAIL));
        this.transitions[Dsmlv2StatesEnum.MESSAGE_END.ordinal()].put(new Tag("errorResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.MESSAGE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.MESSAGE_END.ordinal()].put(new Tag("detail", 0), new GrammarTransition(Dsmlv2StatesEnum.MESSAGE_END, Dsmlv2StatesEnum.DETAIL_START, ERROR_RESPONSE_ADD_DETAIL));
        this.transitions[Dsmlv2StatesEnum.DETAIL_START.ordinal()].put(new Tag("detail", 1), new GrammarTransition(Dsmlv2StatesEnum.DETAIL_START, Dsmlv2StatesEnum.DETAIL_END, null));
        this.transitions[Dsmlv2StatesEnum.DETAIL_END.ordinal()].put(new Tag("detail", 1), new GrammarTransition(Dsmlv2StatesEnum.DETAIL_END, Dsmlv2StatesEnum.DETAIL_END, ERROR_RESPONSE_ADD_DETAIL));
        this.transitions[Dsmlv2StatesEnum.ERROR_RESPONSE.ordinal()].put(new Tag("errorResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.ERROR_RESPONSE, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_START.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_VALUE_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_START.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_ERROR_MESSAGE_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_REFERRAL_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.RESPONSE_NAME_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.RESPONSE_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE, Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_START, this.ldapResultControlCreation));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_START.ordinal()].put(new Tag("controlValue", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_START, Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_VALUE_END, this.ldapResultControlValueCreation));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_VALUE_END.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_VALUE_END, Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_END, null));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_START.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_START, Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_END, null));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_END.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_END, Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_START, this.ldapResultControlCreation));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_END.ordinal()].put(new Tag("resultCode", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_CONTROL_END, Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_START, this.extendedResponseAddResultCode));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE.ordinal()].put(new Tag("resultCode", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE, Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_START, this.extendedResponseAddResultCode));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_START.ordinal()].put(new Tag("resultCode", 1), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_START, Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_END, null));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_END.ordinal()].put(new Tag("errorMessage", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_END, Dsmlv2StatesEnum.EXTENDED_RESPONSE_ERROR_MESSAGE_END, this.extendedResponseAddErrorMessage));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_END.ordinal()].put(new Tag("referral", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_END, Dsmlv2StatesEnum.EXTENDED_RESPONSE_REFERRAL_END, this.extendedResponseAddReferral));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_END.ordinal()].put(new Tag("responseName", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_END, Dsmlv2StatesEnum.RESPONSE_NAME_END, this.extendedResponseAddResponseName));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_END.ordinal()].put(new Tag("response", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_END, Dsmlv2StatesEnum.RESPONSE_END, this.extendedResponseAddResponse));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_END.ordinal()].put(new Tag("extendedResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_RESULT_CODE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_ERROR_MESSAGE_END.ordinal()].put(new Tag("referral", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_ERROR_MESSAGE_END, Dsmlv2StatesEnum.EXTENDED_RESPONSE_REFERRAL_END, this.extendedResponseAddReferral));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_ERROR_MESSAGE_END.ordinal()].put(new Tag("responseName", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_ERROR_MESSAGE_END, Dsmlv2StatesEnum.RESPONSE_NAME_END, this.extendedResponseAddResponseName));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_ERROR_MESSAGE_END.ordinal()].put(new Tag("response", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_ERROR_MESSAGE_END, Dsmlv2StatesEnum.RESPONSE_END, this.extendedResponseAddResponse));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_ERROR_MESSAGE_END.ordinal()].put(new Tag("extendedResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_ERROR_MESSAGE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_REFERRAL_END.ordinal()].put(new Tag("referral", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_REFERRAL_END, Dsmlv2StatesEnum.EXTENDED_RESPONSE_REFERRAL_END, this.extendedResponseAddReferral));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_REFERRAL_END.ordinal()].put(new Tag("responseName", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_REFERRAL_END, Dsmlv2StatesEnum.RESPONSE_NAME_END, this.extendedResponseAddResponseName));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_REFERRAL_END.ordinal()].put(new Tag("reponse", 0), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_REFERRAL_END, Dsmlv2StatesEnum.RESPONSE_END, this.extendedResponseAddResponse));
        this.transitions[Dsmlv2StatesEnum.EXTENDED_RESPONSE_REFERRAL_END.ordinal()].put(new Tag("extendedResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.EXTENDED_RESPONSE_REFERRAL_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.RESPONSE_NAME_END.ordinal()].put(new Tag("response", 0), new GrammarTransition(Dsmlv2StatesEnum.RESPONSE_NAME_END, Dsmlv2StatesEnum.RESPONSE_END, this.extendedResponseAddResponse));
        this.transitions[Dsmlv2StatesEnum.RESPONSE_NAME_END.ordinal()].put(new Tag("extendedResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.RESPONSE_NAME_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.RESPONSE_END.ordinal()].put(new Tag("extendedResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.RESPONSE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_START.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_VALUE_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_START.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_DONE_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT, Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_START, this.ldapResultControlCreation));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT.ordinal()].put(new Tag("resultCode", 0), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT, Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_START, this.ldapResultAddResultCode));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_START.ordinal()].put(new Tag("controlValue", 0), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_START, Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_VALUE_END, this.ldapResultControlValueCreation));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_VALUE_END.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_VALUE_END, Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_END, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_START.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_START, Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_END, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_END.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_END, Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_START, this.ldapResultControlCreation));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_END.ordinal()].put(new Tag("resultCode", 0), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_CONTROL_END, Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_START, this.ldapResultAddResultCode));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_START.ordinal()].put(new Tag("resultCode", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_START, Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END.ordinal()].put(new Tag("errorMessage", 0), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END, Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END, this.ldapResultAddErrorMessage));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END.ordinal()].put(new Tag("referral", 0), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END, Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END, this.ldapResultAddReferral));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END.ordinal()].put(new Tag("addResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END.ordinal()].put(new Tag("authResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END.ordinal()].put(new Tag("compareResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END.ordinal()].put(new Tag("delResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END.ordinal()].put(new Tag("modifyResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END.ordinal()].put(new Tag("modDNResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END.ordinal()].put(new Tag("searchResultDone", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_RESULT_CODE_END, Dsmlv2StatesEnum.SEARCH_RESULT_DONE_END, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_DONE_END.ordinal()].put(new Tag("searchResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_DONE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END.ordinal()].put(new Tag("referral", 0), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END, Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END, this.ldapResultAddReferral));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END.ordinal()].put(new Tag("addResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END.ordinal()].put(new Tag("authResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END.ordinal()].put(new Tag("compareResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END.ordinal()].put(new Tag("delResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END.ordinal()].put(new Tag("modifyResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END.ordinal()].put(new Tag("modDNResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END.ordinal()].put(new Tag("searchResultDone", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_ERROR_MESSAGE_END, Dsmlv2StatesEnum.SEARCH_RESULT_DONE_END, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END.ordinal()].put(new Tag("referral", 0), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END, Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END, this.ldapResultAddReferral));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END.ordinal()].put(new Tag("addResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END.ordinal()].put(new Tag("authResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END.ordinal()].put(new Tag("compareResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END.ordinal()].put(new Tag("delResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END.ordinal()].put(new Tag("modifyResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END.ordinal()].put(new Tag("modDNResponse", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END.ordinal()].put(new Tag("searchResultDone", 1), new GrammarTransition(Dsmlv2StatesEnum.LDAP_RESULT_REFERRAL_END, Dsmlv2StatesEnum.SEARCH_RESULT_DONE_END, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESPONSE.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESPONSE.ordinal()].put(new Tag("searchResultEntry", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESPONSE, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY, this.searchResultEntryCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESPONSE.ordinal()].put(new Tag("searchResultReference", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESPONSE, Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE, this.searchResultReferenceCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESPONSE.ordinal()].put(new Tag("searchResultDone", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESPONSE, Dsmlv2StatesEnum.LDAP_RESULT, this.searchResultDoneCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_START.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_VALUE_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_START.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_VALUE_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_START, this.searchResultEntryControlCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY.ordinal()].put(new Tag("attr", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_START, this.searchResultEntryAddAttr));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY.ordinal()].put(new Tag("searchResultEntry", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_START.ordinal()].put(new Tag("controlValue", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_START, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_VALUE_END, this.searchResultEntryControlValueCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_VALUE_END.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_VALUE_END, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_END, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_START.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_START, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_END, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_END.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_END, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_START, this.searchResultEntryControlCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_END.ordinal()].put(new Tag("searchResultEntry", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_END, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_END.ordinal()].put(new Tag("attr", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_CONTROL_END, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_START, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_START.ordinal()].put(new Tag("attr", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_START, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_END, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_START.ordinal()].put(new Tag("value", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_START, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_VALUE_END, this.searchResultEntryAddValue));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_END.ordinal()].put(new Tag("attr", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_END, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_START, this.searchResultEntryAddAttr));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_END.ordinal()].put(new Tag("searchResultEntry", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_END, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_VALUE_END.ordinal()].put(new Tag("value", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_VALUE_END, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_VALUE_END, this.searchResultEntryAddValue));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_VALUE_END.ordinal()].put(new Tag("attr", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_VALUE_END, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_ATTR_END, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_LOOP.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_LOOP.ordinal()].put(new Tag("searchResultEntry", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_LOOP, Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY, this.searchResultEntryCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_LOOP.ordinal()].put(new Tag("searchResultReference", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_LOOP, Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE, this.searchResultReferenceCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_LOOP.ordinal()].put(new Tag("searchResultDone", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_ENTRY_LOOP, Dsmlv2StatesEnum.LDAP_RESULT, this.searchResultDoneCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_START.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_VALUE_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_REF_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE, Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_START, this.searchResultReferenceControlCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE.ordinal()].put(new Tag("ref", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE, Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_REF_END, this.searchResultReferenceAddRef));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_START.ordinal()].put(new Tag("controlValue", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_START, Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_VALUE_END, this.searchResultReferenceControlValueCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_VALUE_END.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_VALUE_END, Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_END, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_START.ordinal()].put(new Tag("control", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_START, Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_END, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_END.ordinal()].put(new Tag("control", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_END, Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_START, this.searchResultReferenceControlCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_END.ordinal()].put(new Tag("ref", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_CONTROL_END, Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_REF_END, this.searchResultReferenceAddRef));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_REF_END.ordinal()].put(new Tag("ref", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_REF_END, Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_REF_END, this.searchResultReferenceAddRef));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_REF_END.ordinal()].put(new Tag("searchResultReference", 1), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_REF_END, Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_LOOP, null));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_LOOP.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_LOOP.ordinal()].put(new Tag("searchResultReference", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_LOOP, Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE, this.searchResultReferenceCreation));
        this.transitions[Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_LOOP.ordinal()].put(new Tag("searchResultDone", 0), new GrammarTransition(Dsmlv2StatesEnum.SEARCH_RESULT_REFERENCE_LOOP, Dsmlv2StatesEnum.LDAP_RESULT, this.searchResultDoneCreation));
        this.transitions[Dsmlv2StatesEnum.SOAP_ENVELOPE_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SOAP_HEADER_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SOAP_HEADER_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SOAP_BODY_START_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.SOAP_BODY_END_TAG.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.GRAMMAR_END.ordinal()] = new HashMap();
        this.transitions[Dsmlv2StatesEnum.INIT_GRAMMAR_STATE.ordinal()].put(new Tag("envelope", 0), new GrammarTransition(Dsmlv2StatesEnum.INIT_GRAMMAR_STATE, Dsmlv2StatesEnum.SOAP_ENVELOPE_START_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SOAP_ENVELOPE_START_TAG.ordinal()].put(new Tag("header", 0), new GrammarTransition(Dsmlv2StatesEnum.SOAP_ENVELOPE_START_TAG, Dsmlv2StatesEnum.SOAP_HEADER_START_TAG, ParserUtils.READ_SOAP_HEADER));
        this.transitions[Dsmlv2StatesEnum.SOAP_HEADER_START_TAG.ordinal()].put(new Tag("header", 1), new GrammarTransition(Dsmlv2StatesEnum.SOAP_HEADER_START_TAG, Dsmlv2StatesEnum.SOAP_HEADER_END_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SOAP_HEADER_END_TAG.ordinal()].put(new Tag("body", 0), new GrammarTransition(Dsmlv2StatesEnum.SOAP_HEADER_END_TAG, Dsmlv2StatesEnum.SOAP_BODY_START_TAG, null));
        this.transitions[Dsmlv2StatesEnum.SOAP_BODY_START_TAG.ordinal()].put(new Tag("batchResponse", 0), new GrammarTransition(Dsmlv2StatesEnum.SOAP_BODY_START_TAG, Dsmlv2StatesEnum.BATCH_RESPONSE_LOOP, this.batchResponseCreation));
        this.transitions[Dsmlv2StatesEnum.SOAP_ENVELOPE_START_TAG.ordinal()].put(new Tag("body", 0), new GrammarTransition(Dsmlv2StatesEnum.SOAP_ENVELOPE_START_TAG, Dsmlv2StatesEnum.SOAP_BODY_START_TAG, null));
        this.transitions[Dsmlv2StatesEnum.GRAMMAR_END.ordinal()].put(new Tag("body", 1), new GrammarTransition(Dsmlv2StatesEnum.GRAMMAR_END, Dsmlv2StatesEnum.GRAMMAR_END, null));
        this.transitions[Dsmlv2StatesEnum.GRAMMAR_END.ordinal()].put(new Tag("envelope", 1), new GrammarTransition(Dsmlv2StatesEnum.GRAMMAR_END, Dsmlv2StatesEnum.GRAMMAR_END, null));
    }

    private void createAndAddControl(Dsmlv2Container container, AbstractDsmlMessageDecorator<? extends Message> parent) throws XmlPullParserException {
        CodecControl control = null;
        XmlPullParser xpp = container.getParser();
        String attributeValue = xpp.getAttributeValue("", "type");
        if (attributeValue != null) {
            if (!Oid.isOid((String)attributeValue)) {
                throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03006, (Object[])new Object[0]), xpp, null);
            }
        } else {
            throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03005, (Object[])new Object[0]), xpp, null);
        }
        control = container.getLdapCodecService().newControl((Control)new OpaqueControl(attributeValue));
        parent.addControl((Control)control);
        attributeValue = xpp.getAttributeValue("", "criticality");
        if (attributeValue != null) {
            if (attributeValue.equals("true")) {
                control.setCritical(true);
            } else if (attributeValue.equals("false")) {
                control.setCritical(false);
            } else {
                throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03007, (Object[])new Object[0]), xpp, null);
            }
        }
    }

    private void createAndAddControlValue(Dsmlv2Container container, AbstractDsmlMessageDecorator<? extends Message> parent) throws XmlPullParserException {
        DsmlControl<Control> control = parent.getCurrentControl();
        XmlPullParser xpp = container.getParser();
        try {
            String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
            String nextText = xpp.nextText();
            if (!nextText.equals("")) {
                if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                    control.setValue(Base64.decode((char[])nextText.trim().toCharArray()));
                } else {
                    control.setValue(Strings.getBytesUtf8((String)nextText.trim()));
                }
            }
        }
        catch (IOException ioe) {
            throw new XmlPullParserException(I18n.err((I18n)I18n.ERR_03008, (Object[])new Object[]{ioe.getMessage()}), xpp, (Throwable)ioe);
        }
    }

    public static Dsmlv2ResponseGrammar getInstance() {
        return instance;
    }

    static {
        DSMLV2_DESCR_TAGS.add("success");
        DSMLV2_DESCR_TAGS.add("operationsError");
        DSMLV2_DESCR_TAGS.add("protocolError");
        DSMLV2_DESCR_TAGS.add("timeLimitExceeded");
        DSMLV2_DESCR_TAGS.add("sizeLimitExceeded");
        DSMLV2_DESCR_TAGS.add("compareFalse");
        DSMLV2_DESCR_TAGS.add("compareTrue");
        DSMLV2_DESCR_TAGS.add("authMethodNotSupported");
        DSMLV2_DESCR_TAGS.add("strongAuthRequired");
        DSMLV2_DESCR_TAGS.add("referral");
        DSMLV2_DESCR_TAGS.add("adminLimitExceeded");
        DSMLV2_DESCR_TAGS.add("unavailableCriticalExtension");
        DSMLV2_DESCR_TAGS.add("confidentialityRequired");
        DSMLV2_DESCR_TAGS.add("saslBindInProgress");
        DSMLV2_DESCR_TAGS.add("noSuchAttribute");
        DSMLV2_DESCR_TAGS.add("undefinedAttributeType");
        DSMLV2_DESCR_TAGS.add("inappropriateMatching");
        DSMLV2_DESCR_TAGS.add("constraintViolation");
        DSMLV2_DESCR_TAGS.add("attributeOrValueExists");
        DSMLV2_DESCR_TAGS.add("invalidAttributeSyntax");
        DSMLV2_DESCR_TAGS.add("noSuchObject");
        DSMLV2_DESCR_TAGS.add("aliasProblem");
        DSMLV2_DESCR_TAGS.add("invalidDNSyntax");
        DSMLV2_DESCR_TAGS.add("aliasDereferencingProblem");
        DSMLV2_DESCR_TAGS.add("inappropriateAuthentication");
        DSMLV2_DESCR_TAGS.add("invalidCredentials");
        DSMLV2_DESCR_TAGS.add("insufficientAccessRights");
        DSMLV2_DESCR_TAGS.add("busy");
        DSMLV2_DESCR_TAGS.add("unavailable");
        DSMLV2_DESCR_TAGS.add("unwillingToPerform");
        DSMLV2_DESCR_TAGS.add("loopDetect");
        DSMLV2_DESCR_TAGS.add("namingViolation");
        DSMLV2_DESCR_TAGS.add("objectClassViolation");
        DSMLV2_DESCR_TAGS.add("notAllowedOnNonLeaf");
        DSMLV2_DESCR_TAGS.add("notAllowedOnRDN");
        DSMLV2_DESCR_TAGS.add("entryAlreadyExists");
        DSMLV2_DESCR_TAGS.add("objectClassModsProhibited");
        DSMLV2_DESCR_TAGS.add("affectMultipleDSAs");
        DSMLV2_DESCR_TAGS.add("other");
        ERROR_RESPONSE_ADD_DETAIL = null;
    }
}

