/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.aci.UserClass;

public class ACITuple
implements Serializable {
    private static final long serialVersionUID = 4353150626941232371L;
    private final Collection userClasses;
    private final AuthenticationLevel authenticationLevel;
    private final Collection protectedItems;
    private final Set microOperations;
    private final boolean grant;
    private final int precedence;

    public ACITuple(Collection userClasses, AuthenticationLevel authenticationLevel, Collection protectedItems, Set microOperations, boolean grant, int precedence) {
        Iterator i = userClasses.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof UserClass) continue;
            throw new IllegalArgumentException("userClasses contains an element which is not a user classs.");
        }
        i = protectedItems.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof ProtectedItem) continue;
            throw new IllegalArgumentException("protectedItems contains an element which is not a protected item.");
        }
        i = microOperations.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof MicroOperation) continue;
            throw new IllegalArgumentException("microOperations contains an element which is not a micro operation.");
        }
        if (authenticationLevel == null) {
            throw new NullPointerException("authenticationLevel");
        }
        if (precedence < 0 || precedence > 255) {
            throw new IllegalArgumentException("precedence: " + precedence);
        }
        this.userClasses = Collections.unmodifiableCollection(new ArrayList(userClasses));
        this.authenticationLevel = authenticationLevel;
        this.protectedItems = Collections.unmodifiableCollection(new ArrayList(protectedItems));
        this.microOperations = Collections.unmodifiableSet(new HashSet(microOperations));
        this.grant = grant;
        this.precedence = precedence;
    }

    public Collection getUserClasses() {
        return this.userClasses;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public Collection getProtectedItems() {
        return this.protectedItems;
    }

    public Set getMicroOperations() {
        return this.microOperations;
    }

    public boolean isGrant() {
        return this.grant;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public String toString() {
        return "ACITuple: userClasses=" + this.userClasses + ", " + "authenticationLevel=" + this.authenticationLevel + ", " + "protectedItems=" + this.protectedItems + ", " + (this.grant ? "grants=" : "denials=") + this.microOperations + ", " + "precedence=" + this.precedence;
    }
}

