/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntry;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultAttributeValueAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchResultAttributeValueAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public SearchResultAttributeValueAction() {
        super("Stores AttributeValue");
    }

    public void action(IAsn1Container container) {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchResultEntry searchResultEntry = ldapMessage.getSearchResultEntry();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        Object value = null;
        if (tlv.getLength() == 0) {
            searchResultEntry.addAttributeValue("");
            log.debug("The attribute value is null");
        } else {
            if (ldapMessageContainer.isBinary(searchResultEntry.getCurrentAttributeValueType())) {
                value = tlv.getValue().getData();
                if (IS_DEBUG) {
                    log.debug("Attribute value {}", (Object)StringTools.dumpBytes(value));
                }
            } else {
                value = StringTools.utf8ToString(tlv.getValue().getData());
                log.debug("Attribute value {}", value);
            }
            searchResultEntry.addAttributeValue(value);
        }
        ldapMessageContainer.grammarEndAllowed(true);
    }
}

