/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.search.controls.ChangeType;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

public class EntryChangeControl
extends Asn1Object {
    public static final int UNDEFINED_CHANGE_NUMBER = -1;
    private ChangeType changeType = ChangeType.ADD;
    private int changeNumber = -1;
    private LdapDN previousDn = null;
    private transient byte[] previousDnBytes = null;
    private transient int eccSeqLength;

    public int computeLength() {
        int changeTypesLength = 3;
        int previousDnLength = 0;
        int changeNumberLength = 0;
        if (this.previousDn != null) {
            this.previousDnBytes = StringTools.getBytesUtf8(this.previousDn.getUpName());
            previousDnLength = 1 + TLV.getNbBytes((int)this.previousDnBytes.length) + this.previousDnBytes.length;
        }
        if (this.changeNumber != -1) {
            changeNumberLength = 2 + Value.getNbBytes((int)this.changeNumber);
        }
        this.eccSeqLength = changeTypesLength + previousDnLength + changeNumberLength;
        return 1 + TLV.getNbBytes((int)this.eccSeqLength) + this.eccSeqLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put((byte)48);
        bb.put(TLV.getBytes((int)this.eccSeqLength));
        bb.put((byte)10);
        bb.put((byte)1);
        bb.put(Value.getBytes((int)this.changeType.getValue()));
        if (this.previousDn != null) {
            Value.encode((ByteBuffer)bb, (byte[])this.previousDnBytes);
        }
        if (this.changeNumber != -1) {
            Value.encode((ByteBuffer)bb, (int)this.changeNumber);
        }
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Entry Change Control\n");
        sb.append("        changeType   : '").append(this.changeType).append("'\n");
        sb.append("        previousDN   : '").append(this.previousDn).append("'\n");
        if (this.changeNumber == -1) {
            sb.append("        changeNumber : '").append("UNDEFINED").append("'\n");
        } else {
            sb.append("        changeNumber : '").append(this.changeNumber).append("'\n");
        }
        return sb.toString();
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public LdapDN getPreviousDn() {
        return this.previousDn;
    }

    public void setPreviousDn(LdapDN previousDn) {
        this.previousDn = previousDn;
    }

    public int getChangeNumber() {
        return this.changeNumber;
    }

    public void setChangeNumber(int changeNumber) {
        this.changeNumber = changeNumber;
    }
}

