/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.util.Base64;

public class LdifUtils {
    private static boolean[] LDIF_SAFE_STARTING_CHAR_ALPHABET;
    private static boolean[] LDIF_SAFE_OTHER_CHARS_ALPHABET;

    public static boolean isLDIFSafe(String str) {
        char currentChar = str.charAt(0);
        if (currentChar > '\u007f' || !LDIF_SAFE_STARTING_CHAR_ALPHABET[currentChar]) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            currentChar = str.charAt(i);
            if (currentChar <= '\u007f' && LDIF_SAFE_OTHER_CHARS_ALPHABET[currentChar]) continue;
            return false;
        }
        return currentChar != ' ';
    }

    public static String convertToLdif(Attributes attrs) throws NamingException {
        StringBuffer sb = new StringBuffer();
        NamingEnumeration<? extends Attribute> ne = attrs.getAll();
        while (ne.hasMore()) {
            Attribute attribute = ne.next();
            if (!(attribute instanceof Attribute)) continue;
            sb.append(LdifUtils.convertToLdif(attribute));
        }
        return sb.toString();
    }

    private static String convertToLdif(Attribute attr) throws NamingException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < attr.size(); ++i) {
            StringBuffer lineBuffer = new StringBuffer();
            lineBuffer.append(attr.getID());
            Object value = attr.get(i);
            if (value instanceof byte[]) {
                char[] encoded = Base64.encode((byte[])value);
                lineBuffer.append(":: " + new String(encoded));
            } else if (value instanceof String) {
                String str = (String)value;
                if (!LdifUtils.isLDIFSafe(str)) {
                    char[] encoded = Base64.encode(((String)value).getBytes());
                    lineBuffer.append(":: " + new String(encoded));
                } else {
                    lineBuffer.append(": " + value);
                }
            }
            lineBuffer.append("\n");
            sb.append(LdifUtils.stripLineToNChars(lineBuffer.toString(), 80));
        }
        return sb.toString();
    }

    private static String stripLineToNChars(String str, int nbChars) {
        int i;
        if (str.length() <= nbChars) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        boolean firstPass = true;
        for (i = 0; i < str.length() - nbChars; i += nbChars) {
            String substr;
            if (firstPass) {
                substr = str.substring(i, i + nbChars);
                firstPass = false;
                --nbChars;
            } else {
                substr = str.substring(i, i + nbChars);
            }
            sb.append(substr + "\n ");
        }
        sb.append(str.substring(i, str.length()));
        return sb.toString();
    }

    static {
        int i;
        LDIF_SAFE_STARTING_CHAR_ALPHABET = new boolean[128];
        LDIF_SAFE_OTHER_CHARS_ALPHABET = new boolean[128];
        for (i = 0; i < 128; ++i) {
            LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[i] = true;
        }
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[0] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[10] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[13] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[32] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[58] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[60] = false;
        for (i = 0; i < 128; ++i) {
            LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[i] = true;
        }
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[0] = false;
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[10] = false;
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[13] = false;
    }
}

