/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import org.apache.directory.shared.ldap.message.IteratorNamingEnumeration;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockableAttributeImpl
implements Attribute {
    private static final Logger log = LoggerFactory.getLogger((Class)LockableAttributeImpl.class);
    private static final long serialVersionUID = -5158233254341746514L;
    private final String upId;
    private Object value;
    private List list;
    private int size = 0;

    public LockableAttributeImpl(String id) {
        this.upId = id;
        this.value = null;
        this.list = null;
        this.size = 0;
    }

    public LockableAttributeImpl(String id, Object value) {
        this.upId = id;
        this.list = null;
        this.value = value;
        this.size = 1;
    }

    public LockableAttributeImpl(String id, byte[] value) {
        this.upId = id;
        this.list = null;
        this.value = value;
        this.size = 1;
    }

    private LockableAttributeImpl(String id, List list) {
        this.upId = id;
        this.list = list;
        this.value = null;
        this.size = list != null ? list.size() : 0;
    }

    public NamingEnumeration getAll() {
        if (this.size < 2) {
            return new IteratorNamingEnumeration(new Iterator(){
                private boolean done;
                {
                    this.done = LockableAttributeImpl.this.size != 0;
                }

                public boolean hasNext() {
                    return this.done;
                }

                public Object next() {
                    this.done = false;
                    return LockableAttributeImpl.this.value;
                }

                public void remove() {
                    LockableAttributeImpl.this.value = null;
                    this.done = false;
                    LockableAttributeImpl.this.size = 0;
                }
            });
        }
        return new IteratorNamingEnumeration(this.list.iterator());
    }

    public Object get() {
        if (this.list == null) {
            return this.value;
        }
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(0);
    }

    public int size() {
        return this.size;
    }

    public String getID() {
        return this.upId;
    }

    public boolean contains(Object attrVal) {
        switch (this.size) {
            case 0: {
                return false;
            }
            case 1: {
                return this.value == null ? attrVal == null : this.value.equals(attrVal);
            }
        }
        return this.list.contains(attrVal);
    }

    public boolean add(Object attrVal) {
        boolean exists = false;
        switch (this.size) {
            case 0: {
                this.value = attrVal;
                ++this.size;
                return true;
            }
            case 1: {
                exists = this.value.equals(attrVal);
                this.list = new ArrayList();
                this.list.add(this.value);
                this.list.add(attrVal);
                ++this.size;
                this.value = null;
                return exists;
            }
        }
        exists = this.list.contains(attrVal);
        this.list.add(attrVal);
        ++this.size;
        return exists;
    }

    public boolean remove(Object attrVal) {
        switch (this.size) {
            case 0: {
                return false;
            }
            case 1: {
                this.value = null;
                --this.size;
                return true;
            }
            case 2: {
                this.list.remove(attrVal);
                this.value = this.list.get(0);
                this.size = 1;
                this.list = null;
                return true;
            }
        }
        this.list.remove(attrVal);
        --this.size;
        return true;
    }

    public void clear() {
        switch (this.size) {
            case 0: {
                return;
            }
            case 1: {
                this.value = null;
                this.size = 0;
                return;
            }
        }
        this.list = null;
        this.size = 0;
    }

    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException("Extending subclasses may override this if they like!");
    }

    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException("Extending subclasses may override this if they like!");
    }

    public Object clone() {
        switch (this.size) {
            case 0: {
                return new LockableAttributeImpl(this.upId);
            }
            case 1: {
                return new LockableAttributeImpl(this.upId, this.value);
            }
        }
        return new LockableAttributeImpl(this.upId, (List)((ArrayList)this.list).clone());
    }

    public boolean isOrdered() {
        return true;
    }

    public Object get(int index) {
        switch (this.size) {
            case 0: {
                return null;
            }
            case 1: {
                return this.value;
            }
        }
        return this.list.get(index);
    }

    public Object remove(int index) {
        switch (this.size) {
            case 0: {
                return null;
            }
            case 1: {
                Object result = this.value;
                this.value = null;
                this.size = 0;
                return result;
            }
        }
        --this.size;
        return this.list.remove(index);
    }

    public void add(int index, Object attrVal) {
        switch (this.size) {
            case 0: {
                ++this.size;
                this.value = attrVal;
                return;
            }
            case 1: {
                this.list = new ArrayList();
                if (index == 0) {
                    this.list.add(attrVal);
                    this.list.add(this.value);
                } else {
                    this.list.add(this.value);
                    this.list.add(attrVal);
                }
                ++this.size;
                this.value = null;
                return;
            }
        }
        this.list.add(index, attrVal);
        ++this.size;
    }

    public Object set(int index, Object attrVal) {
        switch (this.size) {
            case 0: {
                ++this.size;
                this.value = attrVal;
                return null;
            }
            case 1: {
                if (index == 0) {
                    Object result = this.value;
                    this.value = attrVal;
                    return result;
                }
                this.list = new ArrayList();
                this.list.add(this.value);
                this.list.add(attrVal);
                this.size = 2;
                this.value = null;
                return null;
            }
        }
        Object oldValue = this.list.get(index);
        this.list.set(index, attrVal);
        return oldValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute attr = (Attribute)obj;
        if (!this.upId.equals(attr.getID())) {
            return false;
        }
        if (attr.size() != this.size) {
            return false;
        }
        switch (this.size) {
            case 0: {
                return true;
            }
            case 1: {
                try {
                    return this.value.equals(attr.get(0));
                }
                catch (NamingException e) {
                    log.warn("Failed to get an attribute from the specifid attribute: " + attr, (Throwable)e);
                    return false;
                }
            }
        }
        for (int i = 0; i < this.size; ++i) {
            try {
                if (this.list.contains(attr.get(i))) continue;
                return false;
            }
            catch (NamingException e) {
                log.warn("Failed to get an attribute from the specifid attribute: " + attr, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Attribute id : '").append(this.upId).append("', ");
        sb.append(" Values : [");
        switch (this.size) {
            case 0: {
                sb.append("]\n");
                break;
            }
            case 1: {
                if (this.value instanceof String) {
                    sb.append('\'').append(this.value).append('\'');
                } else {
                    sb.append(StringTools.dumpBytes((byte[])this.value));
                }
                sb.append("]\n");
                break;
            }
            default: {
                boolean isFirst = true;
                Iterator values = this.list.iterator();
                while (values.hasNext()) {
                    Object v = values.next();
                    if (!isFirst) {
                        sb.append(", ");
                    } else {
                        isFirst = false;
                    }
                    if (v instanceof String) {
                        sb.append('\'').append(v).append('\'');
                        continue;
                    }
                    sb.append(StringTools.dumpBytes((byte[])v));
                }
                sb.append("]\n");
            }
        }
        return sb.toString();
    }
}

