/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.extended;

import org.apache.directory.shared.ldap.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class GracefulShutdownResponse
extends ExtendedResponseImpl {
    private static final long serialVersionUID = -3824715470944544189L;
    public static final String EXTENSION_OID = "1.2.6.1.4.1.18060.1.1.1.100.4";
    private static final byte[] EMPTY_RESPONSE = new byte[0];

    public GracefulShutdownResponse(int messageId, ResultCodeEnum rcode) {
        super(messageId);
        switch (rcode.getValue()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 50: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The result code can only be one of: " + ResultCodeEnum.SUCCESS + ", " + ResultCodeEnum.OPERATIONSERROR + ", " + ResultCodeEnum.INSUFFICIENTACCESSRIGHTS);
            }
        }
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public GracefulShutdownResponse(int messageId) {
        super(messageId);
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    public byte[] getResponse() {
        return EMPTY_RESPONSE;
    }

    public void setResponse(byte[] value) {
    }

    public String getResponseName() {
        return EXTENSION_OID;
    }

    public void setResponseName(String oid) {
        throw new UnsupportedOperationException("the OID is fixed: 1.2.6.1.4.1.18060.1.1.1.100.4");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof GracefulShutdownResponse;
    }
}

