/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import org.apache.directory.shared.ldap.util.Position;
import org.apache.directory.shared.ldap.util.StringTools;

public class DNUtils {
    public static final int PARSING_ERROR = -1;
    public static final int PARSING_OK = 0;
    public static final int BAD_HEX_PAIR = -2;
    public static final int ONE_CHAR = 1;
    public static final int TWO_CHARS = 2;
    public static final int ONE_BYTE = 1;
    public static final int TWO_BYTES = 2;
    private static final boolean[] SAFE_INIT_CHAR = new boolean[]{false, true, true, true, true, true, true, true, true, true, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] SAFE_CHAR = new boolean[]{false, true, true, true, true, true, true, true, true, true, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] BASE64_CHAR = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private static final boolean[] PAIR_CHAR = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, true, false, false, false, false, false, false, false, true, true, false, false, false, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final int[] STRING_CHAR = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 1, 1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, 1};
    public static final String OID_LOWER = "oid.";
    public static final String OID_UPPER = "OID.";
    public static final byte[] OID_LOWER_BYTES = new byte[]{111, 105, 100, 46};
    public static final byte[] OID_UPPER_BYTES = new byte[]{79, 73, 68, 46};

    public static int parseSafeString(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return -1;
        }
        byte c = byteArray[index];
        if (c > 127 || !SAFE_INIT_CHAR[c]) {
            return -1;
        }
        ++index;
        while (index < byteArray.length && (c = byteArray[index]) <= 127 && SAFE_CHAR[c]) {
            ++index;
        }
        return index;
    }

    public static int parseAlphaASCII(byte[] byteArray, int index) {
        byte c;
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return -1;
        }
        if ((c = byteArray[index++]) > 127 || !StringTools.ALPHA[c]) {
            return -1;
        }
        return index;
    }

    public static int parseAlphaASCII(char[] charArray, int index) {
        char c;
        if (charArray == null || charArray.length == 0 || index < 0 || index >= charArray.length) {
            return -1;
        }
        if ((c = charArray[index++]) > '\u007f' || !StringTools.ALPHA[c]) {
            return -1;
        }
        return index;
    }

    public static boolean isPairChar(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        byte c = byteArray[index];
        if (c > 127 || !PAIR_CHAR[c]) {
            return false;
        }
        if (StringTools.isHex(byteArray, index++)) {
            return StringTools.isHex(byteArray, index);
        }
        return true;
    }

    public static boolean isPairChar(char[] charArray, int index) {
        if (charArray == null || charArray.length == 0 || index < 0 || index >= charArray.length) {
            return false;
        }
        char c = charArray[index];
        if (c > '\u007f' || !PAIR_CHAR[c]) {
            return false;
        }
        if (StringTools.isHex(charArray, index++)) {
            return StringTools.isHex(charArray, index);
        }
        return true;
    }

    public static int isPairChar(String string, int index) {
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return -1;
        }
        char c = string.charAt(index);
        if (c > '\u007f' || !PAIR_CHAR[c]) {
            return -1;
        }
        if (StringTools.isHex(string, index++)) {
            return StringTools.isHex(string, index) ? 2 : -1;
        }
        return 1;
    }

    public static int isStringChar(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return -1;
        }
        byte c = byteArray[index];
        if (c < 64) {
            return STRING_CHAR[c];
        }
        return StringTools.countBytesPerChar(byteArray, index);
    }

    public static int isStringChar(char[] charArray, int index) {
        if (charArray == null || charArray.length == 0 || index < 0 || index >= charArray.length) {
            return -1;
        }
        char c = charArray[index];
        if (c == '\n' || c == '\r' || c == '\"' || c == '#' || c == '+' || c == ',' || c == ';' || c == '<' || c == '=' || c == '>') {
            return -1;
        }
        return 1;
    }

    public static int isStringChar(String string, int index) {
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return -1;
        }
        char c = string.charAt(index);
        if (c < '@') {
            return STRING_CHAR[c];
        }
        return 1;
    }

    public static int isQuoteChar(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return -1;
        }
        byte c = byteArray[index];
        if (c == 92 || c == 34) {
            return -1;
        }
        return StringTools.countBytesPerChar(byteArray, index);
    }

    public static int isQuoteChar(char[] charArray, int index) {
        if (charArray == null || charArray.length == 0 || index < 0 || index >= charArray.length) {
            return -1;
        }
        char c = charArray[index];
        if (c == '\\' || c == '\"') {
            return -1;
        }
        return 1;
    }

    public static int isQuoteChar(String string, int index) {
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return -1;
        }
        char c = string.charAt(index);
        if (c == '\\' || c == '\"') {
            return -1;
        }
        return 1;
    }

    public static int parseHexPair(byte[] byteArray, int index) {
        if (StringTools.isHex(byteArray, index)) {
            if (StringTools.isHex(byteArray, index + 1)) {
                return index + 2;
            }
            return -2;
        }
        return -1;
    }

    public static int parseHexPair(char[] charArray, int index) {
        if (StringTools.isHex(charArray, index)) {
            if (StringTools.isHex(charArray, index + 1)) {
                return index + 2;
            }
            return -2;
        }
        return -1;
    }

    public static int parseHexPair(String string, int index) {
        if (StringTools.isHex(string, index)) {
            if (StringTools.isHex(string, index + 1)) {
                return index + 2;
            }
            return -2;
        }
        return -1;
    }

    private static byte getHexPair(String string, int index) {
        return (byte)(StringTools.HEX_VALUE[string.charAt(index)] << 4 | StringTools.HEX_VALUE[string.charAt(index + 1)]);
    }

    public static int parseHexString(byte[] byteArray, int index) {
        int result = DNUtils.parseHexPair(byteArray, index);
        if (result < 0) {
            return -1;
        }
        index += 2;
        while ((result = DNUtils.parseHexPair(byteArray, index)) >= 0) {
            index += 2;
        }
        return result == -2 ? -1 : index;
    }

    public static int parseHexString(char[] charArray, int index) {
        int result = DNUtils.parseHexPair(charArray, index);
        if (result < 0) {
            return -1;
        }
        index += 2;
        while ((result = DNUtils.parseHexPair(charArray, index)) >= 0) {
            index += 2;
        }
        return result == -2 ? -1 : index;
    }

    public static int parseHexString(String string, Position pos) {
        pos.end = pos.start;
        int result = DNUtils.parseHexPair(string, pos.start);
        if (result < 0) {
            return -1;
        }
        pos.end += 2;
        while ((result = DNUtils.parseHexPair(string, pos.end)) >= 0) {
            pos.end += 2;
        }
        return result == -2 ? -1 : 0;
    }

    public static int parseHexString(String string, byte[] hex, Position pos) {
        int i = 0;
        pos.end = pos.start;
        int result = DNUtils.parseHexPair(string, pos.start);
        if (result < 0) {
            return -1;
        }
        hex[i++] = DNUtils.getHexPair(string, pos.end);
        pos.end += 2;
        while ((result = DNUtils.parseHexPair(string, pos.end)) >= 0) {
            hex[i++] = DNUtils.getHexPair(string, pos.end);
            pos.end += 2;
        }
        return result == -2 ? -1 : 0;
    }

    public static int parseBase64String(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return -1;
        }
        byte c = byteArray[index];
        if (c > 127 || !BASE64_CHAR[c]) {
            return -1;
        }
        ++index;
        while (index < byteArray.length && (c = byteArray[index]) <= 127 && BASE64_CHAR[c]) {
            ++index;
        }
        return index;
    }
}

