/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.util;

import org.apache.directory.shared.i18n.I18n;

public class ByteBuffer {
    private static final int DEFAULT_INITIAL_SIZE = 10;
    private final int initialSize;
    private int pos = 0;
    private byte[] buf;

    public ByteBuffer() {
        this(10);
    }

    public ByteBuffer(int initialSize) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04354, (Object[])new Object[0]));
        }
        this.initialSize = initialSize;
        this.buf = new byte[initialSize];
    }

    public final void clear() {
        this.pos = 0;
    }

    public final int position() {
        return this.pos;
    }

    public final int capacity() {
        return this.buf.length;
    }

    public final byte get(int ii) {
        return this.buf[ii];
    }

    public final byte[] buffer() {
        return this.buf;
    }

    public final byte[] copyOfUsedBytes() {
        byte[] copy = new byte[this.pos];
        System.arraycopy(this.buf, 0, copy, 0, this.pos);
        return copy;
    }

    public final void append(byte[] bytes) {
        for (byte b : bytes) {
            this.append(b);
        }
    }

    public final void append(byte bite) {
        if (this.pos >= this.buf.length) {
            this.growBuffer();
        }
        this.buf[this.pos] = bite;
        ++this.pos;
    }

    public final void append(int val) {
        if (this.pos >= this.buf.length) {
            this.growBuffer();
        }
        this.buf[this.pos] = (byte)val;
        ++this.pos;
    }

    private void growBuffer() {
        byte[] copy = new byte[this.buf.length + this.initialSize];
        System.arraycopy(this.buf, 0, copy, 0, this.pos);
        this.buf = copy;
    }
}

