/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.AlertGroupService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AlertType;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"ALERT_GROUP_TAG"}, position=1)
@RestController
@RequestMapping(value={"alert-group"})
public class AlertGroupController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(AlertGroupController.class);
    @Autowired
    private AlertGroupService alertGroupService;

    @ApiOperation(value="createAlertgroup", notes="CREATE_ALERT_GROUP_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupName", value="GROUP_NAME", required=true, dataType="String"), @ApiImplicitParam(name="groupType", value="GROUP_TYPE", required=true, dataType="AlertType"), @ApiImplicitParam(name="description", value="DESC", dataType="String")})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Result createAlertgroup(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="groupName") String groupName, @RequestParam(value="groupType") AlertType groupType, @RequestParam(value="description", required=false) String description) {
        logger.info("loginUser user {}, create alertgroup, groupName: {}, groupType: {}, desc: {}", new Object[]{loginUser.getUserName(), groupName, groupType, description});
        try {
            Map<String, Object> result = this.alertGroupService.createAlertgroup(loginUser, groupName, groupType, description);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.CREATE_ALERT_GROUP_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.CREATE_ALERT_GROUP_ERROR.getCode(), Status.CREATE_ALERT_GROUP_ERROR.getMsg());
        }
    }

    @ApiOperation(value="list", notes="QUERY_ALERT_GROUP_LIST_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result list(@ApiIgnore @RequestAttribute(value="session.user") User loginUser) {
        logger.info("login  user {}, query all alertGroup", (Object)loginUser.getUserName());
        try {
            HashMap<String, Object> result = this.alertGroupService.queryAlertgroup();
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_ALL_ALERTGROUP_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_ALL_ALERTGROUP_ERROR.getCode(), Status.QUERY_ALL_ALERTGROUP_ERROR.getMsg());
        }
    }

    @ApiOperation(value="queryAlertGroupListPaging", notes="QUERY_ALERT_GROUP_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", type="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataType="Int", example="20")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result listPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        logger.info("login  user {}, list paging, pageNo: {}, searchVal: {}, pageSize: {}", new Object[]{loginUser.getUserName(), pageNo, searchVal, pageSize});
        try {
            Map<String, Object> result = this.checkPageParams(pageNo, pageSize);
            if (result.get("status") != Status.SUCCESS) {
                return this.returnDataListPaging(result);
            }
            searchVal = ParameterUtils.handleEscapes((String)searchVal);
            result = this.alertGroupService.listPaging(loginUser, searchVal, pageNo, pageSize);
            return this.returnDataListPaging(result);
        }
        catch (Exception e) {
            logger.error(Status.LIST_PAGING_ALERT_GROUP_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.LIST_PAGING_ALERT_GROUP_ERROR.getCode(), Status.LIST_PAGING_ALERT_GROUP_ERROR.getMsg());
        }
    }

    @ApiOperation(value="updateAlertgroup", notes="UPDATE_ALERT_GROUP_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ALERT_GROUP_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="groupName", value="GROUP_NAME", required=true, dataType="String"), @ApiImplicitParam(name="groupType", value="GROUP_TYPE", required=true, dataType="AlertType"), @ApiImplicitParam(name="description", value="DESC", dataType="String")})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result updateAlertgroup(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id, @RequestParam(value="groupName") String groupName, @RequestParam(value="groupType") AlertType groupType, @RequestParam(value="description", required=false) String description) {
        logger.info("login  user {}, updateProcessInstance alertgroup, groupName: {}, groupType: {}, desc: {}", new Object[]{loginUser.getUserName(), groupName, groupType, description});
        try {
            Map<String, Object> result = this.alertGroupService.updateAlertgroup(loginUser, id, groupName, groupType, description);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.UPDATE_ALERT_GROUP_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.UPDATE_ALERT_GROUP_ERROR.getCode(), Status.UPDATE_ALERT_GROUP_ERROR.getMsg());
        }
    }

    @ApiOperation(value="delAlertgroupById", notes="DELETE_ALERT_GROUP_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ALERT_GROUP_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result delAlertgroupById(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") int id) {
        logger.info("login user {}, delete AlertGroup, id: {},", (Object)loginUser.getUserName(), (Object)id);
        try {
            Map<String, Object> result = this.alertGroupService.delAlertgroupById(loginUser, id);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.DELETE_ALERT_GROUP_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.DELETE_ALERT_GROUP_ERROR.getCode(), Status.DELETE_ALERT_GROUP_ERROR.getMsg());
        }
    }

    @ApiOperation(value="verifyGroupName", notes="VERIFY_ALERT_GROUP_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupName", value="GROUP_NAME", required=true, dataType="String")})
    @GetMapping(value={"/verify-group-name"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result verifyGroupName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="groupName") String groupName) {
        logger.info("login user {}, verfiy group name: {}", (Object)loginUser.getUserName(), (Object)groupName);
        return this.alertGroupService.verifyGroupName(loginUser, groupName);
    }

    @ApiOperation(value="grantUser", notes="GRANT_ALERT_GROUP_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ALERT_GROUP_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="userIds", value="USER_IDS", required=true, dataType="String")})
    @PostMapping(value={"/grant-user"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result grantUser(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="alertgroupId") int alertgroupId, @RequestParam(value="userIds") String userIds) {
        logger.info("login user {}, grant user, alertGroupId: {},userIds : {}", new Object[]{loginUser.getUserName(), alertgroupId, userIds});
        try {
            Map<String, Object> result = this.alertGroupService.grantUser(loginUser, alertgroupId, userIds);
            return this.returnDataList(result);
        }
        catch (Exception e) {
            logger.error(Status.ALERT_GROUP_GRANT_USER_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.ALERT_GROUP_GRANT_USER_ERROR.getCode(), Status.ALERT_GROUP_GRANT_USER_ERROR.getMsg());
        }
    }
}

