/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.LoggerService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"LOGGER_TAG"}, position=13)
@RestController
@RequestMapping(value={"/log"})
public class LoggerController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(LoggerController.class);
    @Autowired
    private LoggerService loggerService;

    @ApiOperation(value="queryLog", notes="QUERY_TASK_INSTANCE_LOG_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskInstId", value="TASK_ID", dataType="Int", example="100"), @ApiImplicitParam(name="skipLineNum", value="SKIP_LINE_NUM", dataType="Int", example="100"), @ApiImplicitParam(name="limit", value="LIMIT", dataType="Int", example="100")})
    @GetMapping(value={"/detail"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryLog(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="taskInstId") int taskInstanceId, @RequestParam(value="skipLineNum") int skipNum, @RequestParam(value="limit") int limit) {
        try {
            logger.info("login user {}, view {} task instance log ,skipLineNum {} , limit {}", new Object[]{loginUser.getUserName(), taskInstanceId, skipNum, limit});
            return this.loggerService.queryLog(taskInstanceId, skipNum, limit);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_TASK_INSTANCE_LOG_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_TASK_INSTANCE_LOG_ERROR.getCode(), Status.QUERY_TASK_INSTANCE_LOG_ERROR.getMsg());
        }
    }

    @ApiOperation(value="downloadTaskLog", notes="DOWNLOAD_TASK_INSTANCE_LOG_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskInstId", value="TASK_ID", dataType="Int", example="100")})
    @GetMapping(value={"/download-log"})
    @ResponseBody
    public ResponseEntity downloadTaskLog(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="taskInstId") int taskInstanceId) {
        try {
            byte[] logBytes = this.loggerService.getLogBytes(taskInstanceId);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + System.currentTimeMillis() + ".log\""})).body((Object)logBytes);
        }
        catch (Exception e) {
            logger.error(Status.DOWNLOAD_TASK_INSTANCE_LOG_FILE_ERROR.getMsg(), (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)Status.DOWNLOAD_TASK_INSTANCE_LOG_FILE_ERROR.getMsg());
        }
    }
}

