/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.SessionService;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"LOGIN_TAG"}, position=1)
@RestController
@RequestMapping(value={""})
public class LoginController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private SessionService sessionService;
    @Autowired
    private UsersService userService;

    @ApiOperation(value="login", notes="LOGIN_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="USER_NAME", required=true, dataType="String"), @ApiImplicitParam(name="userPassword", value="USER_PASSWORD", required=true, dataType="String")})
    @PostMapping(value={"/login"})
    public Result login(@RequestParam(value="userName") String userName, @RequestParam(value="userPassword") String userPassword, HttpServletRequest request, HttpServletResponse response) {
        try {
            logger.info("login user name: {} ", (Object)userName);
            if (StringUtils.isEmpty((CharSequence)userName)) {
                return this.error(Status.USER_NAME_NULL.getCode(), Status.USER_NAME_NULL.getMsg());
            }
            String ip = LoginController.getClientIpAddress(request);
            if (StringUtils.isEmpty((CharSequence)ip)) {
                return this.error(Status.IP_IS_EMPTY.getCode(), Status.IP_IS_EMPTY.getMsg());
            }
            User user = this.userService.queryUser(userName, userPassword);
            if (user == null) {
                return this.error(Status.USER_NAME_PASSWD_ERROR.getCode(), Status.USER_NAME_PASSWD_ERROR.getMsg());
            }
            String sessionId = this.sessionService.createSession(user, ip);
            if (sessionId == null) {
                return this.error(Status.LOGIN_SESSION_FAILED.getCode(), Status.LOGIN_SESSION_FAILED.getMsg());
            }
            response.setStatus(200);
            response.addCookie(new Cookie("sessionId", sessionId));
            logger.info("sessionId : {}", (Object)sessionId);
            return this.success(Status.LOGIN_SUCCESS.getMsg(), sessionId);
        }
        catch (Exception e) {
            logger.error(Status.USER_LOGIN_FAILURE.getMsg(), (Throwable)e);
            return this.error(Status.USER_LOGIN_FAILURE.getCode(), Status.USER_LOGIN_FAILURE.getMsg());
        }
    }

    @ApiOperation(value="signOut", notes="SIGNOUT_NOTES")
    @PostMapping(value={"/signOut"})
    public Result signOut(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, HttpServletRequest request) {
        try {
            logger.info("login user:{} sign out", (Object)loginUser.getUserName());
            String ip = LoginController.getClientIpAddress(request);
            this.sessionService.signOut(ip, loginUser);
            request.removeAttribute("session.user");
            return this.success();
        }
        catch (Exception e) {
            logger.error(Status.SIGN_OUT_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.SIGN_OUT_ERROR.getCode(), Status.SIGN_OUT_ERROR.getMsg());
        }
    }
}

