/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.TaskInstanceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"TASK_INSTANCE_TAG"}, position=11)
@RestController
@RequestMapping(value={"/projects/{projectName}/task-instance"})
public class TaskInstanceController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(TaskInstanceController.class);
    @Autowired
    TaskInstanceService taskInstanceService;

    @ApiOperation(value="queryTaskListPaging", notes="QUERY_TASK_INSTANCE_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="PROCESS_INSTANCE_ID", required=false, dataType="Int", example="100"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", type="String"), @ApiImplicitParam(name="taskName", value="TASK_NAME", type="String"), @ApiImplicitParam(name="stateType", value="EXECUTION_STATUS", type="ExecutionStatus"), @ApiImplicitParam(name="host", value="HOST", type="String"), @ApiImplicitParam(name="startDate", value="START_DATE", type="String"), @ApiImplicitParam(name="endDate", value="END_DATE", type="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataType="Int", example="20")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result queryTaskListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectName", value="PROJECT_NAME", required=true) @PathVariable String projectName, @RequestParam(value="processInstanceId", required=false, defaultValue="0") Integer processInstanceId, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="taskName", required=false) String taskName, @RequestParam(value="stateType", required=false) ExecutionStatus stateType, @RequestParam(value="host", required=false) String host, @RequestParam(value="startDate", required=false) String startTime, @RequestParam(value="endDate", required=false) String endTime, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        try {
            logger.info("query task instance list, project name:{},process instance:{}, search value:{},task name:{}, state type:{}, host:{}, start:{}, end:{}", new Object[]{projectName, processInstanceId, searchVal, taskName, stateType, host, startTime, endTime});
            searchVal = ParameterUtils.handleEscapes((String)searchVal);
            Map<String, Object> result = this.taskInstanceService.queryTaskListPaging(loginUser, projectName, processInstanceId, taskName, startTime, endTime, searchVal, stateType, host, pageNo, pageSize);
            return this.returnDataListPaging(result);
        }
        catch (Exception e) {
            logger.error(Status.QUERY_TASK_LIST_PAGING_ERROR.getMsg(), (Throwable)e);
            return this.error(Status.QUERY_TASK_LIST_PAGING_ERROR.getCode(), Status.QUERY_TASK_LIST_PAGING_ERROR.getMsg());
        }
    }
}

