/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.interceptor;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.service.SessionService;
import org.apache.dolphinscheduler.dao.entity.Session;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LoginHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LoginHandlerInterceptor.class);
    @Autowired
    private SessionService sessionService;
    @Autowired
    private UserMapper userMapper;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String token = request.getHeader("token");
        User user = null;
        if (StringUtils.isEmpty((String)token)) {
            Session session = this.sessionService.getSession(request);
            if (session == null) {
                response.setStatus(401);
                logger.info("session info is null ");
                return false;
            }
            user = (User)this.userMapper.selectById((Serializable)Integer.valueOf(session.getUserId()));
            if (user == null) {
                response.setStatus(401);
                logger.info("user does not exist");
                return false;
            }
        } else {
            user = this.userMapper.queryUserByToken(token);
            if (user == null) {
                response.setStatus(401);
                logger.info("user token has expired");
                return false;
            }
        }
        request.setAttribute("session.user", (Object)user);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

