/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.service.ProcessDefinitionService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.RunMode;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExecutorService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorService.class);
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private ProcessDefinitionService processDefinitionService;
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private ProcessDao processDao;

    public Map<String, Object> execProcessInstance(User loginUser, String projectName, int processDefinitionId, String cronTime, CommandType commandType, FailureStrategy failureStrategy, String startNodeList, TaskDependType taskDependType, WarningType warningType, int warningGroupId, String receivers, String receiversCc, RunMode runMode, Priority processInstancePriority, int workerGroupId, Integer timeout) throws ParseException {
        Map<String, Object> result = new HashMap<String, Object>(5);
        if (timeout <= 0 || timeout > 86400) {
            this.putMsg(result, Status.TASK_TIMEOUT_PARAMS_ERROR, new Object[0]);
            return result;
        }
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResultAndAuth = this.checkResultAndAuth(loginUser, projectName, project);
        if (checkResultAndAuth != null) {
            return checkResultAndAuth;
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefinitionMapper.selectById((Serializable)Integer.valueOf(processDefinitionId));
        result = this.checkProcessDefinitionValid(processDefinition, processDefinitionId);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (!this.checkTenantSuitable(processDefinition)) {
            logger.error("there is not any vaild tenant for the process definition: id:{},name:{}, ", (Object)processDefinition.getId(), (Object)processDefinition.getName());
            this.putMsg(result, Status.TENANT_NOT_SUITABLE, new Object[0]);
            return result;
        }
        int create = this.createCommand(commandType, processDefinitionId, taskDependType, failureStrategy, startNodeList, cronTime, warningType, loginUser.getId(), warningGroupId, runMode, processInstancePriority, workerGroupId);
        if (create > 0) {
            processDefinition.setReceivers(receivers);
            processDefinition.setReceiversCc(receiversCc);
            this.processDefinitionMapper.updateById((Object)processDefinition);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.START_PROCESS_INSTANCE_ERROR, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> checkProcessDefinitionValid(ProcessDefinition processDefinition, int processDefineId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, processDefineId);
        } else if (processDefinition.getReleaseState() != ReleaseState.ONLINE) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_RELEASE, processDefineId);
        } else {
            result.put("status", (Object)Status.SUCCESS);
        }
        return result;
    }

    public Map<String, Object> execute(User loginUser, String projectName, Integer processInstanceId, ExecuteType executeType) {
        Map<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.checkResultAndAuth(loginUser, projectName, project);
        if (checkResult != null) {
            return checkResult;
        }
        ProcessInstance processInstance = this.processDao.findProcessInstanceDetailById(processInstanceId.intValue());
        if (processInstance == null) {
            this.putMsg(result, Status.PROCESS_INSTANCE_NOT_EXIST, processInstanceId);
            return result;
        }
        ProcessDefinition processDefinition = this.processDao.findProcessDefineById(processInstance.getProcessDefinitionId());
        if (executeType != ExecuteType.STOP && executeType != ExecuteType.PAUSE && (result = this.checkProcessDefinitionValid(processDefinition, processInstance.getProcessDefinitionId())).get("status") != Status.SUCCESS) {
            return result;
        }
        checkResult = this.checkExecuteType(processInstance, executeType);
        Status status = (Status)((Object)checkResult.get("status"));
        if (status != Status.SUCCESS) {
            return checkResult;
        }
        if (!this.checkTenantSuitable(processDefinition)) {
            logger.error("there is not any vaild tenant for the process definition: id:{},name:{}, ", (Object)processDefinition.getId(), (Object)processDefinition.getName());
            this.putMsg(result, Status.TENANT_NOT_SUITABLE, new Object[0]);
        }
        switch (executeType) {
            case REPEAT_RUNNING: {
                result = this.insertCommand(loginUser, processInstanceId, processDefinition.getId(), CommandType.REPEAT_RUNNING);
                break;
            }
            case RECOVER_SUSPENDED_PROCESS: {
                result = this.insertCommand(loginUser, processInstanceId, processDefinition.getId(), CommandType.RECOVER_SUSPENDED_PROCESS);
                break;
            }
            case START_FAILURE_TASK_PROCESS: {
                result = this.insertCommand(loginUser, processInstanceId, processDefinition.getId(), CommandType.START_FAILURE_TASK_PROCESS);
                break;
            }
            case STOP: {
                if (processInstance.getState() == ExecutionStatus.READY_STOP) {
                    this.putMsg(result, Status.PROCESS_INSTANCE_ALREADY_CHANGED, processInstance.getName(), processInstance.getState());
                    break;
                }
                processInstance.setCommandType(CommandType.STOP);
                processInstance.addHistoryCmd(CommandType.STOP);
                this.processDao.updateProcessInstance(processInstance);
                result = this.updateProcessInstanceState(processInstanceId, ExecutionStatus.READY_STOP);
                break;
            }
            case PAUSE: {
                if (processInstance.getState() == ExecutionStatus.READY_PAUSE) {
                    this.putMsg(result, Status.PROCESS_INSTANCE_ALREADY_CHANGED, processInstance.getName(), processInstance.getState());
                    break;
                }
                processInstance.setCommandType(CommandType.PAUSE);
                processInstance.addHistoryCmd(CommandType.PAUSE);
                this.processDao.updateProcessInstance(processInstance);
                result = this.updateProcessInstanceState(processInstanceId, ExecutionStatus.READY_PAUSE);
                break;
            }
            default: {
                logger.error(String.format("unknown execute type : %s", executeType.toString()));
                this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "unknown execute type");
            }
        }
        return result;
    }

    private boolean checkTenantSuitable(ProcessDefinition processDefinition) {
        Tenant tenant = this.processDao.getTenantForProcess(processDefinition.getTenantId(), processDefinition.getUserId());
        return tenant != null;
    }

    private Map<String, Object> checkExecuteType(ProcessInstance processInstance, ExecuteType executeType) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        ExecutionStatus executionStatus = processInstance.getState();
        boolean checkResult = false;
        switch (executeType) {
            case STOP: 
            case PAUSE: {
                if (!executionStatus.typeIsRunning()) break;
                checkResult = true;
                break;
            }
            case REPEAT_RUNNING: {
                if (!executionStatus.typeIsFinished()) break;
                checkResult = true;
                break;
            }
            case START_FAILURE_TASK_PROCESS: {
                if (!executionStatus.typeIsFailure()) break;
                checkResult = true;
                break;
            }
            case RECOVER_SUSPENDED_PROCESS: {
                if (!executionStatus.typeIsPause() && !executionStatus.typeIsCancel()) break;
                checkResult = true;
            }
        }
        if (!checkResult) {
            this.putMsg(result, Status.PROCESS_INSTANCE_STATE_OPERATION_ERROR, processInstance.getName(), executionStatus.toString(), executeType.toString());
        } else {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    private Map<String, Object> updateProcessInstanceState(Integer processInstanceId, ExecutionStatus executionStatus) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        int update = this.processDao.updateProcessInstanceState(processInstanceId, executionStatus);
        if (update > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.EXECUTE_PROCESS_INSTANCE_ERROR, new Object[0]);
        }
        return result;
    }

    private Map<String, Object> insertCommand(User loginUser, Integer instanceId, Integer processDefinitionId, CommandType commandType) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Command command = new Command();
        command.setCommandType(commandType);
        command.setProcessDefinitionId(processDefinitionId.intValue());
        command.setCommandParam(String.format("{\"%s\":%d}", "ProcessInstanceId", instanceId));
        command.setExecutorId(loginUser.getId());
        if (!this.processDao.verifyIsNeedCreateCommand(command).booleanValue()) {
            this.putMsg(result, Status.PROCESS_INSTANCE_EXECUTING_COMMAND, processDefinitionId);
            return result;
        }
        int create = this.processDao.createCommand(command);
        if (create > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.EXECUTE_PROCESS_INSTANCE_ERROR, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> startCheckByProcessDefinedId(int processDefineId) {
        List processDefinitionList;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (processDefineId == 0) {
            logger.error("process definition id is null");
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "process definition id");
        }
        ArrayList ids = new ArrayList();
        this.processDao.recurseFindSubProcessId(processDefineId, ids);
        Integer[] idArray = ids.toArray(new Integer[ids.size()]);
        if (ids.size() > 0 && (processDefinitionList = this.processDefinitionMapper.queryDefinitionListByIdList(idArray)) != null && processDefinitionList.size() > 0) {
            for (ProcessDefinition processDefinition : processDefinitionList) {
                if (processDefinition.getReleaseState() == ReleaseState.ONLINE) continue;
                this.putMsg(result, Status.PROCESS_DEFINE_NOT_RELEASE, processDefinition.getName());
                logger.info("not release process definition id: {} , name : {}", (Object)processDefinition.getId(), (Object)processDefinition.getName());
                return result;
            }
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> getReceiverCc(Integer processDefineId, Integer processInstanceId) {
        ProcessDefinition processDefinition;
        HashMap<String, Object> result = new HashMap<String, Object>();
        logger.info("processInstanceId {}", (Object)processInstanceId);
        if (processDefineId == null && processInstanceId == null) {
            throw new RuntimeException("You must set values for parameters processDefineId or processInstanceId");
        }
        if (processDefineId == null && processInstanceId != null) {
            ProcessInstance processInstance = (ProcessInstance)this.processInstanceMapper.selectById((Serializable)processInstanceId);
            if (processInstance == null) {
                throw new RuntimeException("processInstanceId is not exists");
            }
            processDefineId = processInstance.getProcessDefinitionId();
        }
        if ((processDefinition = (ProcessDefinition)this.processDefinitionMapper.selectById((Serializable)processDefineId)) == null) {
            throw new RuntimeException(String.format("processDefineId %d is not exists", processDefineId));
        }
        String receivers = processDefinition.getReceivers();
        String receiversCc = processDefinition.getReceiversCc();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("receivers", receivers);
        dataMap.put("receiversCc", receiversCc);
        result.put("data", dataMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private int createCommand(CommandType commandType, int processDefineId, TaskDependType nodeDep, FailureStrategy failureStrategy, String startNodeList, String schedule, WarningType warningType, int excutorId, int warningGroupId, RunMode runMode, Priority processInstancePriority, int workerGroupId) throws ParseException {
        String[] interval;
        Command command = new Command();
        HashMap<String, String> cmdParam = new HashMap<String, String>();
        if (commandType == null) {
            command.setCommandType(CommandType.START_PROCESS);
        } else {
            command.setCommandType(commandType);
        }
        command.setProcessDefinitionId(processDefineId);
        if (nodeDep != null) {
            command.setTaskDependType(nodeDep);
        }
        if (failureStrategy != null) {
            command.setFailureStrategy(failureStrategy);
        }
        if (StringUtils.isNotEmpty((CharSequence)startNodeList)) {
            cmdParam.put("StartNodeNameList", startNodeList);
        }
        if (warningType != null) {
            command.setWarningType(warningType);
        }
        command.setCommandParam(JSONUtils.toJson(cmdParam));
        command.setExecutorId(excutorId);
        command.setWarningGroupId(Integer.valueOf(warningGroupId));
        command.setProcessInstancePriority(processInstancePriority);
        command.setWorkerGroupId(workerGroupId);
        Date start = null;
        Date end = null;
        if (StringUtils.isNotEmpty((CharSequence)schedule) && (interval = schedule.split(",")).length == 2) {
            start = DateUtils.getScheduleDate((String)interval[0]);
            end = DateUtils.getScheduleDate((String)interval[1]);
        }
        if (commandType == CommandType.COMPLEMENT_DATA) {
            RunMode runMode2 = runMode = runMode == null ? RunMode.RUN_MODE_SERIAL : runMode;
            if (runMode == RunMode.RUN_MODE_SERIAL) {
                cmdParam.put("complementStartDate", DateUtils.dateToString((Date)start));
                cmdParam.put("complementEndDate", DateUtils.dateToString((Date)end));
                command.setCommandParam(JSONUtils.toJson(cmdParam));
                return this.processDao.createCommand(command);
            }
            if (runMode == RunMode.RUN_MODE_PARALLEL) {
                int runCunt = 0;
                while (!start.after(end)) {
                    ++runCunt;
                    cmdParam.put("complementStartDate", DateUtils.dateToString((Date)start));
                    cmdParam.put("complementEndDate", DateUtils.dateToString((Date)start));
                    command.setCommandParam(JSONUtils.toJson(cmdParam));
                    this.processDao.createCommand(command);
                    start = DateUtils.getSomeDay((Date)start, (int)1);
                }
                return runCunt;
            }
        } else {
            command.setCommandParam(JSONUtils.toJson(cmdParam));
            return this.processDao.createCommand(command);
        }
        return 0;
    }

    private Map<String, Object> checkResultAndAuth(User loginUser, String projectName, Project project) {
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status status = (Status)((Object)checkResult.get("status"));
        if (status != Status.SUCCESS) {
            return checkResult;
        }
        return null;
    }
}

