/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.log.LogClient;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoggerService {
    private static final Logger logger = LoggerFactory.getLogger(LoggerService.class);
    @Autowired
    private ProcessDao processDao;

    public Result queryLog(int taskInstId, int skipLineNum, int limit) {
        TaskInstance taskInstance = this.processDao.findTaskInstanceById(Integer.valueOf(taskInstId));
        if (taskInstance == null) {
            return new Result(Status.TASK_INSTANCE_NOT_FOUND.getCode(), Status.TASK_INSTANCE_NOT_FOUND.getMsg());
        }
        String host = taskInstance.getHost();
        if (StringUtils.isEmpty((CharSequence)host)) {
            return new Result(Status.TASK_INSTANCE_NOT_FOUND.getCode(), Status.TASK_INSTANCE_NOT_FOUND.getMsg());
        }
        Result<String> result = new Result<String>(Status.SUCCESS.getCode(), Status.SUCCESS.getMsg());
        int port = PropertyUtils.getInt((String)"loggerserver.rpc.port");
        logger.info("log host : {} , logPath : {} , logServer port : {}", new Object[]{host, taskInstance.getLogPath(), port});
        LogClient logClient = new LogClient(host, port);
        String log = logClient.rollViewLog(taskInstance.getLogPath(), skipLineNum, limit);
        result.setData(log);
        return result;
    }

    public byte[] getLogBytes(int taskInstId) {
        TaskInstance taskInstance = this.processDao.findTaskInstanceById(Integer.valueOf(taskInstId));
        if (taskInstance == null) {
            throw new RuntimeException("task instance is null");
        }
        String host = taskInstance.getHost();
        int port = PropertyUtils.getInt((String)"loggerserver.rpc.port");
        logger.info("log host : {} , logPath : {} , logServer port : {}", new Object[]{host, taskInstance.getLogPath(), port});
        LogClient logClient = new LogClient(host, port);
        return logClient.getLogBytes(taskInstance.getLogPath());
    }
}

