/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.CheckUtils;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectUserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(ProjectService.class);
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectUserMapper projectUserMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;

    public Map<String, Object> createProject(User loginUser, String name, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Map<String, Object> descCheck = CheckUtils.checkDesc(desc);
        if (descCheck.get("status") != Status.SUCCESS) {
            return descCheck;
        }
        Project project = this.projectMapper.queryByName(name);
        if (project != null) {
            this.putMsg(result, Status.PROJECT_ALREADY_EXISTS, name);
            return result;
        }
        project = new Project();
        Date now = new Date();
        project.setName(name);
        project.setDescription(desc);
        project.setUserId(loginUser.getId());
        project.setUserName(loginUser.getUserName());
        project.setCreateTime(now);
        project.setUpdateTime(now);
        if (this.projectMapper.insert((Object)project) > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.CREATE_PROJECT_ERROR, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> queryById(Integer projectId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = (Project)this.projectMapper.selectById((Serializable)projectId);
        if (project != null) {
            result.put("data", project);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.PROJECT_NOT_FOUNT, projectId);
        }
        return result;
    }

    public Map<String, Object> checkProjectAndAuth(User loginUser, Project project, String projectName) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (project == null) {
            this.putMsg(result, Status.PROJECT_NOT_FOUNT, projectName);
        } else if (!this.checkReadPermission(loginUser, project)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PROJECT_PERM, loginUser.getUserName(), projectName);
        } else {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    public boolean hasProjectAndPerm(User loginUser, Project project, Map<String, Object> result) {
        boolean checkResult = false;
        if (project == null) {
            this.putMsg(result, Status.PROJECT_NOT_FOUNT, "");
        } else if (!this.checkReadPermission(loginUser, project)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PROJECT_PERM, loginUser.getUserName(), project.getName());
        } else {
            checkResult = true;
        }
        return checkResult;
    }

    public Map<String, Object> queryProjectListPaging(User loginUser, Integer pageSize, Integer pageNo, String searchVal) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        int userId = loginUser.getUserType() == UserType.ADMIN_USER ? 0 : loginUser.getId();
        IPage projectIPage = this.projectMapper.queryProjectListPaging((IPage)page, userId, searchVal);
        List projectList = projectIPage.getRecords();
        if (userId != 0) {
            for (Project project : projectList) {
                project.setPerm(7);
            }
        }
        pageInfo.setTotalCount((int)projectIPage.getTotal());
        pageInfo.setLists(projectList);
        result.put("count", (int)projectIPage.getTotal());
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> deleteProject(User loginUser, Integer projectId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = (Project)this.projectMapper.selectById((Serializable)projectId);
        Map<String, Object> checkResult = this.getCheckResult(loginUser, project);
        if (checkResult != null) {
            return checkResult;
        }
        if (!this.hasPerm(loginUser, project.getUserId())) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        List processDefinitionList = this.processDefinitionMapper.queryAllDefinitionList(projectId.intValue());
        if (processDefinitionList.size() > 0) {
            this.putMsg(result, Status.DELETE_PROJECT_ERROR_DEFINES_NOT_NULL, new Object[0]);
            return result;
        }
        int delete = this.projectMapper.deleteById((Serializable)projectId);
        if (delete > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.DELETE_PROJECT_ERROR, new Object[0]);
        }
        return result;
    }

    private Map<String, Object> getCheckResult(User loginUser, Project project) {
        String projectName = project == null ? null : project.getName();
        Map<String, Object> checkResult = this.checkProjectAndAuth(loginUser, project, projectName);
        Status status = (Status)((Object)checkResult.get("status"));
        if (status != Status.SUCCESS) {
            return checkResult;
        }
        return null;
    }

    public Map<String, Object> update(User loginUser, Integer projectId, String projectName, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Map<String, Object> descCheck = CheckUtils.checkDesc(desc);
        if (descCheck.get("status") != Status.SUCCESS) {
            return descCheck;
        }
        Project project = (Project)this.projectMapper.selectById((Serializable)projectId);
        boolean hasProjectAndPerm = this.hasProjectAndPerm(loginUser, project, result);
        if (!hasProjectAndPerm) {
            return result;
        }
        Project tempProject = this.projectMapper.queryByName(projectName);
        if (tempProject != null && tempProject.getId() != projectId.intValue()) {
            this.putMsg(result, Status.PROJECT_ALREADY_EXISTS, projectName);
            return result;
        }
        project.setName(projectName);
        project.setDescription(desc);
        project.setUpdateTime(new Date());
        int update = this.projectMapper.updateById((Object)project);
        if (update > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.UPDATE_PROJECT_ERROR, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> queryUnauthorizedProject(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        List projectList = this.projectMapper.queryProjectExceptUserId(userId.intValue());
        List<Object> resultList = new ArrayList();
        HashSet<Project> projectSet = null;
        if (projectList != null && projectList.size() > 0) {
            projectSet = new HashSet<Project>(projectList);
            List authedProjectList = this.projectMapper.queryAuthedProjectListByUserId(userId.intValue());
            resultList = this.getUnauthorizedProjects(projectSet, authedProjectList);
        }
        result.put("data", resultList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private List<Project> getUnauthorizedProjects(Set<Project> projectSet, List<Project> authedProjectList) {
        HashSet<Project> authedProjectSet = null;
        if (authedProjectList != null && authedProjectList.size() > 0) {
            authedProjectSet = new HashSet<Project>(authedProjectList);
            projectSet.removeAll(authedProjectSet);
        }
        ArrayList<Project> resultList = new ArrayList<Project>(projectSet);
        return resultList;
    }

    public Map<String, Object> queryAuthorizedProject(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        List projects = this.projectMapper.queryAuthedProjectListByUserId(userId.intValue());
        result.put("data", projects);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkReadPermission(User user, Project project) {
        int permissionId = this.queryPermission(user, project);
        return (permissionId & 2) != 0;
    }

    private int queryPermission(User user, Project project) {
        if (user.getUserType() == UserType.ADMIN_USER) {
            return 2;
        }
        if (project.getUserId() == user.getId()) {
            return 7;
        }
        ProjectUser projectUser = this.projectUserMapper.queryProjectRelation(project.getId(), user.getId());
        if (projectUser == null) {
            return 0;
        }
        return projectUser.getPerm();
    }

    public Map<String, Object> queryAllProjectList() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List projects = this.projectMapper.selectList(null);
        List processDefinitions = this.processDefinitionMapper.selectList(null);
        if (projects != null) {
            HashSet<Integer> set = new HashSet<Integer>();
            for (ProcessDefinition processDefinition : processDefinitions) {
                set.add(processDefinition.getProjectId());
            }
            ArrayList<Project> tempDeletelist = new ArrayList<Project>();
            for (Project project : projects) {
                if (set.contains(project.getId())) continue;
                tempDeletelist.add(project);
            }
            projects.removeAll(tempDeletelist);
        }
        result.put("data", projects);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

