/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.BeanMap;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.FileUtils;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ResourceType;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ResourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceUserMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UdfFuncMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ResourcesService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(ResourcesService.class);
    @Autowired
    private ResourceMapper resourcesMapper;
    @Autowired
    private UdfFuncMapper udfFunctionMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private ResourceUserMapper resourceUserMapper;

    @Transactional(rollbackFor={Exception.class})
    public Result createResource(User loginUser, String name, String desc, ResourceType type, MultipartFile file) {
        String nameSuffix;
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        if (file.isEmpty()) {
            logger.error("file is empty: {}", (Object)file.getOriginalFilename());
            this.putMsg(result, Status.RESOURCE_FILE_IS_EMPTY, new Object[0]);
            return result;
        }
        String fileSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)file.getOriginalFilename());
        if (!StringUtils.equals((String)fileSuffix, (String)(nameSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)name)))) {
            logger.error("rename file suffix and original suffix must be consistent: {}", (Object)file.getOriginalFilename());
            this.putMsg(result, Status.RESOURCE_SUFFIX_FORBID_CHANGE, new Object[0]);
            return result;
        }
        if ("UDF".equals(type.name()) && !"jar".equalsIgnoreCase(fileSuffix)) {
            logger.error(Status.UDF_RESOURCE_SUFFIX_NOT_JAR.getMsg());
            this.putMsg(result, Status.UDF_RESOURCE_SUFFIX_NOT_JAR, new Object[0]);
            return result;
        }
        if (file.getSize() > 0x40000000L) {
            logger.error("file size is too large: {}", (Object)file.getOriginalFilename());
            this.putMsg(result, Status.RESOURCE_SIZE_EXCEED_LIMIT, new Object[0]);
            return result;
        }
        if (this.checkResourceExists(name, 0, type.ordinal())) {
            logger.error("resource {} has exist, can't recreate", (Object)name);
            this.putMsg(result, Status.RESOURCE_EXIST, new Object[0]);
            return result;
        }
        Date now = new Date();
        Resource resource = new Resource(name, file.getOriginalFilename(), desc, loginUser.getId(), type, file.getSize(), now, now);
        try {
            this.resourcesMapper.insert((Object)resource);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            BeanMap dataMap = new BeanMap((Object)resource);
            HashMap resultMap = new HashMap();
            for (Map.Entry entry : dataMap.entrySet()) {
                if ("class".equalsIgnoreCase(entry.getKey().toString())) continue;
                resultMap.put(entry.getKey().toString(), entry.getValue());
            }
            result.setData(resultMap);
        }
        catch (Exception e) {
            logger.error("resource already exists, can't recreate ", (Throwable)e);
            throw new RuntimeException("resource already exists, can't recreate");
        }
        if (!this.upload(loginUser, name, file, type)) {
            logger.error("upload resource: {} file: {} failed.", (Object)name, (Object)file.getOriginalFilename());
            this.putMsg(result, Status.HDFS_OPERATION_ERROR, new Object[0]);
            throw new RuntimeException(String.format("upload resource: %s file: %s failed.", name, file.getOriginalFilename()));
        }
        return result;
    }

    private boolean checkResourceExists(String alias, int userId, int type) {
        List resources = this.resourcesMapper.queryResourceList(alias, userId, type);
        return resources != null && resources.size() > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result updateResource(User loginUser, int resourceId, String name, String desc, ResourceType type) {
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        if (!this.hasPerm(loginUser, resource.getUserId())) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (name.equals(resource.getAlias()) && desc.equals(resource.getDescription())) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        if (!resource.getAlias().equals(name) && this.checkResourceExists(name, 0, type.ordinal())) {
            logger.error("resource {} already exists, can't recreate", (Object)name);
            this.putMsg(result, Status.RESOURCE_EXIST, new Object[0]);
            return result;
        }
        String originResourceName = resource.getAlias();
        String suffix = originResourceName.substring(originResourceName.lastIndexOf("."));
        String nameWithSuffix = name;
        if (!name.endsWith(suffix)) {
            nameWithSuffix = nameWithSuffix + suffix;
        }
        Date now = new Date();
        resource.setAlias(nameWithSuffix);
        resource.setDescription(desc);
        resource.setUpdateTime(now);
        try {
            this.resourcesMapper.updateById((Object)resource);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            BeanMap dataMap = new BeanMap((Object)resource);
            HashMap resultMap = new HashMap(5);
            for (Map.Entry entry : dataMap.entrySet()) {
                if ("class".equalsIgnoreCase(entry.getKey().toString())) continue;
                resultMap.put(entry.getKey().toString(), entry.getValue());
            }
            result.setData(resultMap);
        }
        catch (Exception e) {
            logger.error(Status.UPDATE_RESOURCE_ERROR.getMsg(), (Throwable)e);
            throw new RuntimeException(Status.UPDATE_RESOURCE_ERROR.getMsg());
        }
        if (originResourceName.equals(name)) {
            return result;
        }
        User user = this.userMapper.queryDetailsById(resource.getUserId());
        String tenantCode = this.tenantMapper.queryById(user.getTenantId()).getTenantCode();
        String originHdfsFileName = HadoopUtils.getHdfsFileName((ResourceType)resource.getType(), (String)tenantCode, (String)originResourceName);
        String destHdfsFileName = HadoopUtils.getHdfsFileName((ResourceType)resource.getType(), (String)tenantCode, (String)name);
        try {
            if (HadoopUtils.getInstance().exists(originHdfsFileName)) {
                logger.info("hdfs copy {} -> {}", (Object)originHdfsFileName, (Object)destHdfsFileName);
                HadoopUtils.getInstance().copy(originHdfsFileName, destHdfsFileName, true, true);
            } else {
                logger.error("{} not exist", (Object)originHdfsFileName);
                this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error(MessageFormat.format("hdfs copy {0} -> {1} fail", originHdfsFileName, destHdfsFileName), (Throwable)e);
            this.putMsg(result, Status.HDFS_COPY_FAIL, new Object[0]);
        }
        return result;
    }

    public Map<String, Object> queryResourceListPaging(User loginUser, ResourceType type, String searchVal, Integer pageNo, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        int userId = loginUser.getId();
        if (this.isAdmin(loginUser)) {
            userId = 0;
        }
        IPage resourceIPage = this.resourcesMapper.queryResourcePaging((IPage)page, userId, type.ordinal(), searchVal);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotalCount((int)resourceIPage.getTotal());
        pageInfo.setLists(resourceIPage.getRecords());
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean upload(User loginUser, String name, MultipartFile file, ResourceType type) {
        String nameSuffix;
        String fileSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)file.getOriginalFilename());
        if (!StringUtils.equals((String)fileSuffix, (String)(nameSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)name)))) {
            return false;
        }
        String tenantCode = this.tenantMapper.queryById(loginUser.getTenantId()).getTenantCode();
        String localFilename = org.apache.dolphinscheduler.common.utils.FileUtils.getUploadFilename((String)tenantCode, (String)UUID.randomUUID().toString());
        String hdfsFilename = HadoopUtils.getHdfsFileName((ResourceType)type, (String)tenantCode, (String)name);
        String resourcePath = HadoopUtils.getHdfsDir((ResourceType)type, (String)tenantCode);
        try {
            if (!HadoopUtils.getInstance().exists(resourcePath)) {
                this.createTenantDirIfNotExists(tenantCode);
            }
            FileUtils.copyFile(file, localFilename);
            HadoopUtils.getInstance().copyLocalToHdfs(localFilename, hdfsFilename, true, true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public Map<String, Object> queryResourceList(User loginUser, ResourceType type) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        int userId = loginUser.getId();
        if (this.isAdmin(loginUser)) {
            userId = 0;
        }
        List resourceList = this.resourcesMapper.queryResourceListAuthored(userId, type.ordinal());
        result.put("data", resourceList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result delete(User loginUser, int resourceId) throws Exception {
        List udfFuncs;
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("resource file not exist,  resource id {}", (Object)resourceId);
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        if (!this.hasPerm(loginUser, resource.getUserId())) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (resource.getType() == ResourceType.UDF && CollectionUtils.isNotEmpty((Collection)(udfFuncs = this.udfFunctionMapper.listUdfByResourceId(new int[]{resourceId})))) {
            logger.error("can't be deleted,because it is bound by UDF functions:{}", (Object)udfFuncs.toString());
            this.putMsg(result, Status.UDF_RESOURCE_IS_BOUND, ((UdfFunc)udfFuncs.get(0)).getFuncName());
            return result;
        }
        String tenantCode = this.userMapper.queryTenantCodeByUserId(resource.getUserId()).getTenantCode();
        String hdfsFilename = HadoopUtils.getHdfsFileName((ResourceType)resource.getType(), (String)tenantCode, (String)resource.getAlias());
        this.resourcesMapper.deleteById((Serializable)Integer.valueOf(resourceId));
        this.resourceUserMapper.deleteResourceUser(0, resourceId);
        HadoopUtils.getInstance().delete(hdfsFilename, false);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Result verifyResourceName(String name, ResourceType type, User loginUser) {
        Result result = new Result();
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        if (this.checkResourceExists(name, 0, type.ordinal())) {
            logger.error("resource type:{} name:{} has exist, can't create again.", (Object)type, (Object)name);
            this.putMsg(result, Status.RESOURCE_EXIST, new Object[0]);
        } else {
            Tenant tenant = this.tenantMapper.queryById(loginUser.getTenantId());
            if (tenant != null) {
                String tenantCode = tenant.getTenantCode();
                try {
                    String hdfsFilename = HadoopUtils.getHdfsFileName((ResourceType)type, (String)tenantCode, (String)name);
                    if (HadoopUtils.getInstance().exists(hdfsFilename)) {
                        logger.error("resource type:{} name:{} has exist in hdfs {}, can't create again.", new Object[]{type, name, hdfsFilename});
                        this.putMsg(result, Status.RESOURCE_FILE_EXIST, hdfsFilename);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    this.putMsg(result, Status.HDFS_OPERATION_ERROR, new Object[0]);
                }
            } else {
                this.putMsg(result, Status.TENANT_NOT_EXIST, new Object[0]);
            }
        }
        return result;
    }

    public Result readResource(int resourceId, int skipLineNum, int limit) {
        List<String> strList;
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("resouce file not exist,  resource id {}", (Object)resourceId);
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        String nameSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)resource.getAlias());
        String resourceViewSuffixs = org.apache.dolphinscheduler.common.utils.FileUtils.getResourceViewSuffixs();
        if (StringUtils.isNotEmpty((String)resourceViewSuffixs) && !(strList = Arrays.asList(resourceViewSuffixs.split(","))).contains(nameSuffix)) {
            logger.error("resouce suffix {} not support view,  resource id {}", (Object)nameSuffix, (Object)resourceId);
            this.putMsg(result, Status.RESOURCE_SUFFIX_NOT_SUPPORT_VIEW, new Object[0]);
            return result;
        }
        User user = this.userMapper.queryDetailsById(resource.getUserId());
        String tenantCode = this.tenantMapper.queryById(user.getTenantId()).getTenantCode();
        String hdfsFileName = HadoopUtils.getHdfsResourceFileName((String)tenantCode, (String)resource.getAlias());
        logger.info("resource hdfs path is {} ", (Object)hdfsFileName);
        try {
            if (HadoopUtils.getInstance().exists(hdfsFileName)) {
                List content = HadoopUtils.getInstance().catFile(hdfsFileName, skipLineNum, limit);
                this.putMsg(result, Status.SUCCESS, new Object[0]);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("alias", resource.getAlias());
                map.put("content", StringUtils.join((Object[])content.toArray(), (String)"\n"));
                result.setData(map);
            } else {
                logger.error("read file {} not exist in hdfs", (Object)hdfsFileName);
                this.putMsg(result, Status.RESOURCE_FILE_NOT_EXIST, hdfsFileName);
            }
        }
        catch (Exception e) {
            logger.error(String.format("Resource %s read failed", hdfsFileName), (Throwable)e);
            this.putMsg(result, Status.HDFS_OPERATION_ERROR, new Object[0]);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result onlineCreateResource(User loginUser, ResourceType type, String fileName, String fileSuffix, String desc, String content) {
        List<String> strList;
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        String nameSuffix = fileSuffix.trim();
        String resourceViewSuffixs = org.apache.dolphinscheduler.common.utils.FileUtils.getResourceViewSuffixs();
        if (StringUtils.isNotEmpty((String)resourceViewSuffixs) && !(strList = Arrays.asList(resourceViewSuffixs.split(","))).contains(nameSuffix)) {
            logger.error("resouce suffix {} not support create", (Object)nameSuffix);
            this.putMsg(result, Status.RESOURCE_SUFFIX_NOT_SUPPORT_VIEW, new Object[0]);
            return result;
        }
        String name = fileName.trim() + "." + nameSuffix;
        result = this.verifyResourceName(name, type, loginUser);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            return result;
        }
        Date now = new Date();
        Resource resource = new Resource(name, name, desc, loginUser.getId(), type, (long)content.getBytes().length, now, now);
        this.resourcesMapper.insert((Object)resource);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        BeanMap dataMap = new BeanMap((Object)resource);
        HashMap resultMap = new HashMap(5);
        for (Map.Entry entry : dataMap.entrySet()) {
            if ("class".equalsIgnoreCase(entry.getKey().toString())) continue;
            resultMap.put(entry.getKey().toString(), entry.getValue());
        }
        result.setData(resultMap);
        String tenantCode = this.tenantMapper.queryById(loginUser.getTenantId()).getTenantCode();
        result = this.uploadContentToHdfs(name, tenantCode, content);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            throw new RuntimeException(result.getMsg());
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result updateResourceContent(int resourceId, String content) {
        List<String> strList;
        Result result = new Result();
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("read file not exist,  resource id {}", (Object)resourceId);
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        String nameSuffix = org.apache.dolphinscheduler.common.utils.FileUtils.suffix((String)resource.getAlias());
        String resourceViewSuffixs = org.apache.dolphinscheduler.common.utils.FileUtils.getResourceViewSuffixs();
        if (StringUtils.isNotEmpty((String)resourceViewSuffixs) && !(strList = Arrays.asList(resourceViewSuffixs.split(","))).contains(nameSuffix)) {
            logger.error("resouce suffix {} not support updateProcessInstance,  resource id {}", (Object)nameSuffix, (Object)resourceId);
            this.putMsg(result, Status.RESOURCE_SUFFIX_NOT_SUPPORT_VIEW, new Object[0]);
            return result;
        }
        resource.setSize((long)content.getBytes().length);
        resource.setUpdateTime(new Date());
        this.resourcesMapper.updateById((Object)resource);
        User user = this.userMapper.queryDetailsById(resource.getUserId());
        String tenantCode = this.tenantMapper.queryById(user.getTenantId()).getTenantCode();
        result = this.uploadContentToHdfs(resource.getAlias(), tenantCode, content);
        if (!result.getCode().equals(Status.SUCCESS.getCode())) {
            throw new RuntimeException(result.getMsg());
        }
        return result;
    }

    private Result uploadContentToHdfs(String resourceName, String tenantCode, String content) {
        Result result = new Result();
        String localFilename = "";
        String hdfsFileName = "";
        try {
            localFilename = org.apache.dolphinscheduler.common.utils.FileUtils.getUploadFilename((String)tenantCode, (String)UUID.randomUUID().toString());
            if (!org.apache.dolphinscheduler.common.utils.FileUtils.writeContent2File((String)content, (String)localFilename)) {
                logger.error("file {} fail, content is {}", (Object)localFilename, (Object)content);
                this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            hdfsFileName = HadoopUtils.getHdfsResourceFileName((String)tenantCode, (String)resourceName);
            String resourcePath = HadoopUtils.getHdfsResDir((String)tenantCode);
            logger.info("resource hdfs path is {} ", (Object)hdfsFileName);
            HadoopUtils hadoopUtils = HadoopUtils.getInstance();
            if (!hadoopUtils.exists(resourcePath)) {
                this.createTenantDirIfNotExists(tenantCode);
            }
            if (hadoopUtils.exists(hdfsFileName)) {
                hadoopUtils.delete(hdfsFileName, false);
            }
            hadoopUtils.copyLocalToHdfs(localFilename, hdfsFileName, true, true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setCode(Status.HDFS_OPERATION_ERROR.getCode());
            result.setMsg(String.format("copy %s to hdfs %s fail", localFilename, hdfsFileName));
            return result;
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public org.springframework.core.io.Resource downloadResource(int resourceId) throws Exception {
        if (!PropertyUtils.getResUploadStartupState().booleanValue()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            throw new RuntimeException("hdfs not startup");
        }
        Resource resource = (Resource)this.resourcesMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("download file not exist,  resource id {}", (Object)resourceId);
            return null;
        }
        User user = this.userMapper.queryDetailsById(resource.getUserId());
        String tenantCode = this.tenantMapper.queryById(user.getTenantId()).getTenantCode();
        String hdfsFileName = HadoopUtils.getHdfsFileName((ResourceType)resource.getType(), (String)tenantCode, (String)resource.getAlias());
        String localFileName = org.apache.dolphinscheduler.common.utils.FileUtils.getDownloadFilename((String)resource.getAlias());
        logger.info("resource hdfs path is {} ", (Object)hdfsFileName);
        HadoopUtils.getInstance().copyHdfsToLocal(hdfsFileName, localFileName, false, true);
        org.springframework.core.io.Resource file = FileUtils.file2Resource(localFileName);
        return file;
    }

    public Map<String, Object> unauthorizedFile(User loginUser, Integer userId) {
        ArrayList list;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        List resourceList = this.resourcesMapper.queryResourceExceptUserId(userId.intValue());
        if (resourceList != null && resourceList.size() > 0) {
            HashSet resourceSet = new HashSet(resourceList);
            List authedResourceList = this.resourcesMapper.queryAuthorizedResourceList(userId.intValue());
            this.getAuthorizedResourceList(resourceSet, authedResourceList);
            list = new ArrayList(resourceSet);
        } else {
            list = new ArrayList(0);
        }
        result.put("data", list);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> unauthorizedUDFFunction(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        List udfFuncList = this.udfFunctionMapper.queryUdfFuncExceptUserId(userId.intValue());
        ArrayList resultList = new ArrayList();
        HashSet udfFuncSet = null;
        if (udfFuncList != null && udfFuncList.size() > 0) {
            udfFuncSet = new HashSet(udfFuncList);
            List authedUDFFuncList = this.udfFunctionMapper.queryAuthedUdfFunc(userId.intValue());
            this.getAuthorizedResourceList(udfFuncSet, authedUDFFuncList);
            resultList = new ArrayList(udfFuncSet);
        }
        result.put("data", resultList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> authorizedUDFFunction(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        List udfFuncs = this.udfFunctionMapper.queryAuthedUdfFunc(userId.intValue());
        result.put("data", udfFuncs);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    public Map<String, Object> authorizedFile(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (this.checkAdmin(loginUser, result)) {
            return result;
        }
        List authedResources = this.resourcesMapper.queryAuthorizedResourceList(userId.intValue());
        result.put("data", authedResources);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void getAuthorizedResourceList(Set<?> resourceSet, List<?> authedResourceList) {
        HashSet authedResourceSet = null;
        if (authedResourceList != null && authedResourceList.size() > 0) {
            authedResourceSet = new HashSet(authedResourceList);
            resourceSet.removeAll(authedResourceSet);
        }
    }
}

