/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskInstanceService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(TaskInstanceService.class);
    @Autowired
    ProjectMapper projectMapper;
    @Autowired
    ProjectService projectService;
    @Autowired
    ProcessDao processDao;
    @Autowired
    TaskInstanceMapper taskInstanceMapper;

    public Map<String, Object> queryTaskListPaging(User loginUser, String projectName, Integer processInstanceId, String taskName, String startDate, String endDate, String searchVal, ExecutionStatus stateType, String host, Integer pageNo, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Project project = this.projectMapper.queryByName(projectName);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectName);
        Status status = (Status)((Object)checkResult.get("status"));
        if (status != Status.SUCCESS) {
            return checkResult;
        }
        int[] statusArray = null;
        if (stateType != null) {
            statusArray = new int[]{stateType.ordinal()};
        }
        Date start = null;
        Date end = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)startDate)) {
                start = DateUtils.getScheduleDate((String)startDate);
            }
            if (StringUtils.isNotEmpty((CharSequence)endDate)) {
                end = DateUtils.getScheduleDate((String)endDate);
            }
        }
        catch (Exception e) {
            result.put("status", (Object)Status.REQUEST_PARAMS_NOT_VALID_ERROR);
            result.put("msg", MessageFormat.format(Status.REQUEST_PARAMS_NOT_VALID_ERROR.getMsg(), "startDate,endDate"));
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage taskInstanceIPage = this.taskInstanceMapper.queryTaskInstanceListPaging((IPage)page, project.getId(), processInstanceId, searchVal, taskName, statusArray, host, start, end);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        HashSet<String> exclusionSet = new HashSet<String>(){
            {
                this.add("class");
                this.add("taskJson");
            }
        };
        List taskInstanceList = taskInstanceIPage.getRecords();
        for (TaskInstance taskInstance : taskInstanceList) {
            taskInstance.setDuration(Long.valueOf(DateUtils.differSec((Date)taskInstance.getStartTime(), (Date)taskInstance.getEndTime())));
        }
        pageInfo.setTotalCount((int)taskInstanceIPage.getTotal());
        pageInfo.setLists(CollectionUtils.getListByExclusion((List)taskInstanceIPage.getRecords(), (Set)exclusionSet));
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

