/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.dao.TaskRecordDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TaskRecordService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(TaskRecordService.class);

    public Map<String, Object> queryTaskRecordListPaging(boolean isHistory, String taskName, String startDate, String taskDate, String sourceTable, String destTable, String endDate, String state, Integer pageNo, Integer pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("taskName", taskName);
        map.put("taskDate", taskDate);
        map.put("state", state);
        map.put("sourceTable", sourceTable);
        map.put("targetTable", destTable);
        map.put("startTime", startDate);
        map.put("endTime", endDate);
        map.put("offset", pageInfo.getStart().toString());
        map.put("pageSize", pageInfo.getPageSize().toString());
        String table = isHistory ? Constants.TASK_RECORD_TABLE_HISTORY_HIVE_LOG : Constants.TASK_RECORD_TABLE_HIVE_LOG;
        int count = TaskRecordDao.countTaskRecord(map, (String)table);
        List recordList = TaskRecordDao.queryAllTaskRecord(map, (String)table);
        pageInfo.setTotalCount(count);
        pageInfo.setLists(recordList);
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

