/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.utils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.web.multipart.MultipartFile;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static void copyFile(MultipartFile file, String destFilename) {
        try {
            File destFile = new File(destFilename);
            File destParentDir = new File(destFile.getParent());
            if (!destParentDir.exists()) {
                org.apache.commons.io.FileUtils.forceMkdir((File)destParentDir);
            }
            Files.copy(file.getInputStream(), Paths.get(destFilename, new String[0]), new CopyOption[0]);
        }
        catch (IOException e) {
            logger.error(String.format("failed to copy file , {} is empty file", file.getOriginalFilename()), (Throwable)e);
        }
    }

    public static Resource file2Resource(String filename) throws MalformedURLException {
        Path file = Paths.get(filename, new String[0]);
        UrlResource resource = new UrlResource(file.toUri());
        if (resource.exists() || resource.isReadable()) {
            return resource;
        }
        logger.error("file can not read : {}", (Object)filename);
        return null;
    }
}

