/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.utils;

import java.util.List;

public class PageInfo<T> {
    private List<T> lists;
    private Integer totalCount = 0;
    private Integer pageSize = 20;
    private Integer currentPage = 0;
    private Integer pageNo;

    public PageInfo(Integer currentPage, Integer pageSize) {
        if (currentPage == null) {
            currentPage = 1;
        }
        this.pageNo = (currentPage - 1) * pageSize;
        this.pageSize = pageSize;
        this.currentPage = currentPage;
    }

    public Integer getStart() {
        return this.pageNo;
    }

    public void setStart(Integer start) {
        this.pageNo = start;
    }

    public Integer getTotalPage() {
        if (this.pageSize == null || this.pageSize == 0) {
            this.pageSize = 7;
        }
        if (this.totalCount % this.pageSize == 0) {
            return this.totalCount / this.pageSize == 0 ? 1 : this.totalCount / this.pageSize;
        }
        return this.totalCount / this.pageSize + 1;
    }

    public List<T> getLists() {
        return this.lists;
    }

    public void setLists(List<T> lists) {
        this.lists = lists;
    }

    public Integer getTotalCount() {
        if (this.totalCount == null) {
            this.totalCount = 0;
        }
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getPageSize() {
        if (this.pageSize == null || this.pageSize == 0) {
            this.pageSize = 7;
        }
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getCurrentPage() {
        if (this.currentPage == null || this.currentPage <= 0) {
            this.currentPage = 1;
        }
        return this.currentPage;
    }
}

