/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.SchedulerService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"SCHEDULER_TAG"})
@RestController
@RequestMapping(value={"/projects/{projectCode}/schedules"})
public class SchedulerController
extends BaseController {
    public static final String DEFAULT_WARNING_TYPE = "NONE";
    public static final String DEFAULT_NOTIFY_GROUP_ID = "1";
    public static final String DEFAULT_FAILURE_POLICY = "CONTINUE";
    public static final String DEFAULT_PROCESS_INSTANCE_PRIORITY = "MEDIUM";
    @Autowired
    private SchedulerService schedulerService;

    @ApiOperation(value="createSchedule", notes="CREATE_SCHEDULE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionCode", value="PROCESS_DEFINITION_CODE", required=true, dataType="Long", example="100"), @ApiImplicitParam(name="schedule", value="SCHEDULE", dataType="String", example="{'startTime':'2019-06-10 00:00:00','endTime':'2019-06-13 00:00:00','timezoneId':'America/Phoenix','crontab':'0 0 3/6 * * ? *'}"), @ApiImplicitParam(name="warningType", value="WARNING_TYPE", type="WarningType"), @ApiImplicitParam(name="warningGroupId", value="WARNING_GROUP_ID", dataType="Int", example="100"), @ApiImplicitParam(name="failureStrategy", value="FAILURE_STRATEGY", type="FailureStrategy"), @ApiImplicitParam(name="workerGroupId", value="WORKER_GROUP_ID", dataType="Int", example="100"), @ApiImplicitParam(name="environmentCode", value="ENVIRONMENT_CODE", dataType="Long"), @ApiImplicitParam(name="processInstancePriority", value="PROCESS_INSTANCE_PRIORITY", type="Priority")})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_SCHEDULE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createSchedule(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processDefinitionCode") long processDefinitionCode, @RequestParam(value="schedule") String schedule, @RequestParam(value="warningType", required=false, defaultValue="NONE") WarningType warningType, @RequestParam(value="warningGroupId", required=false, defaultValue="1") int warningGroupId, @RequestParam(value="failureStrategy", required=false, defaultValue="CONTINUE") FailureStrategy failureStrategy, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="environmentCode", required=false, defaultValue="-1") Long environmentCode, @RequestParam(value="processInstancePriority", required=false, defaultValue="MEDIUM") Priority processInstancePriority) {
        Map<String, Object> result = this.schedulerService.insertSchedule(loginUser, projectCode, processDefinitionCode, schedule, warningType, warningGroupId, failureStrategy, processInstancePriority, workerGroup, environmentCode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="updateSchedule", notes="UPDATE_SCHEDULE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="SCHEDULE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="schedule", value="SCHEDULE", dataType="String", example="{'startTime':'2019-06-10 00:00:00','endTime':'2019-06-13 00:00:00','crontab':'0 0 3/6 * * ? *'}"), @ApiImplicitParam(name="warningType", value="WARNING_TYPE", type="WarningType"), @ApiImplicitParam(name="warningGroupId", value="WARNING_GROUP_ID", dataType="Int", example="100"), @ApiImplicitParam(name="failureStrategy", value="FAILURE_STRATEGY", type="FailureStrategy"), @ApiImplicitParam(name="workerGroupId", value="WORKER_GROUP_ID", dataType="Int", example="100"), @ApiImplicitParam(name="processInstancePriority", value="PROCESS_INSTANCE_PRIORITY", type="Priority"), @ApiImplicitParam(name="environmentCode", value="ENVIRONMENT_CODE", dataType="Long")})
    @PutMapping(value={"/{id}"})
    @ApiException(value=Status.UPDATE_SCHEDULE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateSchedule(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id, @RequestParam(value="schedule") String schedule, @RequestParam(value="warningType", required=false, defaultValue="NONE") WarningType warningType, @RequestParam(value="warningGroupId", required=false) int warningGroupId, @RequestParam(value="failureStrategy", required=false, defaultValue="END") FailureStrategy failureStrategy, @RequestParam(value="workerGroup", required=false, defaultValue="default") String workerGroup, @RequestParam(value="environmentCode", required=false, defaultValue="-1") Long environmentCode, @RequestParam(value="processInstancePriority", required=false) Priority processInstancePriority) {
        Map<String, Object> result = this.schedulerService.updateSchedule(loginUser, projectCode, id, schedule, warningType, warningGroupId, failureStrategy, processInstancePriority, workerGroup, environmentCode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="online", notes="ONLINE_SCHEDULE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="SCHEDULE_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/{id}/online"})
    @ApiException(value=Status.PUBLISH_SCHEDULE_ONLINE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result online(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        Map<String, Object> result = this.schedulerService.setScheduleState(loginUser, projectCode, id, ReleaseState.ONLINE);
        return this.returnDataList(result);
    }

    @ApiOperation(value="offline", notes="OFFLINE_SCHEDULE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="SCHEDULE_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/{id}/offline"})
    @ApiException(value=Status.OFFLINE_SCHEDULE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result offline(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        Map<String, Object> result = this.schedulerService.setScheduleState(loginUser, projectCode, id, ReleaseState.OFFLINE);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryScheduleListPaging", notes="QUERY_SCHEDULE_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionId", value="PROCESS_DEFINITION_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", type="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", dataType="Int", example="20")})
    @GetMapping
    @ApiException(value=Status.QUERY_SCHEDULE_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryScheduleListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam long processDefinitionCode, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.schedulerService.querySchedule(loginUser, projectCode, processDefinitionCode, searchVal, pageNo, pageSize);
        return result;
    }

    @ApiOperation(value="deleteScheduleById", notes="OFFLINE_SCHEDULE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="SCHEDULE_ID", required=true, dataType="Int", example="100")})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_SCHEDULE_CRON_BY_ID_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteScheduleById(@RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        Map<String, Object> result = this.schedulerService.deleteScheduleById(loginUser, projectCode, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryScheduleList", notes="QUERY_SCHEDULE_LIST_NOTES")
    @PostMapping(value={"/list"})
    @ApiException(value=Status.QUERY_SCHEDULE_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryScheduleList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode) {
        Map<String, Object> result = this.schedulerService.queryScheduleList(loginUser, projectCode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="previewSchedule", notes="PREVIEW_SCHEDULE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="schedule", value="SCHEDULE", dataType="String", example="{'startTime':'2019-06-10 00:00:00','endTime':'2019-06-13 00:00:00','crontab':'0 0 3/6 * * ? *'}")})
    @PostMapping(value={"/preview"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.PREVIEW_SCHEDULE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result previewSchedule(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="schedule") String schedule) {
        Map<String, Object> result = this.schedulerService.previewSchedule(loginUser, schedule);
        return this.returnDataList(result);
    }
}

