/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.TaskDefinitionService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"TASK_DEFINITION_TAG"})
@RestController
@RequestMapping(value={"projects/{projectCode}/task-definition"})
public class TaskDefinitionController
extends BaseController {
    @Autowired
    private TaskDefinitionService taskDefinitionService;

    @ApiOperation(value="save", notes="CREATE_TASK_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, type="Long"), @ApiImplicitParam(name="taskDefinitionJson", value="TASK_DEFINITION_JSON", required=true, type="String")})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_TASK_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createTaskDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="taskDefinitionJson", required=true) String taskDefinitionJson) {
        Map<String, Object> result = this.taskDefinitionService.createTaskDefinition(loginUser, projectCode, taskDefinitionJson);
        return this.returnDataList(result);
    }

    @ApiOperation(value="update", notes="UPDATE_TASK_DEFINITION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, type="Long"), @ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataType="Long", example="1"), @ApiImplicitParam(name="taskDefinitionJsonObj", value="TASK_DEFINITION_JSON", required=true, type="String")})
    @PutMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_TASK_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateTaskDefinition(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @RequestParam(value="taskDefinitionJsonObj", required=true) String taskDefinitionJsonObj) {
        Map<String, Object> result = this.taskDefinitionService.updateTaskDefinition(loginUser, projectCode, code, taskDefinitionJsonObj);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryVersions", notes="QUERY_TASK_DEFINITION_VERSIONS_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataType="Long", example="1"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="10")})
    @GetMapping(value={"/{code}/versions"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_DEFINITION_VERSIONS_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskDefinitionVersions(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        return this.taskDefinitionService.queryTaskDefinitionVersions(loginUser, projectCode, code, pageNo, pageSize);
    }

    @ApiOperation(value="switchVersion", notes="SWITCH_TASK_DEFINITION_VERSION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataType="Long", example="1"), @ApiImplicitParam(name="version", value="VERSION", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/{code}/versions/{version}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.SWITCH_TASK_DEFINITION_VERSION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result switchTaskDefinitionVersion(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @PathVariable(value="version") int version) {
        Map<String, Object> result = this.taskDefinitionService.switchVersion(loginUser, projectCode, code, version);
        return this.returnDataList(result);
    }

    @ApiOperation(value="deleteVersion", notes="DELETE_TASK_DEFINITION_VERSION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataType="Long", example="1"), @ApiImplicitParam(name="version", value="VERSION", required=true, dataType="Int", example="100")})
    @DeleteMapping(value={"/{code}/versions/{version}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_DEFINITION_VERSION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteTaskDefinitionVersion(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code, @PathVariable(value="version") int version) {
        Map<String, Object> result = this.taskDefinitionService.deleteByCodeAndVersion(loginUser, projectCode, code, version);
        return this.returnDataList(result);
    }

    @ApiOperation(value="deleteTaskDefinition", notes="DELETE_TASK_DEFINITION_BY_CODE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataType="Long", example="1")})
    @DeleteMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TASK_DEFINE_BY_CODE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteTaskDefinitionByCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code) {
        Map<String, Object> result = this.taskDefinitionService.deleteTaskDefinitionByCode(loginUser, projectCode, code);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryTaskDefinitionByCode", notes="QUERY_TASK_DEFINITION_DETAIL_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="TASK_DEFINITION_CODE", required=true, dataType="Long", example="1")})
    @GetMapping(value={"/{code}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DETAIL_OF_TASK_DEFINITION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskDefinitionDetail(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="code") long code) {
        Map<String, Object> result = this.taskDefinitionService.queryTaskDefinitionDetail(loginUser, projectCode, code);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryTaskDefinitionListPaging", notes="QUERY_TASK_DEFINITION_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskType", value="TASK_TYPE", required=false, type="String"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", required=false, type="String"), @ApiImplicitParam(name="userId", value="USER_ID", required=false, dataType="Int", example="100"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="10")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_DEFINITION_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskDefinitionListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="taskType", required=false) String taskType, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="userId", required=false, defaultValue="0") Integer userId, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        taskType = ParameterUtils.handleEscapes((String)taskType);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.taskDefinitionService.queryTaskDefinitionListPaging(loginUser, projectCode, taskType, searchVal, userId, pageNo, pageSize);
    }

    @ApiOperation(value="genTaskCodeList", notes="GEN_TASK_CODE_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="genNum", value="GEN_NUM", required=true, dataType="Int", example="1")})
    @GetMapping(value={"/gen-task-codes"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LOGIN_USER_QUERY_PROJECT_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result genTaskCodeList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="genNum") Integer genNum) {
        Map<String, Object> result = this.taskDefinitionService.genTaskCodeList(genNum);
        return this.returnDataList(result);
    }
}

