/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.AlertPluginInstanceService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.api.vo.AlertPluginInstanceVO;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.AlertPluginInstance;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.AlertGroupMapper;
import org.apache.dolphinscheduler.dao.mapper.AlertPluginInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.PluginDefineMapper;
import org.apache.dolphinscheduler.spi.params.PluginParamsTransfer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class AlertPluginInstanceServiceImpl
extends BaseServiceImpl
implements AlertPluginInstanceService {
    @Autowired
    private AlertPluginInstanceMapper alertPluginInstanceMapper;
    @Autowired
    private PluginDefineMapper pluginDefineMapper;
    @Autowired
    private AlertGroupMapper alertGroupMapper;

    @Override
    public Map<String, Object> create(User loginUser, int pluginDefineId, String instanceName, String pluginInstanceParams) {
        AlertPluginInstance alertPluginInstance = new AlertPluginInstance();
        String paramsMapJson = this.parsePluginParamsMap(pluginInstanceParams);
        alertPluginInstance.setPluginInstanceParams(paramsMapJson);
        alertPluginInstance.setInstanceName(instanceName);
        alertPluginInstance.setPluginDefineId(pluginDefineId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.alertPluginInstanceMapper.existInstanceName(alertPluginInstance.getInstanceName()) == Boolean.TRUE) {
            this.putMsg(result, Status.PLUGIN_INSTANCE_ALREADY_EXIT, new Object[0]);
            return result;
        }
        int i = this.alertPluginInstanceMapper.insert((Object)alertPluginInstance);
        if (i > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        this.putMsg(result, Status.SAVE_ERROR, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> update(User loginUser, int pluginInstanceId, String instanceName, String pluginInstanceParams) {
        String paramsMapJson = this.parsePluginParamsMap(pluginInstanceParams);
        AlertPluginInstance alertPluginInstance = new AlertPluginInstance(pluginInstanceId, paramsMapJson, instanceName, new Date());
        HashMap<String, Object> result = new HashMap<String, Object>();
        int i = this.alertPluginInstanceMapper.updateById((Object)alertPluginInstance);
        if (i > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        this.putMsg(result, Status.SAVE_ERROR, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> delete(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean hasAssociatedAlertGroup = this.checkHasAssociatedAlertGroup(String.valueOf(id));
        if (hasAssociatedAlertGroup) {
            this.putMsg(result, Status.DELETE_ALERT_PLUGIN_INSTANCE_ERROR_HAS_ALERT_GROUP_ASSOCIATED, new Object[0]);
            return result;
        }
        int i = this.alertPluginInstanceMapper.deleteById((Serializable)Integer.valueOf(id));
        if (i > 0) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> get(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        AlertPluginInstance alertPluginInstance = (AlertPluginInstance)this.alertPluginInstanceMapper.selectById((Serializable)Integer.valueOf(id));
        if (null != alertPluginInstance) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            result.put("data", alertPluginInstance);
        }
        return result;
    }

    @Override
    public Map<String, Object> queryAll() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List alertPluginInstances = this.alertPluginInstanceMapper.queryAllAlertPluginInstanceList();
        List<AlertPluginInstanceVO> alertPluginInstanceVOS = this.buildPluginInstanceVOList(alertPluginInstances);
        if (null != alertPluginInstances) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            result.put("data", alertPluginInstanceVOS);
        }
        return result;
    }

    @Override
    public boolean checkExistPluginInstanceName(String pluginInstanceName) {
        return this.alertPluginInstanceMapper.existInstanceName(pluginInstanceName) == Boolean.TRUE;
    }

    @Override
    public Result queryPluginPage(int pageIndex, int pageSize) {
        Page pluginInstanceIPage = new Page((long)pageIndex, (long)pageSize);
        pluginInstanceIPage = this.alertPluginInstanceMapper.selectPage((IPage)pluginInstanceIPage, null);
        PageInfo<AlertPluginInstanceVO> pageInfo = new PageInfo<AlertPluginInstanceVO>(pageIndex, pageSize);
        pageInfo.setTotal((int)pluginInstanceIPage.getTotal());
        pageInfo.setTotalList(this.buildPluginInstanceVOList(pluginInstanceIPage.getRecords()));
        Result<PageInfo<AlertPluginInstanceVO>> result = new Result<PageInfo<AlertPluginInstanceVO>>();
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private List<AlertPluginInstanceVO> buildPluginInstanceVOList(List<AlertPluginInstance> alertPluginInstances) {
        if (CollectionUtils.isEmpty(alertPluginInstances)) {
            return null;
        }
        List pluginDefineList = this.pluginDefineMapper.queryAllPluginDefineList();
        if (CollectionUtils.isEmpty((Collection)pluginDefineList)) {
            return null;
        }
        Map pluginDefineMap = pluginDefineList.stream().collect(Collectors.toMap(PluginDefine::getId, Function.identity()));
        ArrayList<AlertPluginInstanceVO> alertPluginInstanceVOS = new ArrayList<AlertPluginInstanceVO>();
        alertPluginInstances.forEach(alertPluginInstance -> {
            AlertPluginInstanceVO alertPluginInstanceVO = new AlertPluginInstanceVO();
            alertPluginInstanceVO.setCreateTime(alertPluginInstance.getCreateTime());
            alertPluginInstanceVO.setUpdateTime(alertPluginInstance.getUpdateTime());
            alertPluginInstanceVO.setPluginDefineId(alertPluginInstance.getPluginDefineId());
            alertPluginInstanceVO.setInstanceName(alertPluginInstance.getInstanceName());
            alertPluginInstanceVO.setId(alertPluginInstance.getId());
            PluginDefine pluginDefine = (PluginDefine)pluginDefineMap.get(alertPluginInstance.getPluginDefineId());
            if (null == pluginDefine) {
                return;
            }
            alertPluginInstanceVO.setAlertPluginName(pluginDefine.getPluginName());
            String pluginParamsMapString = alertPluginInstance.getPluginInstanceParams();
            String uiPluginParams = this.parseToPluginUiParams(pluginParamsMapString, pluginDefine.getPluginParams());
            alertPluginInstanceVO.setPluginInstanceParams(uiPluginParams);
            alertPluginInstanceVOS.add(alertPluginInstanceVO);
        });
        return alertPluginInstanceVOS;
    }

    private String parsePluginParamsMap(String pluginParams) {
        Map paramsMap = PluginParamsTransfer.getPluginParamsMap((String)pluginParams);
        return JSONUtils.toJsonString((Object)paramsMap);
    }

    private String parseToPluginUiParams(String pluginParamsMapString, String pluginUiParams) {
        List pluginParamsList = PluginParamsTransfer.generatePluginParams((String)pluginParamsMapString, (String)pluginUiParams);
        return JSONUtils.toJsonString((Object)pluginParamsList);
    }

    private boolean checkHasAssociatedAlertGroup(String id) {
        List idsList = this.alertGroupMapper.queryInstanceIdsList();
        if (CollectionUtils.isEmpty((Collection)idsList)) {
            return false;
        }
        Optional<String> first = idsList.stream().filter(k -> null != k && Arrays.asList(k.split(",")).contains(id)).findFirst();
        return first.isPresent();
    }
}

