/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.dto.EnvironmentDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.EnvironmentService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.EnvironmentWorkerGroupRelation;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.EnvironmentMapper;
import org.apache.dolphinscheduler.dao.mapper.EnvironmentWorkerGroupRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EnvironmentServiceImpl
extends BaseServiceImpl
implements EnvironmentService {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentServiceImpl.class);
    @Autowired
    private EnvironmentMapper environmentMapper;
    @Autowired
    private EnvironmentWorkerGroupRelationMapper relationMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> createEnvironment(User loginUser, String name, String config, String desc, String workerGroups) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        Map<String, Object> checkResult = this.checkParams(name, config, workerGroups);
        if (checkResult.get("status") != Status.SUCCESS) {
            return checkResult;
        }
        Environment environment = this.environmentMapper.queryByEnvironmentName(name);
        if (environment != null) {
            this.putMsg(result, Status.ENVIRONMENT_NAME_EXISTS, name);
            return result;
        }
        Environment env = new Environment();
        env.setName(name);
        env.setConfig(config);
        env.setDescription(desc);
        env.setOperator(Integer.valueOf(loginUser.getId()));
        env.setCreateTime(new Date());
        env.setUpdateTime(new Date());
        long code = 0L;
        try {
            code = CodeGenerateUtils.getInstance().genCode();
            env.setCode(Long.valueOf(code));
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            logger.error("Environment code get error, ", (Throwable)e);
        }
        if (code == 0L) {
            this.putMsg(result, Status.INTERNAL_SERVER_ERROR_ARGS, "Error generating environment code");
            return result;
        }
        if (this.environmentMapper.insert((Object)env) > 0) {
            List workerGroupList;
            if (!StringUtils.isEmpty((String)workerGroups) && CollectionUtils.isNotEmpty((Collection)(workerGroupList = (List)JSONUtils.parseObject((String)workerGroups, (TypeReference)new TypeReference<List<String>>(){})))) {
                workerGroupList.stream().forEach(workerGroup -> {
                    if (!StringUtils.isEmpty((String)workerGroup)) {
                        EnvironmentWorkerGroupRelation relation = new EnvironmentWorkerGroupRelation();
                        relation.setEnvironmentCode(env.getCode());
                        relation.setWorkerGroup(workerGroup);
                        relation.setOperator(Integer.valueOf(loginUser.getId()));
                        relation.setCreateTime(new Date());
                        relation.setUpdateTime(new Date());
                        this.relationMapper.insert((Object)relation);
                    }
                });
            }
            result.put("data", env.getCode());
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.CREATE_ENVIRONMENT_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Result queryEnvironmentListPaging(Integer pageNo, Integer pageSize, String searchVal) {
        Result result = new Result();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage environmentIPage = this.environmentMapper.queryEnvironmentListPaging((IPage)page, searchVal);
        PageInfo<Object> pageInfo = new PageInfo<Object>(pageNo, pageSize);
        pageInfo.setTotal((int)environmentIPage.getTotal());
        if (CollectionUtils.isNotEmpty((Collection)environmentIPage.getRecords())) {
            Map relationMap = this.relationMapper.selectList(null).stream().collect(Collectors.groupingBy(EnvironmentWorkerGroupRelation::getEnvironmentCode, Collectors.mapping(EnvironmentWorkerGroupRelation::getWorkerGroup, Collectors.toList())));
            List dtoList = environmentIPage.getRecords().stream().map(environment -> {
                EnvironmentDto dto = new EnvironmentDto();
                BeanUtils.copyProperties((Object)environment, (Object)dto);
                List workerGroups = relationMap.getOrDefault(environment.getCode(), new ArrayList());
                dto.setWorkerGroups(workerGroups);
                return dto;
            }).collect(Collectors.toList());
            pageInfo.setTotalList(dtoList);
        } else {
            pageInfo.setTotalList(new ArrayList());
        }
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryAllEnvironmentList() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List environmentList = this.environmentMapper.queryAllEnvironmentList();
        if (CollectionUtils.isNotEmpty((Collection)environmentList)) {
            Map relationMap = this.relationMapper.selectList(null).stream().collect(Collectors.groupingBy(EnvironmentWorkerGroupRelation::getEnvironmentCode, Collectors.mapping(EnvironmentWorkerGroupRelation::getWorkerGroup, Collectors.toList())));
            List dtoList = environmentList.stream().map(environment -> {
                EnvironmentDto dto = new EnvironmentDto();
                BeanUtils.copyProperties((Object)environment, (Object)dto);
                List workerGroups = relationMap.getOrDefault(environment.getCode(), new ArrayList());
                dto.setWorkerGroups(workerGroups);
                return dto;
            }).collect(Collectors.toList());
            result.put("data", dtoList);
        } else {
            result.put("data", new ArrayList());
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryEnvironmentByCode(Long code) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Environment env = this.environmentMapper.queryByEnvironmentCode(code);
        if (env == null) {
            this.putMsg(result, Status.QUERY_ENVIRONMENT_BY_CODE_ERROR, code);
        } else {
            List<String> workerGroups = this.relationMapper.queryByEnvironmentCode(env.getCode()).stream().map(item -> item.getWorkerGroup()).collect(Collectors.toList());
            EnvironmentDto dto = new EnvironmentDto();
            BeanUtils.copyProperties((Object)env, (Object)dto);
            dto.setWorkerGroups(workerGroups);
            result.put("data", dto);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> queryEnvironmentByName(String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Environment env = this.environmentMapper.queryByEnvironmentName(name);
        if (env == null) {
            this.putMsg(result, Status.QUERY_ENVIRONMENT_BY_NAME_ERROR, name);
        } else {
            List<String> workerGroups = this.relationMapper.queryByEnvironmentCode(env.getCode()).stream().map(item -> item.getWorkerGroup()).collect(Collectors.toList());
            EnvironmentDto dto = new EnvironmentDto();
            BeanUtils.copyProperties((Object)env, (Object)dto);
            dto.setWorkerGroups(workerGroups);
            result.put("data", dto);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> deleteEnvironmentByCode(User loginUser, Long code) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        Integer relatedTaskNumber = this.taskDefinitionMapper.selectCount((Wrapper)new QueryWrapper().lambda().eq(TaskDefinition::getEnvironmentCode, (Object)code));
        if (relatedTaskNumber > 0) {
            this.putMsg(result, Status.DELETE_ENVIRONMENT_RELATED_TASK_EXISTS, new Object[0]);
            return result;
        }
        int delete = this.environmentMapper.deleteByCode(code);
        if (delete > 0) {
            this.relationMapper.delete((Wrapper)new QueryWrapper().lambda().eq(EnvironmentWorkerGroupRelation::getEnvironmentCode, (Object)code));
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.DELETE_ENVIRONMENT_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> updateEnvironmentByCode(User loginUser, Long code, String name, String config, String desc, String workerGroups) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        Map<String, Object> checkResult = this.checkParams(name, config, workerGroups);
        if (checkResult.get("status") != Status.SUCCESS) {
            return checkResult;
        }
        Environment environment = this.environmentMapper.queryByEnvironmentName(name);
        if (environment != null && !environment.getCode().equals(code)) {
            this.putMsg(result, Status.ENVIRONMENT_NAME_EXISTS, name);
            return result;
        }
        Set workerGroupSet = !StringUtils.isEmpty((String)workerGroups) ? (Set)JSONUtils.parseObject((String)workerGroups, (TypeReference)new TypeReference<Set<String>>(){}) : new TreeSet();
        Set existWorkerGroupSet = this.relationMapper.queryByEnvironmentCode(code).stream().map(item -> item.getWorkerGroup()).collect(Collectors.toSet());
        Set deleteWorkerGroupSet = SetUtils.difference(existWorkerGroupSet, workerGroupSet).toSet();
        Set addWorkerGroupSet = SetUtils.difference(workerGroupSet, existWorkerGroupSet).toSet();
        checkResult = this.checkUsedEnvironmentWorkerGroupRelation(deleteWorkerGroupSet, name, code);
        if (checkResult.get("status") != Status.SUCCESS) {
            return checkResult;
        }
        Environment env = new Environment();
        env.setCode(code);
        env.setName(name);
        env.setConfig(config);
        env.setDescription(desc);
        env.setOperator(Integer.valueOf(loginUser.getId()));
        env.setUpdateTime(new Date());
        int update = this.environmentMapper.update((Object)env, (Wrapper)new UpdateWrapper().lambda().eq(Environment::getCode, (Object)code));
        if (update > 0) {
            deleteWorkerGroupSet.stream().forEach(key -> {
                if (!StringUtils.isEmpty((String)key)) {
                    this.relationMapper.delete((Wrapper)new QueryWrapper().lambda().eq(EnvironmentWorkerGroupRelation::getEnvironmentCode, (Object)code));
                }
            });
            addWorkerGroupSet.stream().forEach(key -> {
                if (!StringUtils.isEmpty((String)key)) {
                    EnvironmentWorkerGroupRelation relation = new EnvironmentWorkerGroupRelation();
                    relation.setEnvironmentCode(code);
                    relation.setWorkerGroup(key);
                    relation.setUpdateTime(new Date());
                    relation.setCreateTime(new Date());
                    relation.setOperator(Integer.valueOf(loginUser.getId()));
                    this.relationMapper.insert((Object)relation);
                }
            });
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.UPDATE_ENVIRONMENT_ERROR, name);
        }
        return result;
    }

    @Override
    public Map<String, Object> verifyEnvironment(String environmentName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)environmentName)) {
            this.putMsg(result, Status.ENVIRONMENT_NAME_IS_NULL, new Object[0]);
            return result;
        }
        Environment environment = this.environmentMapper.queryByEnvironmentName(environmentName);
        if (environment != null) {
            this.putMsg(result, Status.ENVIRONMENT_NAME_EXISTS, environmentName);
            return result;
        }
        result.put("status", (Object)Status.SUCCESS);
        return result;
    }

    private Map<String, Object> checkUsedEnvironmentWorkerGroupRelation(Set<String> deleteKeySet, String environmentName, Long environmentCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String workerGroup : deleteKeySet) {
            TaskDefinition taskDefinition = (TaskDefinition)this.taskDefinitionMapper.selectOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(TaskDefinition::getEnvironmentCode, (Object)environmentCode)).eq(TaskDefinition::getWorkerGroup, (Object)workerGroup));
            if (!Objects.nonNull(taskDefinition)) continue;
            this.putMsg(result, Status.UPDATE_ENVIRONMENT_WORKER_GROUP_RELATION_ERROR, workerGroup, environmentName, taskDefinition.getName());
            return result;
        }
        result.put("status", (Object)Status.SUCCESS);
        return result;
    }

    public Map<String, Object> checkParams(String name, String config, String workerGroups) {
        List workerGroupList;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)name)) {
            this.putMsg(result, Status.ENVIRONMENT_NAME_IS_NULL, new Object[0]);
            return result;
        }
        if (StringUtils.isEmpty((String)config)) {
            this.putMsg(result, Status.ENVIRONMENT_CONFIG_IS_NULL, new Object[0]);
            return result;
        }
        if (!StringUtils.isEmpty((String)workerGroups) && Objects.isNull(workerGroupList = (List)JSONUtils.parseObject((String)workerGroups, (TypeReference)new TypeReference<List<String>>(){}))) {
            this.putMsg(result, Status.ENVIRONMENT_WORKER_GROUPS_IS_INVALID, new Object[0]);
            return result;
        }
        result.put("status", (Object)Status.SUCCESS);
        return result;
    }
}

