/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.dto.DagDataSchedule;
import org.apache.dolphinscheduler.api.dto.treeview.Instance;
import org.apache.dolphinscheduler.api.dto.treeview.TreeViewDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ProcessDefinitionService;
import org.apache.dolphinscheduler.api.service.ProcessInstanceService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.SchedulerService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.CheckUtils;
import org.apache.dolphinscheduler.api.utils.FileUtils;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.Constants;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.DagData;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProcessDefinitionServiceImpl
extends BaseServiceImpl
implements ProcessDefinitionService {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDefinitionServiceImpl.class);
    private static final String RELEASESTATE = "releaseState";
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private ProcessDefinitionLogMapper processDefinitionLogMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private TaskInstanceMapper taskInstanceMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessTaskRelationMapper processTaskRelationMapper;
    @Autowired
    private ProcessTaskRelationLogMapper processTaskRelationLogMapper;
    @Autowired
    TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private SchedulerService schedulerService;
    @Autowired
    private TenantMapper tenantMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> createProcessDefinition(User loginUser, long projectCode, String name, String description, String globalParams, String locations, int timeout, String tenantCode, String taskRelationJson, String taskDefinitionJson) {
        long processDefinitionCode;
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition definition = this.processDefinitionMapper.verifyByDefineName(project.getCode(), name);
        if (definition != null) {
            this.putMsg(result, Status.PROCESS_DEFINITION_NAME_EXIST, name);
            return result;
        }
        List taskDefinitionLogs = JSONUtils.toList((String)taskDefinitionJson, TaskDefinitionLog.class);
        Map<String, Object> checkTaskDefinitions = this.checkTaskDefinitionList(taskDefinitionLogs, taskDefinitionJson);
        if (checkTaskDefinitions.get("status") != Status.SUCCESS) {
            return checkTaskDefinitions;
        }
        List taskRelationList = JSONUtils.toList((String)taskRelationJson, ProcessTaskRelationLog.class);
        Map<String, Object> checkRelationJson = this.checkTaskRelationList(taskRelationList, taskRelationJson, taskDefinitionLogs);
        if (checkRelationJson.get("status") != Status.SUCCESS) {
            return checkRelationJson;
        }
        int tenantId = -1;
        if (!"default".equals(tenantCode)) {
            Tenant tenant = this.tenantMapper.queryByTenantCode(tenantCode);
            if (tenant == null) {
                this.putMsg(result, Status.TENANT_NOT_EXIST, new Object[0]);
                return result;
            }
            tenantId = tenant.getId();
        }
        try {
            processDefinitionCode = CodeGenerateUtils.getInstance().genCode();
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            this.putMsg(result, Status.INTERNAL_SERVER_ERROR_ARGS, new Object[0]);
            return result;
        }
        ProcessDefinition processDefinition = new ProcessDefinition(projectCode, name, processDefinitionCode, description, globalParams, locations, timeout, loginUser.getId(), tenantId);
        return this.createDagDefine(loginUser, taskRelationList, processDefinition, taskDefinitionLogs);
    }

    private Map<String, Object> createDagDefine(User loginUser, List<ProcessTaskRelationLog> taskRelationList, ProcessDefinition processDefinition, List<TaskDefinitionLog> taskDefinitionLogs) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int saveTaskResult = this.processService.saveTaskDefine(loginUser, processDefinition.getProjectCode(), taskDefinitionLogs);
        if (saveTaskResult == 0) {
            logger.info("The task has not changed, so skip");
        }
        if (saveTaskResult == -1) {
            this.putMsg(result, Status.CREATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.CREATE_TASK_DEFINITION_ERROR);
        }
        int insertVersion = this.processService.saveProcessDefine(loginUser, processDefinition, Boolean.valueOf(true));
        if (insertVersion == 0) {
            this.putMsg(result, Status.CREATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.CREATE_PROCESS_DEFINITION_ERROR);
        }
        int insertResult = this.processService.saveTaskRelation(loginUser, processDefinition.getProjectCode(), processDefinition.getCode(), insertVersion, taskRelationList, taskDefinitionLogs);
        if (insertResult != 0) {
            this.putMsg(result, Status.CREATE_PROCESS_TASK_RELATION_ERROR, new Object[0]);
            throw new ServiceException(Status.CREATE_PROCESS_TASK_RELATION_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", processDefinition);
        return result;
    }

    private Map<String, Object> checkTaskDefinitionList(List<TaskDefinitionLog> taskDefinitionLogs, String taskDefinitionJson) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (taskDefinitionLogs.isEmpty()) {
                logger.error("taskDefinitionJson invalid: {}", (Object)taskDefinitionJson);
                this.putMsg(result, Status.DATA_IS_NOT_VALID, taskDefinitionJson);
                return result;
            }
            for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogs) {
                if (CheckUtils.checkTaskDefinitionParameters((TaskDefinition)taskDefinitionLog)) continue;
                logger.error("task definition {} parameter invalid", (Object)taskDefinitionLog.getName());
                this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskDefinitionLog.getName());
                return result;
            }
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        catch (Exception e) {
            result.put("status", (Object)Status.REQUEST_PARAMS_NOT_VALID_ERROR);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    private Map<String, Object> checkTaskRelationList(List<ProcessTaskRelationLog> taskRelationList, String taskRelationJson, List<TaskDefinitionLog> taskDefinitionLogs) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Set taskNodeCodes;
            Set postTaskCodes;
            Collection codes;
            if (taskRelationList == null || taskRelationList.isEmpty()) {
                logger.error("task relation list is null");
                this.putMsg(result, Status.DATA_IS_NOT_VALID, taskRelationJson);
                return result;
            }
            List processTaskRelations = taskRelationList.stream().map(processTaskRelationLog -> (ProcessTaskRelation)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)processTaskRelationLog), ProcessTaskRelation.class)).collect(Collectors.toList());
            List taskNodeList = this.processService.transformTask(processTaskRelations, taskDefinitionLogs);
            if (taskNodeList.size() != taskRelationList.size() && CollectionUtils.isNotEmpty((Collection)(codes = CollectionUtils.subtract(postTaskCodes = taskRelationList.stream().map(ProcessTaskRelation::getPostTaskCode).collect(Collectors.toSet()), taskNodeCodes = taskNodeList.stream().map(TaskNode::getCode).collect(Collectors.toSet()))))) {
                logger.error("the task code is not exit");
                this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, StringUtils.join((Collection)codes, (String)","));
                return result;
            }
            if (this.graphHasCycle(taskNodeList)) {
                logger.error("process DAG has cycle");
                this.putMsg(result, Status.PROCESS_NODE_HAS_CYCLE, new Object[0]);
                return result;
            }
            for (ProcessTaskRelationLog processTaskRelationLog2 : taskRelationList) {
                if (processTaskRelationLog2.getPostTaskCode() != 0L) continue;
                logger.error("the post_task_code or post_task_version can't be zero");
                this.putMsg(result, Status.CHECK_PROCESS_TASK_RELATION_ERROR, new Object[0]);
                return result;
            }
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        catch (Exception e) {
            result.put("status", (Object)Status.REQUEST_PARAMS_NOT_VALID_ERROR);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    @Override
    public Map<String, Object> queryProcessDefinitionList(User loginUser, long projectCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List resourceList = this.processDefinitionMapper.queryAllDefinitionList(projectCode);
        List dagDataList = resourceList.stream().map(arg_0 -> ((ProcessService)this.processService).genDagData(arg_0)).collect(Collectors.toList());
        result.put("data", dagDataList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryProcessDefinitionSimpleList(User loginUser, long projectCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List processDefinitions = this.processDefinitionMapper.queryAllDefinitionList(projectCode);
        ArrayNode arrayNode = JSONUtils.createArrayNode();
        for (ProcessDefinition processDefinition : processDefinitions) {
            ObjectNode processDefinitionNode = JSONUtils.createObjectNode();
            processDefinitionNode.put("id", processDefinition.getId());
            processDefinitionNode.put("code", processDefinition.getCode());
            processDefinitionNode.put("name", processDefinition.getName());
            processDefinitionNode.put("projectCode", processDefinition.getCode());
            arrayNode.add((JsonNode)processDefinitionNode);
        }
        result.put("data", arrayNode);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryProcessDefinitionListPaging(User loginUser, long projectCode, String searchVal, Integer userId, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            this.putMsg(result, resultStatus, new Object[0]);
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage processDefinitionIPage = this.processDefinitionMapper.queryDefineListPaging((IPage)page, searchVal, userId.intValue(), project.getCode(), this.isAdmin(loginUser));
        List records = processDefinitionIPage.getRecords();
        for (ProcessDefinition pd : records) {
            ProcessDefinitionLog processDefinitionLog = this.processDefinitionLogMapper.queryByDefinitionCodeAndVersion(pd.getCode(), pd.getVersion());
            User user = (User)this.userMapper.selectById((Serializable)Integer.valueOf(processDefinitionLog.getOperator()));
            pd.setModifyBy(user.getUserName());
        }
        processDefinitionIPage.setRecords(records);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal((int)processDefinitionIPage.getTotal());
        pageInfo.setTotalList(processDefinitionIPage.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryProcessDefinitionByCode(User loginUser, long projectCode, long code) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(code);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, code);
        } else {
            Tenant tenant = this.tenantMapper.queryById(processDefinition.getTenantId());
            if (tenant != null) {
                processDefinition.setTenantCode(tenant.getTenantCode());
            }
            DagData dagData = this.processService.genDagData(processDefinition);
            result.put("data", dagData);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> queryProcessDefinitionByName(User loginUser, long projectCode, String name) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByDefineName(projectCode, name);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, name);
        } else {
            DagData dagData = this.processService.genDagData(processDefinition);
            result.put("data", dagData);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> updateProcessDefinition(User loginUser, long projectCode, String name, long code, String description, String globalParams, String locations, int timeout, String tenantCode, String taskRelationJson, String taskDefinitionJson) {
        ProcessDefinition definition;
        ProcessDefinition processDefinition;
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List taskDefinitionLogs = JSONUtils.toList((String)taskDefinitionJson, TaskDefinitionLog.class);
        Map<String, Object> checkTaskDefinitions = this.checkTaskDefinitionList(taskDefinitionLogs, taskDefinitionJson);
        if (checkTaskDefinitions.get("status") != Status.SUCCESS) {
            return checkTaskDefinitions;
        }
        List taskRelationList = JSONUtils.toList((String)taskRelationJson, ProcessTaskRelationLog.class);
        Map<String, Object> checkRelationJson = this.checkTaskRelationList(taskRelationList, taskRelationJson, taskDefinitionLogs);
        if (checkRelationJson.get("status") != Status.SUCCESS) {
            return checkRelationJson;
        }
        int tenantId = -1;
        if (!"default".equals(tenantCode)) {
            Tenant tenant = this.tenantMapper.queryByTenantCode(tenantCode);
            if (tenant == null) {
                this.putMsg(result, Status.TENANT_NOT_EXIST, new Object[0]);
                return result;
            }
            tenantId = tenant.getId();
        }
        if ((processDefinition = this.processDefinitionMapper.queryByCode(code)) == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, code);
            return result;
        }
        if (processDefinition.getReleaseState() == ReleaseState.ONLINE) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_ALLOWED_EDIT, processDefinition.getName());
            return result;
        }
        if (!name.equals(processDefinition.getName()) && (definition = this.processDefinitionMapper.verifyByDefineName(project.getCode(), name)) != null) {
            this.putMsg(result, Status.PROCESS_DEFINITION_NAME_EXIST, name);
            return result;
        }
        ProcessDefinition processDefinitionDeepCopy = (ProcessDefinition)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)processDefinition), ProcessDefinition.class);
        processDefinition.set(projectCode, name, description, globalParams, locations, timeout, tenantId);
        return this.updateDagDefine(loginUser, taskRelationList, processDefinition, processDefinitionDeepCopy, taskDefinitionLogs);
    }

    private Map<String, Object> updateDagDefine(User loginUser, List<ProcessTaskRelationLog> taskRelationList, ProcessDefinition processDefinition, ProcessDefinition processDefinitionDeepCopy, List<TaskDefinitionLog> taskDefinitionLogs) {
        int insertVersion;
        HashMap<String, Object> result = new HashMap<String, Object>();
        int saveTaskResult = this.processService.saveTaskDefine(loginUser, processDefinition.getProjectCode(), taskDefinitionLogs);
        if (saveTaskResult == 0) {
            logger.info("The task has not changed, so skip");
        }
        if (saveTaskResult == -1) {
            this.putMsg(result, Status.UPDATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        if (processDefinition.equals((Object)processDefinitionDeepCopy)) {
            insertVersion = processDefinitionDeepCopy.getVersion();
        } else {
            processDefinition.setUpdateTime(new Date());
            insertVersion = this.processService.saveProcessDefine(loginUser, processDefinition, Boolean.valueOf(true));
        }
        if (insertVersion == 0) {
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        int insertResult = this.processService.saveTaskRelation(loginUser, processDefinition.getProjectCode(), processDefinition.getCode(), insertVersion, taskRelationList, taskDefinitionLogs);
        if (insertResult != 0) {
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", processDefinition);
        return result;
    }

    @Override
    public Map<String, Object> verifyProcessDefinitionName(User loginUser, long projectCode, String name) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.verifyByDefineName(project.getCode(), name.trim());
        if (processDefinition == null) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.PROCESS_DEFINITION_NAME_EXIST, name.trim());
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> deleteProcessDefinitionByCode(User loginUser, long projectCode, long code) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(code);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, code);
            return result;
        }
        if (loginUser.getId() != processDefinition.getUserId() && loginUser.getUserType() != UserType.ADMIN_USER) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (processDefinition.getReleaseState() == ReleaseState.ONLINE) {
            this.putMsg(result, Status.PROCESS_DEFINE_STATE_ONLINE, code);
            return result;
        }
        List<ProcessInstance> processInstances = this.processInstanceService.queryByProcessDefineCodeAndStatus(processDefinition.getCode(), Constants.NOT_TERMINATED_STATES);
        if (CollectionUtils.isNotEmpty(processInstances)) {
            this.putMsg(result, Status.DELETE_PROCESS_DEFINITION_BY_CODE_FAIL, processInstances.size());
            return result;
        }
        List schedules = this.scheduleMapper.queryByProcessDefinitionCode(code);
        if (!schedules.isEmpty() && schedules.size() > 1) {
            logger.warn("scheduler num is {},Greater than 1", (Object)schedules.size());
            this.putMsg(result, Status.DELETE_PROCESS_DEFINE_BY_CODE_ERROR, new Object[0]);
            return result;
        }
        if (schedules.size() == 1) {
            Schedule schedule = (Schedule)schedules.get(0);
            if (schedule.getReleaseState() == ReleaseState.OFFLINE) {
                int delete = this.scheduleMapper.deleteById((Serializable)Integer.valueOf(schedule.getId()));
                if (delete == 0) {
                    this.putMsg(result, Status.DELETE_SCHEDULE_CRON_BY_ID_ERROR, new Object[0]);
                    throw new ServiceException(Status.DELETE_SCHEDULE_CRON_BY_ID_ERROR);
                }
            } else if (schedule.getReleaseState() == ReleaseState.ONLINE) {
                this.putMsg(result, Status.SCHEDULE_CRON_STATE_ONLINE, schedule.getId());
                return result;
            }
        }
        int delete = this.processDefinitionMapper.deleteById((Serializable)Integer.valueOf(processDefinition.getId()));
        int deleteRelation = this.processTaskRelationMapper.deleteByCode(project.getCode(), processDefinition.getCode());
        if (delete == 0 || deleteRelation == 0) {
            this.putMsg(result, Status.DELETE_PROCESS_DEFINE_BY_CODE_ERROR, new Object[0]);
            throw new ServiceException(Status.DELETE_PROCESS_DEFINE_BY_CODE_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> releaseProcessDefinition(User loginUser, long projectCode, long code, ReleaseState releaseState) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (null == releaseState) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, RELEASESTATE);
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(code);
        switch (releaseState) {
            case ONLINE: {
                processDefinition.setReleaseState(releaseState);
                this.processDefinitionMapper.updateById((Object)processDefinition);
                break;
            }
            case OFFLINE: {
                processDefinition.setReleaseState(releaseState);
                int updateProcess = this.processDefinitionMapper.updateById((Object)processDefinition);
                List scheduleList = this.scheduleMapper.selectAllByProcessDefineArray(new long[]{processDefinition.getCode()});
                if (updateProcess <= 0 || scheduleList.size() != 1) break;
                Schedule schedule = (Schedule)scheduleList.get(0);
                logger.info("set schedule offline, project id: {}, schedule id: {}, process definition code: {}", new Object[]{project.getId(), schedule.getId(), code});
                schedule.setReleaseState(ReleaseState.OFFLINE);
                int updateSchedule = this.scheduleMapper.updateById((Object)schedule);
                if (updateSchedule == 0) {
                    this.putMsg(result, Status.OFFLINE_SCHEDULE_ERROR, new Object[0]);
                    throw new ServiceException(Status.OFFLINE_SCHEDULE_ERROR);
                }
                this.schedulerService.deleteSchedule(project.getId(), schedule.getId());
                break;
            }
            default: {
                this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, RELEASESTATE);
                return result;
            }
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public void batchExportProcessDefinitionByCodes(User loginUser, long projectCode, String codes, HttpServletResponse response) {
        if (StringUtils.isEmpty((String)codes)) {
            return;
        }
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return;
        }
        Set defineCodeSet = Lists.newArrayList((Object[])codes.split(",")).stream().map(Long::parseLong).collect(Collectors.toSet());
        List processDefinitionList = this.processDefinitionMapper.queryByCodes(defineCodeSet);
        List<DagDataSchedule> dagDataSchedules = processDefinitionList.stream().map(this::exportProcessDagData).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(dagDataSchedules)) {
            this.downloadProcessDefinitionFile(response, dagDataSchedules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadProcessDefinitionFile(HttpServletResponse response, List<DagDataSchedule> dagDataSchedules) {
        response.setContentType("application/json;charset=UTF-8");
        BufferedOutputStream buff = null;
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            buff = new BufferedOutputStream((OutputStream)out);
            buff.write(JSONUtils.toJsonString(dagDataSchedules).getBytes(StandardCharsets.UTF_8));
            buff.flush();
            buff.close();
        }
        catch (IOException e) {
            logger.warn("export process fail", (Throwable)e);
        }
        finally {
            if (null != buff) {
                try {
                    buff.close();
                }
                catch (Exception e) {
                    logger.warn("export process buffer not close", (Throwable)e);
                }
            }
            if (null != out) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    logger.warn("export process output stream not close", (Throwable)e);
                }
            }
        }
    }

    public DagDataSchedule exportProcessDagData(ProcessDefinition processDefinition) {
        List schedules = this.scheduleMapper.queryByProcessDefinitionCode(processDefinition.getCode());
        DagDataSchedule dagDataSchedule = new DagDataSchedule(this.processService.genDagData(processDefinition));
        if (!schedules.isEmpty()) {
            Schedule schedule = (Schedule)schedules.get(0);
            schedule.setReleaseState(ReleaseState.OFFLINE);
            dagDataSchedule.setSchedule(schedule);
        }
        return dagDataSchedule;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> importProcessDefinition(User loginUser, long projectCode, MultipartFile file) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String dagDataScheduleJson = FileUtils.file2String(file);
        List dagDataScheduleList = JSONUtils.toList((String)dagDataScheduleJson, DagDataSchedule.class);
        if (CollectionUtils.isEmpty((Collection)dagDataScheduleList)) {
            this.putMsg(result, Status.DATA_IS_NULL, "fileContent");
            return result;
        }
        for (DagDataSchedule dagDataSchedule : dagDataScheduleList) {
            if (this.checkAndImport(loginUser, projectCode, result, dagDataSchedule)) continue;
            return result;
        }
        return result;
    }

    private boolean checkAndImport(User loginUser, long projectCode, Map<String, Object> result, DagDataSchedule dagDataSchedule) {
        if (!this.checkImportanceParams(dagDataSchedule, result)) {
            return false;
        }
        ProcessDefinition processDefinition = dagDataSchedule.getProcessDefinition();
        Map<String, Object> checkResult = this.verifyProcessDefinitionName(loginUser, projectCode, processDefinition.getName());
        if (!Status.SUCCESS.equals(checkResult.get("status"))) {
            result.putAll(checkResult);
            return false;
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        String processDefinitionName = this.recursionProcessDefinitionName(projectCode, processDefinition.getName(), 1);
        processDefinition.setName(processDefinitionName + "_import_" + DateUtils.getCurrentTimeStamp());
        processDefinition.setId(0);
        processDefinition.setProjectCode(projectCode);
        processDefinition.setUserId(loginUser.getId());
        try {
            processDefinition.setCode(CodeGenerateUtils.getInstance().genCode());
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            this.putMsg(result, Status.CREATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            return false;
        }
        List taskDefinitionList = dagDataSchedule.getTaskDefinitionList();
        HashMap<Long, Long> taskCodeMap = new HashMap<Long, Long>();
        Date now = new Date();
        ArrayList<TaskDefinitionLog> taskDefinitionLogList = new ArrayList<TaskDefinitionLog>();
        for (TaskDefinition taskDefinition : taskDefinitionList) {
            TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog(taskDefinition);
            taskDefinitionLog.setName(taskDefinitionLog.getName() + "_import_" + DateUtils.getCurrentTimeStamp());
            taskDefinitionLog.setProjectCode(projectCode);
            taskDefinitionLog.setUserId(loginUser.getId());
            taskDefinitionLog.setVersion(1);
            taskDefinitionLog.setCreateTime(now);
            taskDefinitionLog.setUpdateTime(now);
            taskDefinitionLog.setOperator(loginUser.getId());
            taskDefinitionLog.setOperateTime(now);
            try {
                long code = CodeGenerateUtils.getInstance().genCode();
                taskCodeMap.put(taskDefinitionLog.getCode(), code);
                taskDefinitionLog.setCode(code);
            }
            catch (CodeGenerateUtils.CodeGenerateException e) {
                logger.error("Task code get error, ", (Throwable)e);
                this.putMsg(result, Status.INTERNAL_SERVER_ERROR_ARGS, "Error generating task definition code");
                return false;
            }
            taskDefinitionLogList.add(taskDefinitionLog);
        }
        int insert = this.taskDefinitionMapper.batchInsert(taskDefinitionLogList);
        int logInsert = this.taskDefinitionLogMapper.batchInsert(taskDefinitionLogList);
        if ((logInsert & insert) == 0) {
            this.putMsg(result, Status.CREATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.CREATE_TASK_DEFINITION_ERROR);
        }
        List taskRelationList = dagDataSchedule.getProcessTaskRelationList();
        ArrayList<ProcessTaskRelationLog> taskRelationLogList = new ArrayList<ProcessTaskRelationLog>();
        for (ProcessTaskRelation processTaskRelation : taskRelationList) {
            ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog(processTaskRelation);
            if (taskCodeMap.containsKey(processTaskRelationLog.getPreTaskCode())) {
                processTaskRelationLog.setPreTaskCode(((Long)taskCodeMap.get(processTaskRelationLog.getPreTaskCode())).longValue());
            }
            if (taskCodeMap.containsKey(processTaskRelationLog.getPostTaskCode())) {
                processTaskRelationLog.setPostTaskCode(((Long)taskCodeMap.get(processTaskRelationLog.getPostTaskCode())).longValue());
            }
            processTaskRelationLog.setPreTaskVersion(1);
            processTaskRelationLog.setPostTaskVersion(1);
            taskRelationLogList.add(processTaskRelationLog);
        }
        Map<String, Object> createDagResult = this.createDagDefine(loginUser, taskRelationLogList, processDefinition, Lists.newArrayList());
        if (!Status.SUCCESS.equals(createDagResult.get("status"))) {
            result.putAll(createDagResult);
            throw new ServiceException(Status.IMPORT_PROCESS_DEFINE_ERROR);
        }
        this.putMsg(createDagResult, Status.SUCCESS, new Object[0]);
        Schedule schedule = dagDataSchedule.getSchedule();
        if (null != schedule) {
            ProcessDefinition newProcessDefinition = this.processDefinitionMapper.queryByCode(processDefinition.getCode());
            schedule.setProcessDefinitionCode(newProcessDefinition.getCode());
            schedule.setUserId(loginUser.getId());
            schedule.setCreateTime(now);
            schedule.setUpdateTime(now);
            int scheduleInsert = this.scheduleMapper.insert((Object)schedule);
            if (0 == scheduleInsert) {
                this.putMsg(result, Status.IMPORT_PROCESS_DEFINE_ERROR, new Object[0]);
                throw new ServiceException(Status.IMPORT_PROCESS_DEFINE_ERROR);
            }
        }
        return true;
    }

    private boolean checkImportanceParams(DagDataSchedule dagDataSchedule, Map<String, Object> result) {
        if (dagDataSchedule.getProcessDefinition() == null) {
            this.putMsg(result, Status.DATA_IS_NULL, "ProcessDefinition");
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)dagDataSchedule.getTaskDefinitionList())) {
            this.putMsg(result, Status.DATA_IS_NULL, "TaskDefinitionList");
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)dagDataSchedule.getProcessTaskRelationList())) {
            this.putMsg(result, Status.DATA_IS_NULL, "ProcessTaskRelationList");
            return false;
        }
        return true;
    }

    private String recursionProcessDefinitionName(long projectCode, String processDefinitionName, int num) {
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByDefineName(projectCode, processDefinitionName);
        if (processDefinition != null) {
            if (num > 1) {
                String str = processDefinitionName.substring(0, processDefinitionName.length() - 3);
                processDefinitionName = str + "(" + num + ")";
            } else {
                processDefinitionName = processDefinition.getName() + "(" + num + ")";
            }
        } else {
            return processDefinitionName;
        }
        return this.recursionProcessDefinitionName(projectCode, processDefinitionName, num + 1);
    }

    @Override
    public Map<String, Object> checkProcessNodeList(String processTaskRelationJson) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (processTaskRelationJson == null) {
                logger.error("process data is null");
                this.putMsg(result, Status.DATA_IS_NOT_VALID, processTaskRelationJson);
                return result;
            }
            List taskRelationList = JSONUtils.toList((String)processTaskRelationJson, ProcessTaskRelation.class);
            List taskNodes = this.processService.transformTask(taskRelationList, (List)Lists.newArrayList());
            if (CollectionUtils.isEmpty((Collection)taskNodes)) {
                logger.error("process node info is empty");
                this.putMsg(result, Status.PROCESS_DAG_IS_EMPTY, new Object[0]);
                return result;
            }
            if (this.graphHasCycle(taskNodes)) {
                logger.error("process DAG has cycle");
                this.putMsg(result, Status.PROCESS_NODE_HAS_CYCLE, new Object[0]);
                return result;
            }
            for (TaskNode taskNode : taskNodes) {
                if (!CheckUtils.checkTaskNodeParameters(taskNode)) {
                    logger.error("task node {} parameter invalid", (Object)taskNode.getName());
                    this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskNode.getName());
                    return result;
                }
                CheckUtils.checkOtherParams(taskNode.getExtras());
            }
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        catch (Exception e) {
            result.put("status", (Object)Status.REQUEST_PARAMS_NOT_VALID_ERROR);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    @Override
    public Map<String, Object> getTaskNodeListByDefinitionCode(User loginUser, long projectCode, long code) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(code);
        if (processDefinition == null) {
            logger.info("process define not exists");
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, code);
            return result;
        }
        DagData dagData = this.processService.genDagData(processDefinition);
        result.put("data", dagData.getTaskDefinitionList());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> getNodeListMapByDefinitionCodes(User loginUser, long projectCode, String codes) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        Set defineCodeSet = Lists.newArrayList((Object[])codes.split(",")).stream().map(Long::parseLong).collect(Collectors.toSet());
        List processDefinitionList = this.processDefinitionMapper.queryByCodes(defineCodeSet);
        if (CollectionUtils.isEmpty((Collection)processDefinitionList)) {
            logger.info("process definition not exists");
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, codes);
            return result;
        }
        HashMap<Long, List> taskNodeMap = new HashMap<Long, List>();
        for (ProcessDefinition processDefinition : processDefinitionList) {
            DagData dagData = this.processService.genDagData(processDefinition);
            taskNodeMap.put(processDefinition.getCode(), dagData.getTaskDefinitionList());
        }
        result.put("data", taskNodeMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryAllProcessDefinitionByProjectCode(User loginUser, long projectCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List processDefinitions = this.processDefinitionMapper.queryAllDefinitionList(projectCode);
        List dagDataList = processDefinitions.stream().map(arg_0 -> ((ProcessService)this.processService).genDagData(arg_0)).collect(Collectors.toList());
        result.put("data", dagDataList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> viewTree(long code, Integer limit) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(code);
        if (null == processDefinition) {
            logger.info("process define not exists");
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, code);
            return result;
        }
        DAG dag = this.processService.genDagGraph(processDefinition);
        ConcurrentHashMap<String, ArrayList<Object>> runningNodeMap = new ConcurrentHashMap<String, ArrayList<Object>>();
        ConcurrentHashMap<String, ArrayList<TreeViewDto>> waitingRunningNodeMap = new ConcurrentHashMap<String, ArrayList<TreeViewDto>>();
        List<ProcessInstance> processInstanceList = this.processInstanceService.queryByProcessDefineCode(code, limit);
        processInstanceList.forEach(processInstance -> processInstance.setDuration(DateUtils.format2Duration((Date)processInstance.getStartTime(), (Date)processInstance.getEndTime())));
        List taskDefinitionList = this.processService.genTaskDefineList(this.processTaskRelationMapper.queryByProcessCode(processDefinition.getProjectCode(), processDefinition.getCode()));
        Map<Long, TaskDefinitionLog> taskDefinitionMap = taskDefinitionList.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        if (limit > processInstanceList.size()) {
            limit = processInstanceList.size();
        }
        TreeViewDto parentTreeViewDto = new TreeViewDto();
        parentTreeViewDto.setName("DAG");
        parentTreeViewDto.setType("");
        parentTreeViewDto.setCode(0L);
        for (int i = limit - 1; i >= 0; --i) {
            ProcessInstance processInstance2 = processInstanceList.get(i);
            Date endTime = processInstance2.getEndTime() == null ? new Date() : processInstance2.getEndTime();
            parentTreeViewDto.getInstances().add(new Instance(processInstance2.getId(), processInstance2.getName(), processInstance2.getProcessDefinitionCode(), "", processInstance2.getState().toString(), processInstance2.getStartTime(), endTime, processInstance2.getHost(), DateUtils.format2Readable((long)(endTime.getTime() - processInstance2.getStartTime().getTime()))));
        }
        List parentTreeViewDtoList = new ArrayList<TreeViewDto>();
        parentTreeViewDtoList.add(parentTreeViewDto);
        for (String startNode : dag.getBeginNode()) {
            runningNodeMap.put(startNode, (ArrayList<Object>)parentTreeViewDtoList);
        }
        while (Stopper.isRunning()) {
            for (Map.Entry en : runningNodeMap.entrySet()) {
                String nodeCode = (String)en.getKey();
                parentTreeViewDtoList = (List)en.getValue();
                TreeViewDto treeViewDto = new TreeViewDto();
                TaskNode taskNode = (TaskNode)dag.getNode((Object)nodeCode);
                treeViewDto.setType(taskNode.getType());
                treeViewDto.setCode(taskNode.getCode());
                treeViewDto.setName(taskNode.getName());
                for (int i = limit - 1; i >= 0; --i) {
                    ProcessInstance processInstance3 = processInstanceList.get(i);
                    TaskInstance taskInstance = this.taskInstanceMapper.queryByInstanceIdAndCode(processInstance3.getId(), Long.valueOf(Long.parseLong(nodeCode)));
                    if (taskInstance == null) {
                        treeViewDto.getInstances().add(new Instance(-1, "not running", 0L, "null"));
                        continue;
                    }
                    Date startTime = taskInstance.getStartTime() == null ? new Date() : taskInstance.getStartTime();
                    Date endTime = taskInstance.getEndTime() == null ? new Date() : taskInstance.getEndTime();
                    long subProcessCode = 0L;
                    if (taskInstance.isSubProcess()) {
                        TaskDefinition taskDefinition = (TaskDefinition)taskDefinitionMap.get(taskInstance.getTaskCode());
                        subProcessCode = Integer.parseInt(JSONUtils.parseObject((String)taskDefinition.getTaskParams()).path("processDefinitionCode").asText());
                    }
                    treeViewDto.getInstances().add(new Instance(taskInstance.getId(), taskInstance.getName(), taskInstance.getTaskCode(), taskInstance.getTaskType(), taskInstance.getState().toString(), taskInstance.getStartTime(), taskInstance.getEndTime(), taskInstance.getHost(), DateUtils.format2Readable((long)(endTime.getTime() - startTime.getTime())), subProcessCode));
                }
                for (TreeViewDto pTreeViewDto : parentTreeViewDtoList) {
                    pTreeViewDto.getChildren().add(treeViewDto);
                }
                Set postNodeList = dag.getSubsequentNodes((Object)nodeCode);
                if (CollectionUtils.isNotEmpty((Collection)postNodeList)) {
                    for (String nextNodeCode : postNodeList) {
                        ArrayList<TreeViewDto> treeViewDtoList = (ArrayList<TreeViewDto>)waitingRunningNodeMap.get(nextNodeCode);
                        if (CollectionUtils.isEmpty((Collection)treeViewDtoList)) {
                            treeViewDtoList = new ArrayList<TreeViewDto>();
                        }
                        treeViewDtoList.add(treeViewDto);
                        waitingRunningNodeMap.put(nextNodeCode, treeViewDtoList);
                    }
                }
                runningNodeMap.remove(nodeCode);
            }
            if (waitingRunningNodeMap.size() == 0) break;
            runningNodeMap.putAll(waitingRunningNodeMap);
            waitingRunningNodeMap.clear();
        }
        result.put("data", parentTreeViewDto);
        result.put("status", (Object)Status.SUCCESS);
        result.put("msg", Status.SUCCESS.getMsg());
        return result;
    }

    private boolean graphHasCycle(List<TaskNode> taskNodeResponseList) {
        DAG graph = new DAG();
        for (TaskNode taskNodeResponse : taskNodeResponseList) {
            graph.addNode((Object)Long.toString(taskNodeResponse.getCode()), (Object)taskNodeResponse);
        }
        for (TaskNode taskNodeResponse : taskNodeResponseList) {
            List preTasks = JSONUtils.toList((String)taskNodeResponse.getPreTasks(), String.class);
            if (!CollectionUtils.isNotEmpty((Collection)preTasks)) continue;
            for (String preTask : preTasks) {
                if (graph.addEdge((Object)preTask, (Object)Long.toString(taskNodeResponse.getCode()))) continue;
                return true;
            }
        }
        return graph.hasCycle();
    }

    @Override
    public Map<String, Object> batchCopyProcessDefinition(User loginUser, long projectCode, String codes, long targetProjectCode) {
        Map<String, Object> result = this.checkParams(loginUser, projectCode, codes, targetProjectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ArrayList<String> failedProcessList = new ArrayList<String>();
        this.doBatchOperateProcessDefinition(loginUser, targetProjectCode, failedProcessList, codes, result, true);
        this.checkBatchOperateResult(projectCode, targetProjectCode, result, failedProcessList, true);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> batchMoveProcessDefinition(User loginUser, long projectCode, String codes, long targetProjectCode) {
        Map<String, Object> result = this.checkParams(loginUser, projectCode, codes, targetProjectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (projectCode == targetProjectCode) {
            return result;
        }
        ArrayList<String> failedProcessList = new ArrayList<String>();
        this.doBatchOperateProcessDefinition(loginUser, targetProjectCode, failedProcessList, codes, result, false);
        this.checkBatchOperateResult(projectCode, targetProjectCode, result, failedProcessList, false);
        return result;
    }

    private Map<String, Object> checkParams(User loginUser, long projectCode, String processDefinitionCodes, long targetProjectCode) {
        Project targetProject;
        Map<String, Object> targetResult;
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (StringUtils.isEmpty((String)processDefinitionCodes)) {
            this.putMsg(result, Status.PROCESS_DEFINITION_CODES_IS_EMPTY, processDefinitionCodes);
            return result;
        }
        if (projectCode != targetProjectCode && (targetResult = this.projectService.checkProjectAndAuth(loginUser, targetProject = this.projectMapper.queryByCode(targetProjectCode), targetProjectCode)).get("status") != Status.SUCCESS) {
            return targetResult;
        }
        return result;
    }

    private void doBatchOperateProcessDefinition(User loginUser, long targetProjectCode, List<String> failedProcessList, String processDefinitionCodes, Map<String, Object> result, boolean isCopy) {
        Set definitionCodes = Arrays.stream(processDefinitionCodes.split(",")).map(Long::parseLong).collect(Collectors.toSet());
        List processDefinitionList = this.processDefinitionMapper.queryByCodes(definitionCodes);
        Set queryCodes = processDefinitionList.stream().map(ProcessDefinition::getCode).collect(Collectors.toSet());
        Set<Long> diffCode = definitionCodes.stream().filter(code -> !queryCodes.contains(code)).collect(Collectors.toSet());
        diffCode.forEach(code -> failedProcessList.add(code + "[null]"));
        for (ProcessDefinition processDefinition : processDefinitionList) {
            List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(processDefinition.getProjectCode(), processDefinition.getCode());
            List<ProcessTaskRelationLog> taskRelationList = processTaskRelations.stream().map(ProcessTaskRelationLog::new).collect(Collectors.toList());
            processDefinition.setProjectCode(targetProjectCode);
            if (isCopy) {
                try {
                    processDefinition.setCode(CodeGenerateUtils.getInstance().genCode());
                }
                catch (CodeGenerateUtils.CodeGenerateException e) {
                    this.putMsg(result, Status.INTERNAL_SERVER_ERROR_ARGS, new Object[0]);
                    throw new ServiceException(Status.INTERNAL_SERVER_ERROR_ARGS);
                }
                processDefinition.setId(0);
                processDefinition.setUserId(loginUser.getId());
                processDefinition.setName(processDefinition.getName() + "_copy_" + DateUtils.getCurrentTimeStamp());
                try {
                    result.putAll(this.createDagDefine(loginUser, taskRelationList, processDefinition, Lists.newArrayList()));
                }
                catch (Exception e) {
                    this.putMsg(result, Status.COPY_PROCESS_DEFINITION_ERROR, new Object[0]);
                    throw new ServiceException(Status.COPY_PROCESS_DEFINITION_ERROR);
                }
            }
            try {
                result.putAll(this.updateDagDefine(loginUser, taskRelationList, processDefinition, null, Lists.newArrayList()));
            }
            catch (Exception e) {
                this.putMsg(result, Status.MOVE_PROCESS_DEFINITION_ERROR, new Object[0]);
                throw new ServiceException(Status.MOVE_PROCESS_DEFINITION_ERROR);
            }
            if (result.get("status") == Status.SUCCESS) continue;
            failedProcessList.add(processDefinition.getCode() + "[" + processDefinition.getName() + "]");
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> switchProcessDefinitionVersion(User loginUser, long projectCode, long code, int version) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(code);
        if (Objects.isNull(processDefinition)) {
            this.putMsg(result, Status.SWITCH_PROCESS_DEFINITION_VERSION_NOT_EXIST_PROCESS_DEFINITION_ERROR, code);
            return result;
        }
        ProcessDefinitionLog processDefinitionLog = this.processDefinitionLogMapper.queryByDefinitionCodeAndVersion(code, version);
        if (Objects.isNull(processDefinitionLog)) {
            this.putMsg(result, Status.SWITCH_PROCESS_DEFINITION_VERSION_NOT_EXIST_PROCESS_DEFINITION_VERSION_ERROR, processDefinition.getCode(), version);
            return result;
        }
        int switchVersion = this.processService.switchVersion(processDefinition, processDefinitionLog);
        if (switchVersion <= 0) {
            this.putMsg(result, Status.SWITCH_PROCESS_DEFINITION_VERSION_ERROR, new Object[0]);
            throw new ServiceException(Status.SWITCH_PROCESS_DEFINITION_VERSION_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void checkBatchOperateResult(long srcProjectCode, long targetProjectCode, Map<String, Object> result, List<String> failedProcessList, boolean isCopy) {
        if (!failedProcessList.isEmpty()) {
            if (isCopy) {
                this.putMsg(result, Status.COPY_PROCESS_DEFINITION_ERROR, srcProjectCode, targetProjectCode, String.join((CharSequence)",", failedProcessList));
            } else {
                this.putMsg(result, Status.MOVE_PROCESS_DEFINITION_ERROR, srcProjectCode, targetProjectCode, String.join((CharSequence)",", failedProcessList));
            }
        } else {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
    }

    @Override
    public Result queryProcessDefinitionVersions(User loginUser, long projectCode, int pageNo, int pageSize, long code) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            this.putMsg(result, resultStatus, new Object[0]);
            return result;
        }
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage processDefinitionVersionsPaging = this.processDefinitionLogMapper.queryProcessDefinitionVersionsPaging(page, code);
        List processDefinitionLogs = processDefinitionVersionsPaging.getRecords();
        pageInfo.setTotalList(processDefinitionLogs);
        pageInfo.setTotal((int)processDefinitionVersionsPaging.getTotal());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> deleteProcessDefinitionVersion(User loginUser, long projectCode, long code, int version) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(code);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, code);
        } else {
            int deleteLog = this.processDefinitionLogMapper.deleteByProcessDefinitionCodeAndVersion(code, version);
            int deleteRelationLog = this.processTaskRelationLogMapper.deleteByCode(processDefinition.getCode(), processDefinition.getVersion());
            if (deleteLog == 0 || deleteRelationLog == 0) {
                this.putMsg(result, Status.DELETE_PROCESS_DEFINE_BY_CODE_ERROR, new Object[0]);
                throw new ServiceException(Status.DELETE_PROCESS_DEFINE_BY_CODE_ERROR);
            }
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }
}

