/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.UiPluginService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.common.enums.PluginType;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.dao.mapper.PluginDefineMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UiPluginServiceImpl
extends BaseServiceImpl
implements UiPluginService {
    @Autowired
    PluginDefineMapper pluginDefineMapper;

    @Override
    public Map<String, Object> queryUiPluginsByType(PluginType pluginType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!pluginType.getHasUi()) {
            this.putMsg(result, Status.PLUGIN_NOT_A_UI_COMPONENT, new Object[0]);
            return result;
        }
        List pluginDefines = this.pluginDefineMapper.queryByPluginType(pluginType.getDesc());
        if (CollectionUtils.isEmpty((Collection)pluginDefines)) {
            this.putMsg(result, Status.QUERY_PLUGINS_RESULT_IS_NULL, new Object[0]);
            return result;
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", pluginDefines);
        return result;
    }

    @Override
    public Map<String, Object> queryUiPluginDetailById(int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PluginDefine pluginDefine = this.pluginDefineMapper.queryDetailById(id);
        if (null == pluginDefine) {
            this.putMsg(result, Status.QUERY_PLUGIN_DETAIL_RESULT_IS_NULL, new Object[0]);
            return result;
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", pluginDefine);
        return result;
    }
}

