/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.utils;

import java.util.List;

public class PageInfo<T> {
    private List<T> totalList;
    private Integer total = 0;
    private Integer totalPage;
    private Integer pageSize = 20;
    private Integer currentPage = 0;
    private Integer pageNo;

    public PageInfo(Integer currentPage, Integer pageSize) {
        if (currentPage == null) {
            currentPage = 1;
        }
        this.pageNo = (currentPage - 1) * pageSize;
        this.pageSize = pageSize;
        this.currentPage = currentPage;
    }

    public Integer getStart() {
        return this.pageNo;
    }

    public void setStart(Integer start) {
        this.pageNo = start;
    }

    public List<T> getTotalList() {
        return this.totalList;
    }

    public void setTotalList(List<T> totalList) {
        this.totalList = totalList;
    }

    public Integer getTotal() {
        if (this.total == null) {
            this.total = 0;
        }
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getTotalPage() {
        if (this.pageSize == null || this.pageSize == 0) {
            this.pageSize = 7;
        }
        this.totalPage = this.total % this.pageSize == 0 ? (this.total / this.pageSize == 0 ? 1 : this.total / this.pageSize) : this.total / this.pageSize + 1;
        return this.totalPage;
    }

    public void setTotalPage(Integer totalPage) {
        this.totalPage = totalPage;
    }

    public Integer getPageSize() {
        if (this.pageSize == null || this.pageSize == 0) {
            this.pageSize = 7;
        }
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getCurrentPage() {
        if (this.currentPage == null || this.currentPage <= 0) {
            this.currentPage = 1;
        }
        return this.currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }
}

