/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.api.dto.TaskStateCount;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.ExecuteStatusCount;

public class TaskCountDto {
    private int totalCount;
    private List<TaskStateCount> taskCountDtos;

    public TaskCountDto(List<ExecuteStatusCount> taskInstanceStateCounts) {
        this.countTaskDtos(taskInstanceStateCounts);
    }

    private void countTaskDtos(List<ExecuteStatusCount> taskInstanceStateCounts) {
        Map<ExecutionStatus, Integer> statusCountMap = taskInstanceStateCounts.stream().collect(Collectors.toMap(ExecuteStatusCount::getExecutionStatus, ExecuteStatusCount::getCount, Integer::sum));
        this.taskCountDtos = Arrays.stream(ExecutionStatus.values()).map(status -> new TaskStateCount((ExecutionStatus)status, statusCountMap.getOrDefault(status, 0))).collect(Collectors.toList());
        this.totalCount = this.taskCountDtos.stream().mapToInt(TaskStateCount::getCount).sum();
    }

    public void removeStateFromCountList(ExecutionStatus status) {
        for (TaskStateCount count : this.taskCountDtos) {
            if (!count.getTaskStateType().equals((Object)status)) continue;
            this.taskCountDtos.remove(count);
            break;
        }
    }

    public List<TaskStateCount> getTaskCountDtos() {
        return this.taskCountDtos;
    }

    public void setTaskCountDtos(List<TaskStateCount> taskCountDtos) {
        this.taskCountDtos = taskCountDtos;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }
}

