/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.AlertGroupService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.AlertGroup;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.AlertGroupMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AlertGroupServiceImpl
extends BaseServiceImpl
implements AlertGroupService {
    private Logger logger = LoggerFactory.getLogger(AlertGroupServiceImpl.class);
    @Autowired
    private AlertGroupMapper alertGroupMapper;

    @Override
    public Map<String, Object> queryAlertgroup() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List alertGroups = this.alertGroupMapper.queryAllGroupList();
        result.put("data", alertGroups);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryAlertGroupById(User loginUser, Integer id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        AlertGroup alertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)id);
        if (alertGroup == null) {
            this.putMsg(result, Status.ALERT_GROUP_NOT_EXIST, new Object[0]);
            return result;
        }
        result.put("data", alertGroup);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result listPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage alertGroupIPage = this.alertGroupMapper.queryAlertGroupPage(page, searchVal);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal((int)alertGroupIPage.getTotal());
        pageInfo.setTotalList(alertGroupIPage.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> createAlertgroup(User loginUser, String groupName, String desc, String alertInstanceIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        AlertGroup alertGroup = new AlertGroup();
        Date now = new Date();
        alertGroup.setGroupName(groupName);
        alertGroup.setAlertInstanceIds(alertInstanceIds);
        alertGroup.setDescription(desc);
        alertGroup.setCreateTime(now);
        alertGroup.setUpdateTime(now);
        alertGroup.setCreateUserId(loginUser.getId());
        try {
            int insert = this.alertGroupMapper.insert((Object)alertGroup);
            this.putMsg(result, insert > 0 ? Status.SUCCESS : Status.CREATE_ALERT_GROUP_ERROR, new Object[0]);
        }
        catch (DuplicateKeyException ex) {
            this.logger.error("Create alert group error.", (Throwable)ex);
            this.putMsg(result, Status.ALERT_GROUP_EXIST, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> updateAlertgroup(User loginUser, int id, String groupName, String desc, String alertInstanceIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        AlertGroup alertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (alertGroup == null) {
            this.putMsg(result, Status.ALERT_GROUP_NOT_EXIST, new Object[0]);
            return result;
        }
        Date now = new Date();
        if (!StringUtils.isEmpty((String)groupName)) {
            alertGroup.setGroupName(groupName);
        }
        alertGroup.setDescription(desc);
        alertGroup.setUpdateTime(now);
        alertGroup.setCreateUserId(loginUser.getId());
        alertGroup.setAlertInstanceIds(alertInstanceIds);
        try {
            this.alertGroupMapper.updateById((Object)alertGroup);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        catch (DuplicateKeyException ex) {
            this.logger.error("Update alert group error.", (Throwable)ex);
            this.putMsg(result, Status.ALERT_GROUP_EXIST, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> delAlertgroupById(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.isNotAdmin(loginUser, result)) {
            return result;
        }
        AlertGroup alertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (alertGroup == null) {
            this.putMsg(result, Status.ALERT_GROUP_NOT_EXIST, new Object[0]);
            return result;
        }
        this.alertGroupMapper.deleteById((Serializable)Integer.valueOf(id));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public boolean existGroupName(String groupName) {
        return this.alertGroupMapper.existGroupName(groupName) == Boolean.TRUE;
    }
}

