/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.dto.resources.ResourceComponent;
import org.apache.dolphinscheduler.api.dto.resources.visitor.ResourceTreeVisitor;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.CheckUtils;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.EncryptionUtils;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.dao.entity.AlertGroup;
import org.apache.dolphinscheduler.dao.entity.DatasourceUser;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.dao.entity.ResourcesUser;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.UDFUser;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.AccessTokenMapper;
import org.apache.dolphinscheduler.dao.mapper.AlertGroupMapper;
import org.apache.dolphinscheduler.dao.mapper.DataSourceUserMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectUserMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ResourceUserMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UDFUserMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.dao.utils.ResourceProcessDefinitionUtils;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UsersServiceImpl
extends BaseServiceImpl
implements UsersService {
    private static final Logger logger = LoggerFactory.getLogger(UsersServiceImpl.class);
    @Autowired
    private AccessTokenMapper accessTokenMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private ProjectUserMapper projectUserMapper;
    @Autowired
    private ResourceUserMapper resourceUserMapper;
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private DataSourceUserMapper datasourceUserMapper;
    @Autowired
    private UDFUserMapper udfUserMapper;
    @Autowired
    private AlertGroupMapper alertGroupMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private ProjectMapper projectMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> createUser(User loginUser, String userName, String userPassword, String email, int tenantId, String phone, String queue, int state) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String msg = this.checkUserParams(userName, userPassword, email, phone);
        if (!StringUtils.isEmpty((String)msg)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, msg);
            return result;
        }
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (!this.checkTenantExists(tenantId)) {
            this.putMsg(result, Status.TENANT_NOT_EXIST, new Object[0]);
            return result;
        }
        User user = this.createUser(userName, userPassword, email, tenantId, phone, queue, state);
        Tenant tenant = this.tenantMapper.queryById(tenantId);
        if (PropertyUtils.getResUploadStartupState()) {
            if (!HadoopUtils.getInstance().exists(HadoopUtils.getHdfsTenantDir((String)tenant.getTenantCode()))) {
                this.createTenantDirIfNotExists(tenant.getTenantCode());
            }
            String userPath = HadoopUtils.getHdfsUserDir((String)tenant.getTenantCode(), (int)user.getId());
            HadoopUtils.getInstance().mkdir(userPath);
        }
        result.put("data", user);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public User createUser(String userName, String userPassword, String email, int tenantId, String phone, String queue, int state) {
        User user = new User();
        Date now = new Date();
        user.setUserName(userName);
        user.setUserPassword(EncryptionUtils.getMd5((String)userPassword));
        user.setEmail(email);
        user.setTenantId(tenantId);
        user.setPhone(phone);
        user.setState(state);
        user.setUserType(UserType.GENERAL_USER);
        user.setCreateTime(now);
        user.setUpdateTime(now);
        if (StringUtils.isEmpty((String)queue)) {
            queue = "";
        }
        user.setQueue(queue);
        this.userMapper.insert((Object)user);
        return user;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public User createUser(UserType userType, String userId, String email) {
        User user = new User();
        Date now = new Date();
        user.setUserName(userId);
        user.setEmail(email);
        user.setUserType(userType);
        user.setCreateTime(now);
        user.setUpdateTime(now);
        user.setQueue("");
        this.userMapper.insert((Object)user);
        return user;
    }

    @Override
    public User getUserByUserName(String userName) {
        return this.userMapper.queryByUserNameAccurately(userName);
    }

    @Override
    public User queryUser(int id) {
        return this.userMapper.selectById(id);
    }

    @Override
    public List<User> queryUser(List<Integer> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<User>();
        }
        return this.userMapper.selectByIds(ids);
    }

    @Override
    public User queryUser(String name) {
        return this.userMapper.queryByUserNameAccurately(name);
    }

    @Override
    public User queryUser(String name, String password) {
        String md5 = EncryptionUtils.getMd5((String)password);
        return this.userMapper.queryUserByNamePassword(name, md5);
    }

    @Override
    public int getUserIdByName(String name) {
        int executorId = 0;
        if (StringUtils.isNotEmpty((String)name)) {
            User executor = this.queryUser(name);
            executorId = null != executor ? executor.getId() : -1;
        }
        return executorId;
    }

    @Override
    public Result queryUserList(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage scheduleList = this.userMapper.queryUserPaging(page, searchVal);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal((int)scheduleList.getTotal());
        pageInfo.setTotalList(scheduleList.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> updateUser(User loginUser, int userId, String userName, String userPassword, String email, int tenantId, String phone, String queue, int state) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.check(result, !this.hasPerm(loginUser, userId), Status.USER_NO_OPERATION_PERM)) {
            return result;
        }
        User user = this.userMapper.selectById(userId);
        if (user == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        if (StringUtils.isNotEmpty((String)userName)) {
            if (!CheckUtils.checkUserName(userName)) {
                this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, userName);
                return result;
            }
            User tempUser = this.userMapper.queryByUserNameAccurately(userName);
            if (tempUser != null && tempUser.getId() != userId) {
                this.putMsg(result, Status.USER_NAME_EXIST, new Object[0]);
                return result;
            }
            user.setUserName(userName);
        }
        if (StringUtils.isNotEmpty((String)userPassword)) {
            if (!CheckUtils.checkPassword(userPassword)) {
                this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, userPassword);
                return result;
            }
            user.setUserPassword(EncryptionUtils.getMd5((String)userPassword));
        }
        if (StringUtils.isNotEmpty((String)email)) {
            if (!CheckUtils.checkEmail(email)) {
                this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, email);
                return result;
            }
            user.setEmail(email);
        }
        if (StringUtils.isNotEmpty((String)phone) && !CheckUtils.checkPhone(phone)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, phone);
            return result;
        }
        if (state == 0 && user.getState() != state && loginUser.getId() == user.getId()) {
            this.putMsg(result, Status.NOT_ALLOW_TO_DISABLE_OWN_ACCOUNT, new Object[0]);
            return result;
        }
        user.setPhone(phone);
        user.setQueue(queue);
        user.setState(state);
        Date now = new Date();
        user.setUpdateTime(now);
        if (user.getTenantId() != tenantId) {
            Tenant oldTenant = this.tenantMapper.queryById(user.getTenantId());
            Tenant newTenant = this.tenantMapper.queryById(tenantId);
            if (newTenant != null && PropertyUtils.getResUploadStartupState() && oldTenant != null) {
                String newTenantCode = newTenant.getTenantCode();
                String oldResourcePath = HadoopUtils.getHdfsResDir((String)oldTenant.getTenantCode());
                String oldUdfsPath = HadoopUtils.getHdfsUdfDir((String)oldTenant.getTenantCode());
                if (HadoopUtils.getInstance().exists(oldResourcePath)) {
                    List udfResourceList;
                    String newResourcePath = HadoopUtils.getHdfsResDir((String)newTenantCode);
                    String newUdfsPath = HadoopUtils.getHdfsUdfDir((String)newTenantCode);
                    List fileResourcesList = this.resourceMapper.queryResourceList(null, userId, ResourceType.FILE.ordinal());
                    if (CollectionUtils.isNotEmpty((Collection)fileResourcesList)) {
                        ResourceTreeVisitor resourceTreeVisitor = new ResourceTreeVisitor(fileResourcesList);
                        ResourceComponent resourceComponent = resourceTreeVisitor.visit();
                        this.copyResourceFiles(resourceComponent, oldResourcePath, newResourcePath);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(udfResourceList = this.resourceMapper.queryResourceList(null, userId, ResourceType.UDF.ordinal())))) {
                        ResourceTreeVisitor resourceTreeVisitor = new ResourceTreeVisitor(udfResourceList);
                        ResourceComponent resourceComponent = resourceTreeVisitor.visit();
                        this.copyResourceFiles(resourceComponent, oldUdfsPath, newUdfsPath);
                    }
                    String oldUserPath = HadoopUtils.getHdfsUserDir((String)oldTenant.getTenantCode(), (int)userId);
                    HadoopUtils.getInstance().delete(oldUserPath, true);
                } else {
                    this.createTenantDirIfNotExists(oldTenant.getTenantCode());
                }
                if (HadoopUtils.getInstance().exists(HadoopUtils.getHdfsTenantDir((String)newTenant.getTenantCode()))) {
                    String newUserPath = HadoopUtils.getHdfsUserDir((String)newTenant.getTenantCode(), (int)user.getId());
                    HadoopUtils.getInstance().mkdir(newUserPath);
                } else {
                    this.createTenantDirIfNotExists(newTenant.getTenantCode());
                }
            }
            user.setTenantId(tenantId);
        }
        this.userMapper.updateById(user);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> deleteUserById(User loginUser, int id) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, id);
            return result;
        }
        User tempUser = this.userMapper.selectById(id);
        if (tempUser == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, id);
            return result;
        }
        List projects = this.projectMapper.queryProjectCreatedByUser(id);
        if (CollectionUtils.isNotEmpty((Collection)projects)) {
            String projectNames = projects.stream().map(Project::getName).collect(Collectors.joining(","));
            this.putMsg(result, Status.TRANSFORM_PROJECT_OWNERSHIP, projectNames);
            return result;
        }
        User user = this.userMapper.queryTenantCodeByUserId(id);
        if (user != null && PropertyUtils.getResUploadStartupState()) {
            String userPath = HadoopUtils.getHdfsUserDir((String)user.getTenantCode(), (int)id);
            if (HadoopUtils.getInstance().exists(userPath)) {
                HadoopUtils.getInstance().delete(userPath, true);
            }
        }
        this.accessTokenMapper.deleteAccessTokenByUserId(id);
        this.userMapper.deleteById(id);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> grantProject(User loginUser, int userId, String projectIds) {
        String[] projectIdArr;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            return result;
        }
        User tempUser = this.userMapper.selectById(userId);
        if (tempUser == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        if (this.check(result, StringUtils.isEmpty((String)projectIds), Status.SUCCESS)) {
            this.projectUserMapper.deleteProjectRelation(0, userId);
            return result;
        }
        for (String projectId : projectIdArr = projectIds.split(",")) {
            Date now = new Date();
            ProjectUser projectUser = new ProjectUser();
            projectUser.setUserId(userId);
            projectUser.setProjectId(Integer.parseInt(projectId));
            projectUser.setPerm(7);
            projectUser.setCreateTime(now);
            projectUser.setUpdateTime(now);
            this.projectUserMapper.insert((Object)projectUser);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> grantProjectByCode(User loginUser, int userId, long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        User tempUser = this.userMapper.selectById(userId);
        if (tempUser == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        Project project = this.projectMapper.queryByCode(projectCode);
        if (project == null) {
            this.putMsg(result, Status.PROJECT_NOT_FOUNT, projectCode);
            return result;
        }
        if (!this.hasPerm(loginUser, project.getUserId())) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        Date today = new Date();
        ProjectUser projectUser = new ProjectUser();
        projectUser.setUserId(userId);
        projectUser.setProjectId(project.getId());
        projectUser.setPerm(7);
        projectUser.setCreateTime(today);
        projectUser.setUpdateTime(today);
        this.projectUserMapper.insert((Object)projectUser);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> revokeProject(User loginUser, int userId, long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            return result;
        }
        User user = this.userMapper.selectById(userId);
        if (user == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        Project project = this.projectMapper.queryByCode(projectCode);
        if (project == null) {
            this.putMsg(result, Status.PROJECT_NOT_FOUNT, projectCode);
            return result;
        }
        this.projectUserMapper.deleteProjectRelation(project.getId(), user.getId());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> grantResources(User loginUser, int userId, String resourceIds) {
        List resIds;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            return result;
        }
        User user = this.userMapper.selectById(userId);
        if (user == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        HashSet<Integer> needAuthorizeResIds = new HashSet<Integer>();
        if (StringUtils.isNotBlank((String)resourceIds)) {
            String[] resourceFullIdArr;
            for (String resourceFullId : resourceFullIdArr = resourceIds.split(",")) {
                String[] resourceIdArr = resourceFullId.split("-");
                for (int i = 0; i <= resourceIdArr.length - 1; ++i) {
                    int resourceIdValue = Integer.parseInt(resourceIdArr[i]);
                    needAuthorizeResIds.add(resourceIdValue);
                }
            }
        }
        List oldAuthorizedRes = CollectionUtils.isEmpty((Collection)(resIds = this.resourceUserMapper.queryResourcesIdListByUserIdAndPerm(userId, 7))) ? new ArrayList() : this.resourceMapper.queryResourceListById(resIds);
        Set oldAuthorizedResIds = oldAuthorizedRes.stream().map(Resource::getId).collect(Collectors.toSet());
        oldAuthorizedResIds.removeAll(needAuthorizeResIds);
        if (CollectionUtils.isNotEmpty(oldAuthorizedResIds)) {
            List list = this.processDefinitionMapper.listResourcesByUser(Integer.valueOf(userId));
            Map resourceProcessMap = ResourceProcessDefinitionUtils.getResourceProcessDefinitionMap((List)list);
            Set resourceIdSet = resourceProcessMap.keySet();
            resourceIdSet.retainAll(oldAuthorizedResIds);
            if (CollectionUtils.isNotEmpty(resourceIdSet)) {
                logger.error("can't be deleted,because it is used of process definition");
                for (Integer resId : resourceIdSet) {
                    logger.error("resource id:{} is used of process definition {}", (Object)resId, resourceProcessMap.get(resId));
                }
                this.putMsg(result, Status.RESOURCE_IS_USED, new Object[0]);
                return result;
            }
        }
        this.resourceUserMapper.deleteResourceUser(userId, 0);
        if (this.check(result, StringUtils.isEmpty((String)resourceIds), Status.SUCCESS)) {
            return result;
        }
        Iterator iterator = needAuthorizeResIds.iterator();
        while (iterator.hasNext()) {
            int resourceIdValue = (Integer)iterator.next();
            Resource resource = (Resource)this.resourceMapper.selectById((Serializable)Integer.valueOf(resourceIdValue));
            if (resource == null) {
                this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
                return result;
            }
            Date now = new Date();
            ResourcesUser resourcesUser = new ResourcesUser();
            resourcesUser.setUserId(userId);
            resourcesUser.setResourcesId(resourceIdValue);
            if (resource.isDirectory()) {
                resourcesUser.setPerm(4);
            } else {
                resourcesUser.setPerm(7);
            }
            resourcesUser.setCreateTime(now);
            resourcesUser.setUpdateTime(now);
            this.resourceUserMapper.insert((Object)resourcesUser);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> grantUDFFunction(User loginUser, int userId, String udfIds) {
        String[] resourcesIdArr;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            return result;
        }
        User user = this.userMapper.selectById(userId);
        if (user == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        this.udfUserMapper.deleteByUserId(userId);
        if (this.check(result, StringUtils.isEmpty((String)udfIds), Status.SUCCESS)) {
            return result;
        }
        for (String udfId : resourcesIdArr = udfIds.split(",")) {
            Date now = new Date();
            UDFUser udfUser = new UDFUser();
            udfUser.setUserId(userId);
            udfUser.setUdfId(Integer.parseInt(udfId));
            udfUser.setPerm(7);
            udfUser.setCreateTime(now);
            udfUser.setUpdateTime(now);
            this.udfUserMapper.insert((Object)udfUser);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> grantDataSource(User loginUser, int userId, String datasourceIds) {
        String[] datasourceIdArr;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            return result;
        }
        User user = this.userMapper.selectById(userId);
        if (user == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        this.datasourceUserMapper.deleteByUserId(userId);
        if (this.check(result, StringUtils.isEmpty((String)datasourceIds), Status.SUCCESS)) {
            return result;
        }
        for (String datasourceId : datasourceIdArr = datasourceIds.split(",")) {
            Date now = new Date();
            DatasourceUser datasourceUser = new DatasourceUser();
            datasourceUser.setUserId(userId);
            datasourceUser.setDatasourceId(Integer.parseInt(datasourceId));
            datasourceUser.setPerm(7);
            datasourceUser.setCreateTime(now);
            datasourceUser.setUpdateTime(now);
            this.datasourceUserMapper.insert((Object)datasourceUser);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> getUserInfo(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        User user = null;
        if (loginUser.getUserType() == UserType.ADMIN_USER) {
            user = loginUser;
        } else {
            user = this.userMapper.queryDetailsById(loginUser.getId());
            List alertGroups = this.alertGroupMapper.queryByUserId(loginUser.getId());
            StringBuilder sb = new StringBuilder();
            if (alertGroups != null && !alertGroups.isEmpty()) {
                for (int i = 0; i < alertGroups.size() - 1; ++i) {
                    sb.append(((AlertGroup)alertGroups.get(i)).getGroupName() + ",");
                }
                sb.append(alertGroups.get(alertGroups.size() - 1));
                user.setAlertGroup(sb.toString());
            }
        }
        result.put("data", user);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryAllGeneralUsers(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            return result;
        }
        List userList = this.userMapper.queryAllGeneralUser();
        result.put("data", userList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryUserList(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            return result;
        }
        List userList = this.userMapper.selectList(null);
        result.put("data", userList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyUserName(String userName) {
        Result<Object> result = new Result<Object>();
        User user = this.userMapper.queryByUserNameAccurately(userName);
        if (user != null) {
            this.putMsg((Result)result, Status.USER_NAME_EXIST, new Object[0]);
        } else {
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> unauthorizedUser(User loginUser, Integer alertgroupId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            return result;
        }
        List userList = this.userMapper.selectList(null);
        ArrayList resultUsers = new ArrayList();
        HashSet userSet = null;
        if (userList != null && !userList.isEmpty()) {
            userSet = new HashSet(userList);
            List authedUserList = this.userMapper.queryUserListByAlertGroupId(alertgroupId.intValue());
            HashSet authedUserSet = null;
            if (authedUserList != null && !authedUserList.isEmpty()) {
                authedUserSet = new HashSet(authedUserList);
                userSet.removeAll(authedUserSet);
            }
            resultUsers = new ArrayList(userSet);
        }
        result.put("data", resultUsers);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> authorizedUser(User loginUser, Integer alertgroupId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            return result;
        }
        List userList = this.userMapper.queryUserListByAlertGroupId(alertgroupId.intValue());
        result.put("data", userList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkTenantExists(int tenantId) {
        return this.tenantMapper.queryById(tenantId) != null;
    }

    private String checkUserParams(String userName, String password, String email, String phone) {
        String msg = null;
        if (!CheckUtils.checkUserName(userName)) {
            msg = userName;
        } else if (!CheckUtils.checkPassword(password)) {
            msg = password;
        } else if (!CheckUtils.checkEmail(email)) {
            msg = email;
        } else if (!CheckUtils.checkPhone(phone)) {
            msg = phone;
        }
        return msg;
    }

    private void copyResourceFiles(ResourceComponent resourceComponent, String srcBasePath, String dstBasePath) throws IOException {
        List<ResourceComponent> components = resourceComponent.getChildren();
        if (CollectionUtils.isNotEmpty(components)) {
            for (ResourceComponent component : components) {
                if (!HadoopUtils.getInstance().exists(String.format("%s/%s", srcBasePath, component.getFullName()))) {
                    logger.error("resource file: {} not exist,copy error", (Object)component.getFullName());
                    throw new ServiceException(Status.RESOURCE_NOT_EXIST);
                }
                if (!component.isDirctory()) {
                    HadoopUtils.getInstance().copy(String.format("%s/%s", srcBasePath, component.getFullName()), String.format("%s/%s", dstBasePath, component.getFullName()), false, true);
                    continue;
                }
                if (CollectionUtils.isEmpty(component.getChildren())) {
                    if (HadoopUtils.getInstance().exists(String.format("%s/%s", dstBasePath, component.getFullName()))) continue;
                    HadoopUtils.getInstance().mkdir(String.format("%s/%s", dstBasePath, component.getFullName()));
                    continue;
                }
                this.copyResourceFiles(component, srcBasePath, dstBasePath);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> registerUser(String userName, String userPassword, String repeatPassword, String email) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String msg = this.checkUserParams(userName, userPassword, email, "");
        if (!StringUtils.isEmpty((String)msg)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, msg);
            return result;
        }
        if (!userPassword.equals(repeatPassword)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "two passwords are not same");
            return result;
        }
        User user = this.createUser(userName, userPassword, email, 1, "", "", Flag.NO.ordinal());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", user);
        return result;
    }

    @Override
    public Map<String, Object> activateUser(User loginUser, String userName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (!CheckUtils.checkUserName(userName)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, userName);
            return result;
        }
        User user = this.userMapper.queryByUserNameAccurately(userName);
        if (user == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, userName);
            return result;
        }
        if (user.getState() != Flag.NO.ordinal()) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, userName);
            return result;
        }
        user.setState(Flag.YES.ordinal());
        Date now = new Date();
        user.setUpdateTime(now);
        this.userMapper.updateById(user);
        User responseUser = this.userMapper.queryByUserNameAccurately(userName);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", responseUser);
        return result;
    }

    @Override
    public Map<String, Object> batchActivateUser(User loginUser, List<String> userNames) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        int totalSuccess = 0;
        ArrayList<String> successUserNames = new ArrayList<String>();
        HashMap<String, Serializable> successRes = new HashMap<String, Serializable>();
        int totalFailed = 0;
        ArrayList failedInfo = new ArrayList();
        HashMap<String, Serializable> failedRes = new HashMap<String, Serializable>();
        for (String userName : userNames) {
            Map<String, Object> tmpResult = this.activateUser(loginUser, userName);
            if (tmpResult.get("status") != Status.SUCCESS) {
                ++totalFailed;
                HashMap<String, String> failedBody = new HashMap<String, String>();
                failedBody.put("userName", userName);
                Status status = (Status)((Object)tmpResult.get("status"));
                String errorMessage = MessageFormat.format(status.getMsg(), userName);
                failedBody.put("msg", errorMessage);
                failedInfo.add(failedBody);
                continue;
            }
            ++totalSuccess;
            successUserNames.add(userName);
        }
        successRes.put("sum", Integer.valueOf(totalSuccess));
        successRes.put("userName", successUserNames);
        failedRes.put("sum", Integer.valueOf(totalFailed));
        failedRes.put("info", failedInfo);
        HashMap<String, HashMap<String, Serializable>> res = new HashMap<String, HashMap<String, Serializable>>();
        res.put("success", successRes);
        res.put("failed", failedRes);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", res);
        return result;
    }
}

