/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ProcessTaskRelationService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.common.enums.ConditionType;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessTaskRelationServiceImpl
extends BaseServiceImpl
implements ProcessTaskRelationService {
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ProcessTaskRelationMapper processTaskRelationMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private ProcessService processService;

    @Override
    @Transactional
    public Map<String, Object> createProcessTaskRelation(User loginUser, long projectCode, long processDefinitionCode, long preTaskCode, long postTaskCode) {
        Map<Long, ProcessTaskRelation> preTaskCodeMap;
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(processDefinitionCode));
            return result;
        }
        if (processDefinition.getProjectCode() != projectCode) {
            this.putMsg(result, Status.PROJECT_PROCESS_NOT_MATCH, new Object[0]);
            return result;
        }
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        List processTaskRelationList = this.processTaskRelationMapper.queryByProcessCode(projectCode, processDefinitionCode);
        ArrayList processTaskRelations = Lists.newArrayList((Iterable)processTaskRelationList);
        if (!processTaskRelations.isEmpty() && !(preTaskCodeMap = processTaskRelations.stream().filter(r -> r.getPostTaskCode() == postTaskCode).collect(Collectors.toMap(ProcessTaskRelation::getPreTaskCode, processTaskRelation -> processTaskRelation))).isEmpty()) {
            if (preTaskCodeMap.containsKey(preTaskCode) || !preTaskCodeMap.containsKey(0L) && preTaskCode == 0L) {
                this.putMsg(result, Status.PROCESS_TASK_RELATION_EXIST, String.valueOf(processDefinitionCode));
                return result;
            }
            if (preTaskCodeMap.containsKey(0L) && preTaskCode != 0L) {
                processTaskRelations.remove(preTaskCodeMap.get(0L));
            }
        }
        TaskDefinition postTaskDefinition = this.taskDefinitionMapper.queryByCode(postTaskCode);
        ProcessTaskRelation processTaskRelation2 = this.setRelation(processDefinition, postTaskDefinition);
        if (preTaskCode != 0L) {
            TaskDefinition preTaskDefinition = this.taskDefinitionMapper.queryByCode(preTaskCode);
            List upstreamTaskRelationList = processTaskRelations.stream().filter(r -> r.getPostTaskCode() == preTaskCode).collect(Collectors.toList());
            if (upstreamTaskRelationList.isEmpty()) {
                ProcessTaskRelation preProcessTaskRelation = this.setRelation(processDefinition, preTaskDefinition);
                preProcessTaskRelation.setPreTaskCode(0L);
                preProcessTaskRelation.setPreTaskVersion(0);
                processTaskRelations.add(preProcessTaskRelation);
            }
            processTaskRelation2.setPreTaskCode(preTaskDefinition.getCode());
            processTaskRelation2.setPreTaskVersion(preTaskDefinition.getVersion());
        } else {
            processTaskRelation2.setPreTaskCode(0L);
            processTaskRelation2.setPreTaskVersion(0);
        }
        processTaskRelations.add(processTaskRelation2);
        this.updateRelation(loginUser, result, processDefinition, processTaskRelations);
        return result;
    }

    private ProcessTaskRelation setRelation(ProcessDefinition processDefinition, TaskDefinition taskDefinition) {
        Date now = new Date();
        ProcessTaskRelation processTaskRelation = new ProcessTaskRelation();
        processTaskRelation.setProjectCode(processDefinition.getProjectCode());
        processTaskRelation.setProcessDefinitionCode(processDefinition.getCode());
        processTaskRelation.setProcessDefinitionVersion(processDefinition.getVersion());
        processTaskRelation.setPostTaskCode(taskDefinition.getCode());
        processTaskRelation.setPostTaskVersion(taskDefinition.getVersion());
        processTaskRelation.setConditionType(ConditionType.NONE);
        processTaskRelation.setConditionParams("{}");
        processTaskRelation.setCreateTime(now);
        processTaskRelation.setUpdateTime(now);
        return processTaskRelation;
    }

    private void updateProcessDefiniteVersion(User loginUser, Map<String, Object> result, ProcessDefinition processDefinition) {
        int insertVersion = this.processService.saveProcessDefine(loginUser, processDefinition, Boolean.TRUE, Boolean.TRUE);
        if (insertVersion <= 0) {
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        processDefinition.setVersion(insertVersion);
    }

    @Override
    @Transactional
    public Map<String, Object> deleteTaskProcessRelation(User loginUser, long projectCode, long processDefinitionCode, long taskCode) {
        int deleteTaskDefinition;
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (taskCode == 0L) {
            this.putMsg(result, Status.DELETE_TASK_PROCESS_RELATION_ERROR, new Object[0]);
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(processDefinitionCode));
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (null == taskDefinition) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
            return result;
        }
        List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(projectCode, processDefinitionCode);
        ArrayList processTaskRelationList = Lists.newArrayList((Iterable)processTaskRelations);
        if (CollectionUtils.isEmpty((Collection)processTaskRelationList)) {
            this.putMsg(result, Status.DATA_IS_NULL, "processTaskRelationList");
            return result;
        }
        ArrayList downstreamList = Lists.newArrayList();
        for (ProcessTaskRelation processTaskRelation : processTaskRelations) {
            if (processTaskRelation.getPreTaskCode() == taskCode) {
                downstreamList.add(processTaskRelation.getPostTaskCode());
            }
            if (processTaskRelation.getPostTaskCode() != taskCode) continue;
            processTaskRelationList.remove(processTaskRelation);
        }
        if (CollectionUtils.isNotEmpty((Collection)downstreamList)) {
            this.putMsg(result, Status.TASK_HAS_DOWNSTREAM, org.apache.commons.lang.StringUtils.join((Collection)downstreamList, (String)","));
            return result;
        }
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        this.updateRelation(loginUser, result, processDefinition, processTaskRelationList);
        if (("CONDITIONS".equals(taskDefinition.getTaskType()) || "DEPENDENT".equals(taskDefinition.getTaskType()) || "SUB_PROCESS".equals(taskDefinition.getTaskType())) && 0 == (deleteTaskDefinition = this.taskDefinitionMapper.deleteByCode(taskCode))) {
            this.putMsg(result, Status.DELETE_TASK_DEFINE_BY_CODE_ERROR, new Object[0]);
            throw new ServiceException(Status.DELETE_TASK_DEFINE_BY_CODE_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void updateRelation(User loginUser, Map<String, Object> result, ProcessDefinition processDefinition, List<ProcessTaskRelation> processTaskRelationList) {
        List relationLogs = processTaskRelationList.stream().map(ProcessTaskRelationLog::new).collect(Collectors.toList());
        int insertResult = this.processService.saveTaskRelation(loginUser, processDefinition.getProjectCode(), processDefinition.getCode(), processDefinition.getVersion(), relationLogs, (List)Lists.newArrayList(), Boolean.TRUE);
        if (insertResult != 0) {
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", processDefinition);
    }

    @Override
    @Transactional
    public Map<String, Object> deleteUpstreamRelation(User loginUser, long projectCode, String preTaskCodes, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)preTaskCodes)) {
            this.putMsg(result, Status.DATA_IS_NULL, "preTaskCodes");
            return result;
        }
        List upstreamList = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        if (CollectionUtils.isEmpty((Collection)upstreamList)) {
            this.putMsg(result, Status.DATA_IS_NULL, "taskCode");
            return result;
        }
        List preTaskCodeList = Lists.newArrayList((Object[])preTaskCodes.split(",")).stream().map(Long::parseLong).collect(Collectors.toList());
        if (preTaskCodeList.contains(0L)) {
            this.putMsg(result, Status.DATA_IS_NULL, "preTaskCodes");
            return result;
        }
        List currentUpstreamList = upstreamList.stream().map(ProcessTaskRelation::getPreTaskCode).collect(Collectors.toList());
        if (currentUpstreamList.contains(0L)) {
            this.putMsg(result, Status.DATA_IS_NOT_VALID, "currentUpstreamList");
            return result;
        }
        ArrayList tmpCurrent = Lists.newArrayList(currentUpstreamList);
        tmpCurrent.removeAll(preTaskCodeList);
        preTaskCodeList.removeAll(currentUpstreamList);
        if (!preTaskCodeList.isEmpty()) {
            this.putMsg(result, Status.DATA_IS_NOT_VALID, StringUtils.join(preTaskCodeList, (String)","));
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(((ProcessTaskRelation)upstreamList.get(0)).getProcessDefinitionCode());
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(((ProcessTaskRelation)upstreamList.get(0)).getProcessDefinitionCode()));
            return result;
        }
        List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(projectCode, processDefinition.getCode());
        ArrayList processTaskRelationList = Lists.newArrayList((Iterable)processTaskRelations);
        ArrayList processTaskRelationWaitRemove = Lists.newArrayList();
        for (ProcessTaskRelation processTaskRelation : processTaskRelationList) {
            if (currentUpstreamList.size() > 1) {
                if (!currentUpstreamList.contains(processTaskRelation.getPreTaskCode())) continue;
                currentUpstreamList.remove(processTaskRelation.getPreTaskCode());
                processTaskRelationWaitRemove.add(processTaskRelation);
                continue;
            }
            if (processTaskRelation.getPostTaskCode() != taskCode || !currentUpstreamList.isEmpty() && !tmpCurrent.isEmpty()) continue;
            processTaskRelation.setPreTaskVersion(0);
            processTaskRelation.setPreTaskCode(0L);
        }
        processTaskRelationList.removeAll(processTaskRelationWaitRemove);
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        this.updateRelation(loginUser, result, processDefinition, processTaskRelationList);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> deleteDownstreamRelation(User loginUser, long projectCode, String postTaskCodes, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)postTaskCodes)) {
            this.putMsg(result, Status.DATA_IS_NULL, "postTaskCodes");
            return result;
        }
        List downstreamList = this.processTaskRelationMapper.queryDownstreamByCode(projectCode, taskCode);
        if (CollectionUtils.isEmpty((Collection)downstreamList)) {
            this.putMsg(result, Status.DATA_IS_NULL, "taskCode");
            return result;
        }
        List postTaskCodeList = Lists.newArrayList((Object[])postTaskCodes.split(",")).stream().map(Long::parseLong).collect(Collectors.toList());
        if (postTaskCodeList.contains(0L)) {
            this.putMsg(result, Status.DATA_IS_NULL, "postTaskCodes");
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(((ProcessTaskRelation)downstreamList.get(0)).getProcessDefinitionCode());
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(((ProcessTaskRelation)downstreamList.get(0)).getProcessDefinitionCode()));
            return result;
        }
        List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(projectCode, processDefinition.getCode());
        ArrayList processTaskRelationList = Lists.newArrayList((Iterable)processTaskRelations);
        processTaskRelationList.removeIf(processTaskRelation -> postTaskCodeList.contains(processTaskRelation.getPostTaskCode()) && processTaskRelation.getPreTaskCode() == taskCode);
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        this.updateRelation(loginUser, result, processDefinition, processTaskRelationList);
        return result;
    }

    @Override
    public Map<String, Object> queryUpstreamRelation(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List processTaskRelationList = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        List taskDefinitionLogList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)processTaskRelationList)) {
            Set taskDefinitions = processTaskRelationList.stream().map(processTaskRelation -> {
                TaskDefinition taskDefinition = this.buildTaskDefinition();
                taskDefinition.setProjectCode(processTaskRelation.getProjectCode());
                taskDefinition.setCode(processTaskRelation.getPreTaskCode());
                taskDefinition.setVersion(processTaskRelation.getPreTaskVersion());
                return taskDefinition;
            }).collect(Collectors.toSet());
            taskDefinitionLogList = this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitions);
        }
        result.put("data", taskDefinitionLogList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryDownstreamRelation(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List processTaskRelationList = this.processTaskRelationMapper.queryDownstreamByCode(projectCode, taskCode);
        List taskDefinitionLogList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)processTaskRelationList)) {
            Set taskDefinitions = processTaskRelationList.stream().map(processTaskRelation -> {
                TaskDefinition taskDefinition = this.buildTaskDefinition();
                taskDefinition.setProjectCode(processTaskRelation.getProjectCode());
                taskDefinition.setCode(processTaskRelation.getPostTaskCode());
                taskDefinition.setVersion(processTaskRelation.getPostTaskVersion());
                return taskDefinition;
            }).collect(Collectors.toSet());
            taskDefinitionLogList = this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitions);
        }
        result.put("data", taskDefinitionLogList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> deleteEdge(User loginUser, long projectCode, long processDefinitionCode, long preTaskCode, long postTaskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(processDefinitionCode));
            return result;
        }
        List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(projectCode, processDefinitionCode);
        ArrayList processTaskRelationList = Lists.newArrayList((Iterable)processTaskRelations);
        if (CollectionUtils.isEmpty((Collection)processTaskRelationList)) {
            this.putMsg(result, Status.DATA_IS_NULL, "processTaskRelationList");
            return result;
        }
        HashMap<Long, List> taskRelationMap = new HashMap<Long, List>();
        for (ProcessTaskRelation processTaskRelation : processTaskRelationList) {
            taskRelationMap.compute(processTaskRelation.getPostTaskCode(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<ProcessTaskRelation>();
                }
                v.add(processTaskRelation);
                return v;
            });
        }
        if (!taskRelationMap.containsKey(postTaskCode)) {
            this.putMsg(result, Status.DATA_IS_NULL, "postTaskCode");
            return result;
        }
        if (((List)taskRelationMap.get(postTaskCode)).size() > 1) {
            for (ProcessTaskRelation processTaskRelation : (List)taskRelationMap.get(postTaskCode)) {
                if (processTaskRelation.getPreTaskCode() != preTaskCode) continue;
                int delete = this.processTaskRelationMapper.deleteById((Serializable)Integer.valueOf(processTaskRelation.getId()));
                if (delete == 0) {
                    this.putMsg(result, Status.DELETE_EDGE_ERROR, new Object[0]);
                    throw new ServiceException(Status.DELETE_EDGE_ERROR);
                }
                processTaskRelationList.remove(processTaskRelation);
            }
        } else {
            ProcessTaskRelation processTaskRelation = (ProcessTaskRelation)((List)taskRelationMap.get(postTaskCode)).get(0);
            processTaskRelationList.remove(processTaskRelation);
            processTaskRelation.setPreTaskVersion(0);
            processTaskRelation.setPreTaskCode(0L);
            processTaskRelationList.add(processTaskRelation);
        }
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        this.updateRelation(loginUser, result, processDefinition, processTaskRelationList);
        return result;
    }

    private TaskDefinition buildTaskDefinition() {
        return new TaskDefinition(){

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof TaskDefinition)) {
                    return false;
                }
                TaskDefinition that = (TaskDefinition)o;
                return this.getCode() == that.getCode() && this.getVersion() == that.getVersion() && this.getProjectCode() == that.getProjectCode();
            }

            public int hashCode() {
                return Objects.hash(this.getCode(), this.getVersion(), this.getProjectCode());
            }
        };
    }
}

