/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.UdfFuncService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.UdfType;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ResourceMapper;
import org.apache.dolphinscheduler.dao.mapper.UDFUserMapper;
import org.apache.dolphinscheduler.dao.mapper.UdfFuncMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UdfFuncServiceImpl
extends BaseServiceImpl
implements UdfFuncService {
    private static final Logger logger = LoggerFactory.getLogger(UdfFuncServiceImpl.class);
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private UdfFuncMapper udfFuncMapper;
    @Autowired
    private UDFUserMapper udfUserMapper;

    @Override
    @Transactional
    public Result<Object> createUdfFunction(User loginUser, String funcName, String className, String argTypes, String database, String desc, UdfType type, int resourceId) {
        Result<Object> result = new Result<Object>();
        if (!PropertyUtils.getResUploadStartupState()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg((Result)result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        if (this.checkUdfFuncNameExists(funcName)) {
            this.putMsg((Result)result, Status.UDF_FUNCTION_EXISTS, new Object[0]);
            return result;
        }
        Resource resource = (Resource)this.resourceMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("resourceId {} is not exist", (Object)resourceId);
            this.putMsg((Result)result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        UdfFunc udf = new UdfFunc();
        Date now = new Date();
        udf.setUserId(loginUser.getId());
        udf.setFuncName(funcName);
        udf.setClassName(className);
        if (!StringUtils.isEmpty((String)argTypes)) {
            udf.setArgTypes(argTypes);
        }
        if (!StringUtils.isEmpty((String)database)) {
            udf.setDatabase(database);
        }
        udf.setDescription(desc);
        udf.setResourceId(resourceId);
        udf.setResourceName(resource.getFullName());
        udf.setType(type);
        udf.setCreateTime(now);
        udf.setUpdateTime(now);
        this.udfFuncMapper.insert((Object)udf);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkUdfFuncNameExists(String name) {
        List resource = this.udfFuncMapper.queryUdfByIdStr(null, name);
        return resource != null && !resource.isEmpty();
    }

    @Override
    public Map<String, Object> queryUdfFuncDetail(int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        UdfFunc udfFunc = (UdfFunc)this.udfFuncMapper.selectById((Serializable)Integer.valueOf(id));
        if (udfFunc == null) {
            this.putMsg(result, Status.RESOURCE_NOT_EXIST, new Object[0]);
            return result;
        }
        result.put("data", udfFunc);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> updateUdfFunc(int udfFuncId, String funcName, String className, String argTypes, String database, String desc, UdfType type, int resourceId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        UdfFunc udf = this.udfFuncMapper.selectUdfById(udfFuncId);
        if (udf == null) {
            result.put("status", (Object)Status.UDF_FUNCTION_NOT_EXIST);
            result.put("msg", Status.UDF_FUNCTION_NOT_EXIST.getMsg());
            return result;
        }
        if (!PropertyUtils.getResUploadStartupState()) {
            logger.error("resource upload startup state: {}", (Object)PropertyUtils.getResUploadStartupState());
            this.putMsg(result, Status.HDFS_NOT_STARTUP, new Object[0]);
            return result;
        }
        if (!funcName.equals(udf.getFuncName()) && this.checkUdfFuncNameExists(funcName)) {
            logger.error("UdfFuncRequest {} has exist, can't create again.", (Object)funcName);
            result.put("status", (Object)Status.UDF_FUNCTION_EXISTS);
            result.put("msg", Status.UDF_FUNCTION_EXISTS.getMsg());
            return result;
        }
        Resource resource = (Resource)this.resourceMapper.selectById((Serializable)Integer.valueOf(resourceId));
        if (resource == null) {
            logger.error("resourceId {} is not exist", (Object)resourceId);
            result.put("status", (Object)Status.RESOURCE_NOT_EXIST);
            result.put("msg", Status.RESOURCE_NOT_EXIST.getMsg());
            return result;
        }
        Date now = new Date();
        udf.setFuncName(funcName);
        udf.setClassName(className);
        udf.setArgTypes(argTypes);
        if (!StringUtils.isEmpty((String)database)) {
            udf.setDatabase(database);
        }
        udf.setDescription(desc);
        udf.setResourceId(resourceId);
        udf.setResourceName(resource.getFullName());
        udf.setType(type);
        udf.setUpdateTime(now);
        this.udfFuncMapper.updateById((Object)udf);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryUdfFuncListPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        IPage<UdfFunc> udfFuncList = this.getUdfFuncsPage(loginUser, searchVal, pageSize, pageNo);
        pageInfo.setTotal((int)udfFuncList.getTotal());
        pageInfo.setTotalList(udfFuncList.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private IPage<UdfFunc> getUdfFuncsPage(User loginUser, String searchVal, Integer pageSize, int pageNo) {
        int userId = loginUser.getId();
        if (this.isAdmin(loginUser)) {
            userId = 0;
        }
        Page page = new Page((long)pageNo, (long)pageSize.intValue());
        return this.udfFuncMapper.queryUdfFuncPaging((IPage)page, userId, searchVal);
    }

    @Override
    public Map<String, Object> queryUdfFuncList(User loginUser, Integer type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int userId = loginUser.getId();
        if (this.isAdmin(loginUser)) {
            userId = 0;
        }
        List udfFuncList = this.udfFuncMapper.getUdfFuncByType(userId, type);
        result.put("data", udfFuncList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Result<Object> delete(int id) {
        Result<Object> result = new Result<Object>();
        this.udfFuncMapper.deleteById((Serializable)Integer.valueOf(id));
        this.udfUserMapper.deleteByUdfFuncId(id);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyUdfFuncByName(String name) {
        Result<Object> result = new Result<Object>();
        if (this.checkUdfFuncNameExists(name)) {
            this.putMsg((Result)result, Status.UDF_FUNCTION_EXISTS, new Object[0]);
        } else {
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }
}

