/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.python;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dolphinscheduler.api.configuration.PythonGatewayConfiguration;
import org.apache.dolphinscheduler.api.dto.resources.ResourceComponent;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.service.ProcessDefinitionService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.ResourcesService;
import org.apache.dolphinscheduler.api.service.SchedulerService;
import org.apache.dolphinscheduler.api.service.TaskDefinitionService;
import org.apache.dolphinscheduler.api.service.TenantService;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ComplementDependentMode;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ProcessExecutionTypeEnum;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.RunMode;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.Queue;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectUserMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import py4j.GatewayServer;

@Component
public class PythonGateway {
    private static final Logger logger = LoggerFactory.getLogger(PythonGateway.class);
    private static final FailureStrategy DEFAULT_FAILURE_STRATEGY = FailureStrategy.CONTINUE;
    private static final Priority DEFAULT_PRIORITY = Priority.MEDIUM;
    private static final Long DEFAULT_ENVIRONMENT_CODE = -1L;
    private static final TaskDependType DEFAULT_TASK_DEPEND_TYPE = TaskDependType.TASK_POST;
    private static final RunMode DEFAULT_RUN_MODE = RunMode.RUN_MODE_SERIAL;
    private static final int DEFAULT_DRY_RUN = 0;
    private static final ComplementDependentMode COMPLEMENT_DEPENDENT_MODE = ComplementDependentMode.OFF_MODE;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private ExecutorService executorService;
    @Autowired
    private ProcessDefinitionService processDefinitionService;
    @Autowired
    private TaskDefinitionService taskDefinitionService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private ResourcesService resourceService;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private SchedulerService schedulerService;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private PythonGatewayConfiguration pythonGatewayConfiguration;
    @Autowired
    private ProjectUserMapper projectUserMapper;
    private final User dummyAdminUser = new User(){
        {
            this.setId(Integer.MAX_VALUE);
            this.setUserName("dummyUser");
            this.setUserType(UserType.ADMIN_USER);
        }
    };
    private final Queue queuePythonGateway = new Queue(){
        {
            this.setId(Integer.MAX_VALUE);
            this.setQueueName("queuePythonGateway");
        }
    };

    public String ping() {
        return "PONG";
    }

    public Map<String, Object> genTaskCodeList(Integer genNum) {
        return this.taskDefinitionService.genTaskCodeList(genNum);
    }

    public Map<String, Long> getCodeAndVersion(String projectName, String processDefinitionName, String taskName) throws CodeGenerateUtils.CodeGenerateException {
        Project project = this.projectMapper.queryByName(projectName);
        HashMap<String, Long> result = new HashMap<String, Long>();
        if (project == null) {
            result.put("code", CodeGenerateUtils.getInstance().genCode());
            result.put("version", 0L);
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByDefineName(project.getCode(), processDefinitionName);
        if (processDefinition == null) {
            result.put("code", CodeGenerateUtils.getInstance().genCode());
            result.put("version", 0L);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByName(project.getCode(), processDefinition.getCode(), taskName);
        if (taskDefinition == null) {
            result.put("code", CodeGenerateUtils.getInstance().genCode());
            result.put("version", 0L);
        } else {
            result.put("code", taskDefinition.getCode());
            result.put("version", Long.valueOf(taskDefinition.getVersion()));
        }
        return result;
    }

    public Long createOrUpdateProcessDefinition(String userName, String projectName, String name, String description, String globalParams, String schedule, String warningType, int warningGroupId, String locations, int timeout, String workerGroup, String tenantCode, int releaseState, String taskRelationJson, String taskDefinitionJson, ProcessExecutionTypeEnum executionType) {
        long processDefinitionCode;
        Project project;
        long projectCode;
        User user = this.usersService.queryUser(userName);
        ProcessDefinition processDefinition = this.getProcessDefinition(user, projectCode = (project = this.projectMapper.queryByName(projectName)).getCode(), name);
        if (processDefinition != null) {
            processDefinitionCode = processDefinition.getCode();
            this.processDefinitionService.releaseProcessDefinition(user, projectCode, processDefinitionCode, ReleaseState.OFFLINE);
            Map<String, Object> map = this.processDefinitionService.updateProcessDefinition(user, projectCode, name, processDefinitionCode, description, globalParams, locations, timeout, tenantCode, taskRelationJson, taskDefinitionJson, executionType);
        } else {
            Map<String, Object> result = this.processDefinitionService.createProcessDefinition(user, projectCode, name, description, globalParams, locations, timeout, tenantCode, taskRelationJson, taskDefinitionJson, executionType);
            processDefinition = (ProcessDefinition)result.get("data");
            processDefinitionCode = processDefinition.getCode();
        }
        if (schedule != null) {
            this.createOrUpdateSchedule(user, projectCode, processDefinitionCode, schedule, workerGroup, warningType, warningGroupId);
        }
        this.processDefinitionService.releaseProcessDefinition(user, projectCode, processDefinitionCode, ReleaseState.getEnum((int)releaseState));
        return processDefinitionCode;
    }

    private ProcessDefinition getProcessDefinition(User user, long projectCode, String processDefinitionName) {
        Map<String, Object> verifyProcessDefinitionExists = this.processDefinitionService.verifyProcessDefinitionName(user, projectCode, processDefinitionName, 0L);
        Status verifyStatus = (Status)((Object)verifyProcessDefinitionExists.get("status"));
        ProcessDefinition processDefinition = null;
        if (verifyStatus == Status.PROCESS_DEFINITION_NAME_EXIST) {
            processDefinition = this.processDefinitionMapper.queryByDefineName(projectCode, processDefinitionName);
        } else if (verifyStatus != Status.SUCCESS) {
            String msg = "Verify process definition exists status is invalid, neither SUCCESS or PROCESS_DEFINITION_NAME_EXIST.";
            logger.error(msg);
            throw new RuntimeException(msg);
        }
        return processDefinition;
    }

    private void createOrUpdateSchedule(User user, long projectCode, long processDefinitionCode, String schedule, String workerGroup, String warningType, int warningGroupId) {
        int scheduleId;
        Schedule scheduleObj = this.scheduleMapper.queryByProcessDefinitionCode(processDefinitionCode);
        if (scheduleObj == null) {
            this.processDefinitionService.releaseProcessDefinition(user, projectCode, processDefinitionCode, ReleaseState.ONLINE);
            Map<String, Object> result = this.schedulerService.insertSchedule(user, projectCode, processDefinitionCode, schedule, WarningType.valueOf((String)warningType), warningGroupId, DEFAULT_FAILURE_STRATEGY, DEFAULT_PRIORITY, workerGroup, DEFAULT_ENVIRONMENT_CODE);
            scheduleId = (Integer)result.get("scheduleId");
        } else {
            scheduleId = scheduleObj.getId();
            this.processDefinitionService.releaseProcessDefinition(user, projectCode, processDefinitionCode, ReleaseState.OFFLINE);
            this.schedulerService.updateSchedule(user, projectCode, scheduleId, schedule, WarningType.valueOf((String)warningType), warningGroupId, DEFAULT_FAILURE_STRATEGY, DEFAULT_PRIORITY, workerGroup, DEFAULT_ENVIRONMENT_CODE);
        }
        this.schedulerService.setScheduleState(user, projectCode, scheduleId, ReleaseState.ONLINE);
    }

    public void execProcessInstance(String userName, String projectName, String processDefinitionName, String cronTime, String workerGroup, String warningType, Integer warningGroupId, Integer timeout) {
        User user = this.usersService.queryUser(userName);
        Project project = this.projectMapper.queryByName(projectName);
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByDefineName(project.getCode(), processDefinitionName);
        this.processDefinitionService.releaseProcessDefinition(user, project.getCode(), processDefinition.getCode(), ReleaseState.ONLINE);
        this.executorService.execProcessInstance(user, project.getCode(), processDefinition.getCode(), cronTime, null, DEFAULT_FAILURE_STRATEGY, null, DEFAULT_TASK_DEPEND_TYPE, WarningType.valueOf((String)warningType), warningGroupId, DEFAULT_RUN_MODE, DEFAULT_PRIORITY, workerGroup, DEFAULT_ENVIRONMENT_CODE, timeout, null, null, 0, COMPLEMENT_DEPENDENT_MODE);
    }

    private Integer grantProjectToUser(Project project, User user) {
        Date now = new Date();
        ProjectUser projectUser = new ProjectUser();
        projectUser.setUserId(user.getId());
        projectUser.setProjectId(project.getId());
        projectUser.setPerm(7);
        projectUser.setCreateTime(now);
        projectUser.setUpdateTime(now);
        return this.projectUserMapper.insert((Object)projectUser);
    }

    public void createOrGrantProject(String userName, String name, String desc) {
        ProjectUser projectUser;
        User user = this.usersService.queryUser(userName);
        Project project = this.projectMapper.queryByName(name);
        if (project == null) {
            this.projectService.createProject(user, name, desc);
        } else if (project.getUserId() != user.getId() && (projectUser = this.projectUserMapper.queryProjectRelation(project.getId(), user.getId())) == null) {
            this.grantProjectToUser(project, user);
        }
    }

    public Tenant createTenant(String tenantCode, String desc, String queueName) {
        return this.tenantService.createTenantIfNotExists(tenantCode, desc, queueName, queueName);
    }

    public void createUser(String userName, String userPassword, String email, String phone, String tenantCode, String queue, int state) {
        User user = this.usersService.queryUser(userName);
        if (Objects.isNull(user)) {
            Map<String, Object> tenantResult = this.tenantService.queryByTenantCode(tenantCode);
            Tenant tenant = (Tenant)tenantResult.get("data");
            this.usersService.createUser(userName, userPassword, email, tenant.getId(), phone, queue, state);
        }
    }

    public Map<String, Object> getDatasourceInfo(String datasourceName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List dataSourceList = this.dataSourceMapper.queryDataSourceByName(datasourceName);
        if (dataSourceList == null || dataSourceList.isEmpty()) {
            String msg = String.format("Can not find any datasource by name %s", datasourceName);
            logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if (dataSourceList.size() > 1) {
            String msg = String.format("Get more than one datasource by name %s", datasourceName);
            logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        DataSource dataSource = (DataSource)dataSourceList.get(0);
        result.put("id", dataSource.getId());
        result.put("type", dataSource.getType().name());
        result.put("name", dataSource.getName());
        return result;
    }

    public Map<String, Object> getProcessDefinitionInfo(String userName, String projectName, String processDefinitionName) {
        Project project;
        long projectCode;
        HashMap<String, Object> result = new HashMap<String, Object>();
        User user = this.usersService.queryUser(userName);
        ProcessDefinition processDefinition = this.getProcessDefinition(user, projectCode = (project = (Project)this.projectService.queryByName(user, projectName).get("data")).getCode(), processDefinitionName);
        if (processDefinition == null) {
            String msg = String.format("Can not find valid process definition by name %s", processDefinitionName);
            logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.processDefinitionService.releaseProcessDefinition(user, projectCode, processDefinition.getCode(), ReleaseState.ONLINE);
        result.put("id", processDefinition.getId());
        result.put("name", processDefinition.getName());
        result.put("code", processDefinition.getCode());
        return result;
    }

    public Map<String, Object> getDependentInfo(String projectName, String processDefinitionName, String taskName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByName(projectName);
        if (project == null) {
            String msg = String.format("Can not find valid project by name %s", projectName);
            logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        long projectCode = project.getCode();
        result.put("projectCode", projectCode);
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByDefineName(projectCode, processDefinitionName);
        if (processDefinition == null) {
            String msg = String.format("Can not find valid process definition by name %s", processDefinitionName);
            logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        result.put("processDefinitionCode", processDefinition.getCode());
        if (taskName != null) {
            TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByName(projectCode, processDefinition.getCode(), taskName);
            result.put("taskDefinitionCode", taskDefinition.getCode());
        }
        return result;
    }

    public Map<String, Object> getResourcesFileInfo(String programType, String fullName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> resources = this.resourceService.queryResourceByProgramType(this.dummyAdminUser, ResourceType.FILE, ProgramType.valueOf((String)programType));
        List resourcesComponent = (List)resources.get("data");
        List namedResources = resourcesComponent.stream().filter(s -> fullName.equals(s.getFullName())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(namedResources)) {
            String msg = String.format("Can not find valid resource by program type %s and name %s", programType, fullName);
            logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        result.put("id", ((ResourceComponent)namedResources.get(0)).getId());
        result.put("name", ((ResourceComponent)namedResources.get(0)).getName());
        return result;
    }

    public Map<String, Object> queryResourcesFileInfo(String userName, String fullName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        User user = this.usersService.queryUser(userName);
        Result<Object> resourceResponse = this.resourceService.queryResource(fullName, null, ResourceType.FILE);
        if (resourceResponse.getCode().intValue() != Status.SUCCESS.getCode()) {
            String msg = String.format("Can not find valid resource by name %s", fullName);
            logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        Resource resource = (Resource)resourceResponse.getData();
        result.put("id", resource.getId());
        result.put("name", resource.getFullName());
        return result;
    }

    public Integer createOrUpdateResource(String userName, String fullName, String description, String resourceContent) {
        return this.resourceService.createOrUpdateResource(userName, fullName, description, resourceContent);
    }

    @PostConstruct
    public void init() {
        if (this.pythonGatewayConfiguration.getEnabled()) {
            this.start();
        }
    }

    private void start() {
        try {
            InetAddress gatewayHost = InetAddress.getByName(this.pythonGatewayConfiguration.getGatewayServerAddress());
            InetAddress pythonHost = InetAddress.getByName(this.pythonGatewayConfiguration.getPythonAddress());
            GatewayServer server = new GatewayServer((Object)this, this.pythonGatewayConfiguration.getGatewayServerPort(), this.pythonGatewayConfiguration.getPythonPort(), gatewayHost, pythonHost, this.pythonGatewayConfiguration.getConnectTimeout(), this.pythonGatewayConfiguration.getReadTimeout(), null);
            GatewayServer.turnLoggingOn();
            logger.info("PythonGatewayService started on: " + gatewayHost.toString());
            server.start();
        }
        catch (UnknownHostException e) {
            logger.error("exception occurred while constructing PythonGatewayService().", (Throwable)e);
        }
    }
}

