/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.security.impl.ldap;

import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.support.filter.EqualsFilter;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class LdapService {
    private static final Logger logger = LoggerFactory.getLogger(LdapService.class);
    @Value(value="${security.authentication.ldap.user.admin:#{null}}")
    private String adminUserId;
    @Value(value="${security.authentication.ldap.urls:#{null}}")
    private String ldapUrls;
    @Value(value="${security.authentication.ldap.base-dn:#{null}}")
    private String ldapBaseDn;
    @Value(value="${security.authentication.ldap.username:#{null}}")
    private String ldapSecurityPrincipal;
    @Value(value="${security.authentication.ldap.password:#{null}}")
    private String ldapPrincipalPassword;
    @Value(value="${security.authentication.ldap.user.identity-attribute:#{null}}")
    private String ldapUserIdentifyingAttribute;
    @Value(value="${security.authentication.ldap.user.email-attribute:#{null}}")
    private String ldapEmailAttribute;

    public UserType getUserType(String userId) {
        return this.adminUserId.equalsIgnoreCase(userId) ? UserType.ADMIN_USER : UserType.GENERAL_USER;
    }

    public String ldapLogin(String userId, String userPwd) {
        block5: {
            Properties searchEnv = this.getManagerLdapEnv();
            try {
                InitialLdapContext ctx = new InitialLdapContext(searchEnv, null);
                SearchControls sc = new SearchControls();
                sc.setReturningAttributes(new String[]{this.ldapEmailAttribute});
                sc.setSearchScope(2);
                EqualsFilter filter = new EqualsFilter(this.ldapUserIdentifyingAttribute, userId);
                NamingEnumeration<SearchResult> results = ctx.search(this.ldapBaseDn, filter.toString(), sc);
                if (!results.hasMore()) break block5;
                SearchResult result = results.next();
                NamingEnumeration<? extends Attribute> attrs = result.getAttributes().getAll();
                while (attrs.hasMore()) {
                    searchEnv.put("java.naming.security.principal", result.getNameInNamespace());
                    searchEnv.put("java.naming.security.credentials", userPwd);
                    try {
                        new InitialDirContext(searchEnv);
                    }
                    catch (Exception e) {
                        logger.warn("invalid ldap credentials or ldap search error", (Throwable)e);
                        return null;
                    }
                    Attribute attr = attrs.next();
                    if (!attr.getID().equals(this.ldapEmailAttribute)) continue;
                    return (String)attr.get();
                }
            }
            catch (NamingException e) {
                logger.error("ldap search error", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    Properties getManagerLdapEnv() {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.ldapSecurityPrincipal);
        env.put("java.naming.security.credentials", this.ldapPrincipalPassword);
        env.put("java.naming.provider.url", this.ldapUrls);
        return env;
    }
}

