/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.TaskGroupQueueService;
import org.apache.dolphinscheduler.api.service.TaskGroupService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"task group"})
@RestController
@RequestMapping(value={"/task-group"})
public class TaskGroupController
extends BaseController {
    @Autowired
    private TaskGroupService taskGroupService;
    @Autowired
    private TaskGroupQueueService taskGroupQueueService;

    @ApiOperation(value="create", notes="CREATE_TASK_GROUP_NOTE")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="NAME", dataTypeClass=String.class), @ApiImplicitParam(name="projectCode", value="PROJECT_CODE", dataTypeClass=long.class), @ApiImplicitParam(name="description", value="TASK_GROUP_DESCRIPTION", dataTypeClass=String.class), @ApiImplicitParam(name="groupSize", value="GROUP_SIZE", dataTypeClass=int.class)})
    @PostMapping(value={"/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_TASK_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createTaskGroup(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name, @RequestParam(value="projectCode", required=false, defaultValue="0") Long projectcode, @RequestParam(value="description") String description, @RequestParam(value="groupSize") Integer groupSize) {
        Map<String, Object> result = this.taskGroupService.createTaskGroup(loginUser, projectcode, name, description, groupSize);
        return this.returnDataList(result);
    }

    @ApiOperation(value="update", notes="UPDATE_TASK_GROUP_NOTE")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="TASK_GROUP_ID", dataTypeClass=int.class), @ApiImplicitParam(name="name", value="TASK_GROUP_NAME", dataTypeClass=String.class), @ApiImplicitParam(name="description", value="TASK_GROUP_DESCRIPTION", dataTypeClass=String.class), @ApiImplicitParam(name="groupSize", value="GROUP_SIZE", dataTypeClass=int.class)})
    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.UPDATE_TASK_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateTaskGroup(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id") Integer id, @RequestParam(value="name") String name, @RequestParam(value="description") String description, @RequestParam(value="groupSize") Integer groupSize) {
        Map<String, Object> result = this.taskGroupService.updateTaskGroup(loginUser, id, name, description, groupSize);
        return this.returnDataList(result);
    }

    @ApiOperation(value="list-paging", notes="QUERY_ALL_TASK_GROUP_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="name", value="TASK_GROUP_NAME", required=false, dataTypeClass=String.class), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="20")})
    @GetMapping(value={"/list-paging"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_GROUP_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryAllTaskGroup(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name", required=false) String name, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Map<String, Object> result = this.taskGroupService.queryAllTaskGroup(loginUser, name, status, pageNo, pageSize);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryTaskGroupByStatus", notes="QUERY_TASK_GROUP_LIST_BY_STATUS_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="20"), @ApiImplicitParam(name="status", value="TASK_GROUP_STATUS", required=true, dataTypeClass=int.class)})
    @GetMapping(value={"/query-list-by-status"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_GROUP_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskGroupByStatus(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="pageSize") Integer pageSize) {
        Map<String, Object> result = this.taskGroupService.queryTaskGroupByStatus(loginUser, pageNo, pageSize, status);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryTaskGroupByName", notes="QUERY_TASK_GROUP_LIST_BY_PROJECT_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="20"), @ApiImplicitParam(name="projectCode", value="PROJECT_CODE", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/query-list-by-projectCode"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_GROUP_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskGroupByCode(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="projectCode", required=false) Long projectCode, @RequestParam(value="pageSize") Integer pageSize) {
        Map<String, Object> result = this.taskGroupService.queryTaskGroupByProjectCode(loginUser, pageNo, pageSize, projectCode);
        return this.returnDataList(result);
    }

    @ApiOperation(value="closeTaskGroup", notes="CLOSE_TASK_GROUP_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=true, dataTypeClass=int.class)})
    @PostMapping(value={"/close-task-group"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CLOSE_TASK_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result closeTaskGroup(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id", required=false) Integer id) {
        Map<String, Object> result = this.taskGroupService.closeTaskGroup(loginUser, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="startTaskGroup", notes="START_TASK_GROUP_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="TASK_GROUP_ID", required=true, dataTypeClass=int.class)})
    @PostMapping(value={"/start-task-group"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.START_TASK_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result startTaskGroup(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="id", required=false) Integer id) {
        Map<String, Object> result = this.taskGroupService.startTaskGroup(loginUser, id);
        return this.returnDataList(result);
    }

    @ApiOperation(value="forceStart", notes="FORCE_START_TASK_GROUP")
    @ApiImplicitParams(value={@ApiImplicitParam(name="queueId", value="TASK_GROUP_QUEUE_ID", required=true, dataTypeClass=int.class)})
    @PostMapping(value={"/forceStart"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.START_TASK_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result forceStart(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="queueId") Integer queueId) {
        Map<String, Object> result = this.taskGroupService.forceStartTask(loginUser, queueId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="modifyPriority", notes="MODIFY_TASK_GROUP_PRIORITY")
    @ApiImplicitParams(value={@ApiImplicitParam(name="queueId", value="TASK_GROUP_QUEUE_ID", required=true, dataTypeClass=int.class), @ApiImplicitParam(name="priority", value="TASK_GROUP_QUEUE_PRIORITY", required=true, dataTypeClass=int.class)})
    @PostMapping(value={"/modifyPriority"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.START_TASK_GROUP_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result modifyPriority(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="queueId") Integer queueId, @RequestParam(value="priority") Integer priority) {
        Map<String, Object> result = this.taskGroupService.modifyPriority(loginUser, queueId, priority);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryTasksByGroupId", notes="QUERY_ALL_TASKS_GROUP_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", value="GROUP_ID", required=false, dataTypeClass=int.class, example="1", defaultValue="-1"), @ApiImplicitParam(name="taskInstanceName", value="TASK_INSTANCE_NAME", required=false, dataTypeClass=String.class, example="taskName"), @ApiImplicitParam(name="processInstanceName", value="PROCESS_INSTANCE_NAME", required=false, dataTypeClass=String.class, example="processName"), @ApiImplicitParam(name="status", value="TASK_GROUP_STATUS", required=false, dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataTypeClass=int.class, example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataTypeClass=int.class, example="20")})
    @GetMapping(value={"/query-list-by-group-id"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_GROUP_QUEUE_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTasksByGroupId(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="groupId", required=false, defaultValue="-1") Integer groupId, @RequestParam(value="taskInstanceName", required=false) String taskName, @RequestParam(value="processInstanceName", required=false) String processName, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Map<String, Object> result = this.taskGroupQueueService.queryTasksByGroupId(loginUser, taskName, processName, status, groupId, pageNo, pageSize);
        return this.returnDataList(result);
    }
}

