/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.permission.ResourcePermissionCheckService;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseServiceImpl
implements BaseService {
    private static final Logger logger = LoggerFactory.getLogger(BaseServiceImpl.class);
    @Autowired
    protected ResourcePermissionCheckService resourcePermissionCheckService;

    @Override
    public void permissionPostHandle(AuthorizationType authorizationType, Integer userId, List<Integer> ids, Logger logger) {
        try {
            this.resourcePermissionCheckService.postHandle(authorizationType, userId, ids, logger);
        }
        catch (Exception e) {
            logger.error("post handle error", (Throwable)e);
            throw new RuntimeException("resource association user error", e);
        }
    }

    @Override
    public boolean isAdmin(User user) {
        return user.getUserType() == UserType.ADMIN_USER;
    }

    @Override
    public boolean isNotAdmin(User loginUser, Map<String, Object> result) {
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public void putMsg(Map<String, Object> result, Status status, Object ... statusParams) {
        result.put("status", (Object)status);
        if (statusParams != null && statusParams.length > 0) {
            result.put("msg", MessageFormat.format(status.getMsg(), statusParams));
        } else {
            result.put("msg", status.getMsg());
        }
    }

    public void putMsg(Result result, Status status, Object ... statusParams) {
        result.setCode(status.getCode());
        if (statusParams != null && statusParams.length > 0) {
            result.setMsg(MessageFormat.format(status.getMsg(), statusParams));
        } else {
            result.setMsg(status.getMsg());
        }
    }

    @Override
    public boolean check(Map<String, Object> result, boolean bool, Status userNoOperationPerm) {
        if (bool) {
            result.put("status", (Object)userNoOperationPerm);
            result.put("msg", userNoOperationPerm.getMsg());
            return true;
        }
        return false;
    }

    @Override
    public boolean canOperator(User operateUser, int createUserId) {
        return operateUser.getId() == createUserId || this.isAdmin(operateUser);
    }

    @Override
    public boolean canOperatorPermissions(User user, Object[] ids, AuthorizationType type, String permissionKey) {
        boolean operationPermissionCheck = this.resourcePermissionCheckService.operationPermissionCheck(type, (Object[])(type.equals((Object)AuthorizationType.PROJECTS) ? ids : null), user.getId(), permissionKey, logger);
        boolean resourcePermissionCheck = this.resourcePermissionCheckService.resourcePermissionCheck(type, ids, user.getUserType().equals((Object)UserType.ADMIN_USER) ? 0 : user.getId(), logger);
        return operationPermissionCheck && resourcePermissionCheck;
    }

    @Override
    public Map<String, Object> checkAndParseDateParameters(String startDateStr, String endDateStr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Date start = null;
        if (!StringUtils.isEmpty((CharSequence)startDateStr) && Objects.isNull(start = DateUtils.stringToDate((String)startDateStr))) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "startDate,endDate");
            return result;
        }
        result.put("start time", start);
        Date end = null;
        if (!StringUtils.isEmpty((CharSequence)endDateStr) && Objects.isNull(end = DateUtils.stringToDate((String)endDateStr))) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "startDate,endDate");
            return result;
        }
        result.put("end time", end);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public boolean checkDescriptionLength(String description) {
        return description != null && description.codePointCount(0, description.length()) > 255;
    }
}

