/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.QueueService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.dao.entity.Queue;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.QueueMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QueueServiceImpl
extends BaseServiceImpl
implements QueueService {
    private static final Logger logger = LoggerFactory.getLogger(QueueServiceImpl.class);
    @Autowired
    private QueueMapper queueMapper;
    @Autowired
    private UserMapper userMapper;

    private void createQueueValid(Queue queue) throws ServiceException {
        if (StringUtils.isEmpty((CharSequence)queue.getQueue())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queue");
        }
        if (StringUtils.isEmpty((CharSequence)queue.getQueueName())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queueName");
        }
        if (this.checkQueueExist(queue.getQueue())) {
            throw new ServiceException(Status.QUEUE_VALUE_EXIST, queue.getQueue());
        }
        if (this.checkQueueNameExist(queue.getQueueName())) {
            throw new ServiceException(Status.QUEUE_NAME_EXIST, queue.getQueueName());
        }
    }

    private void updateQueueValid(Queue existsQueue, Queue updateQueue) throws ServiceException {
        if (Objects.isNull(existsQueue)) {
            throw new ServiceException(Status.QUEUE_NOT_EXIST, updateQueue.getQueue());
        }
        if (Objects.equals(existsQueue, updateQueue)) {
            throw new ServiceException(Status.NEED_NOT_UPDATE_QUEUE);
        }
        if (StringUtils.isEmpty((CharSequence)updateQueue.getQueue())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queue");
        }
        if (StringUtils.isEmpty((CharSequence)updateQueue.getQueueName())) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "queueName");
        }
        if (!Objects.equals(updateQueue.getQueue(), existsQueue.getQueue()) && this.checkQueueExist(updateQueue.getQueue())) {
            throw new ServiceException(Status.QUEUE_VALUE_EXIST, updateQueue.getQueue());
        }
        if (!Objects.equals(updateQueue.getQueueName(), existsQueue.getQueueName()) && this.checkQueueNameExist(updateQueue.getQueueName())) {
            throw new ServiceException(Status.QUEUE_NAME_EXIST, updateQueue.getQueueName());
        }
    }

    @Override
    public Result queryList(User loginUser) {
        Result<List> result = new Result<List>();
        HashSet<Integer> ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.QUEUE, loginUser.getId(), logger);
        if (loginUser.getUserType().equals((Object)UserType.GENERAL_USER)) {
            ids = ids.isEmpty() ? new HashSet<Integer>() : ids;
            ids.add(Constants.DEFAULT_QUEUE_ID);
        }
        List queueList = this.queueMapper.selectBatchIds(ids);
        result.setData(queueList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryList(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Set ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.QUEUE, loginUser.getId(), logger);
        if (ids.isEmpty()) {
            result.setData(pageInfo);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage queueList = this.queueMapper.queryQueuePaging((IPage)page, new ArrayList(ids), searchVal);
        Integer count = (int)queueList.getTotal();
        pageInfo.setTotal(count);
        pageInfo.setTotalList(queueList.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Result createQueue(User loginUser, String queue, String queueName) {
        Result<Queue> result = new Result<Queue>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.QUEUE, "security:queue:create")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        Queue queueObj = new Queue(queueName, queue);
        this.createQueueValid(queueObj);
        this.queueMapper.insert((Object)queueObj);
        result.setData(queueObj);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        this.permissionPostHandle(AuthorizationType.QUEUE, loginUser.getId(), Collections.singletonList(queueObj.getId()), logger);
        return result;
    }

    @Override
    public Result updateQueue(User loginUser, int id, String queue, String queueName) {
        Result<Queue> result = new Result<Queue>();
        if (!this.canOperatorPermissions(loginUser, new Object[]{id}, AuthorizationType.QUEUE, "security:queue:update")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        Queue updateQueue = new Queue(id, queueName, queue);
        Queue existsQueue = (Queue)this.queueMapper.selectById((Serializable)Integer.valueOf(id));
        this.updateQueueValid(existsQueue, updateQueue);
        if (this.checkIfQueueIsInUsing(existsQueue.getQueueName(), updateQueue.getQueueName())) {
            Integer relatedUserNums = this.userMapper.updateUserQueue(existsQueue.getQueueName(), updateQueue.getQueueName());
            logger.info("old queue have related {} user, exec update user success.", (Object)relatedUserNums);
        }
        this.queueMapper.updateById((Object)updateQueue);
        result.setData(updateQueue);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyQueue(String queue, String queueName) {
        Result<Object> result = new Result<Object>();
        Queue queueValidator = new Queue(queueName, queue);
        this.createQueueValid(queueValidator);
        result.setData(queueValidator);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkQueueExist(String queue) {
        return this.queueMapper.existQueue(queue, null) == Boolean.TRUE;
    }

    private boolean checkQueueNameExist(String queueName) {
        return this.queueMapper.existQueue(null, queueName) == Boolean.TRUE;
    }

    private boolean checkIfQueueIsInUsing(String oldQueue, String newQueue) {
        return !oldQueue.equals(newQueue) && this.userMapper.existUser(oldQueue) == Boolean.TRUE;
    }

    @Override
    public Queue createQueueIfNotExists(String queue, String queueName) {
        Queue existsQueue = this.queueMapper.queryQueueName(queue, queueName);
        if (!Objects.isNull(existsQueue)) {
            return existsQueue;
        }
        Queue queueObj = new Queue(queueName, queue);
        this.createQueueValid(queueObj);
        this.queueMapper.insert((Object)queueObj);
        return queueObj;
    }
}

