/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.configuration;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.spring.web.plugins.WebFluxRequestHandlerProvider;
import springfox.documentation.spring.web.plugins.WebMvcRequestHandlerProvider;

@Configuration
@ConditionalOnWebApplication
@PropertySource(value={"classpath:swagger.properties"})
public class OpenAPIConfiguration
implements WebMvcConfigurer {
    @Bean
    public Docket createV1RestApi() {
        return new Docket(DocumentationType.OAS_30).groupName("v1(current)").apiInfo(this.apiV1Info()).select().apis(RequestHandlerSelectors.basePackage((String)"org.apache.dolphinscheduler.api.controller")).paths(PathSelectors.any().and(PathSelectors.ant((String)"/v2/**").negate())).build();
    }

    private ApiInfo apiV1Info() {
        return new ApiInfoBuilder().title("Dolphin Scheduler Api Docs").description("Dolphin Scheduler Api Docs").version("V1").build();
    }

    @Bean
    public Docket createV2RestApi() {
        return new Docket(DocumentationType.OAS_30).groupName("v2").apiInfo(this.apiV2Info()).select().apis(RequestHandlerSelectors.basePackage((String)"org.apache.dolphinscheduler.api.controller")).paths(PathSelectors.any().and(PathSelectors.ant((String)"/v2/**"))).build();
    }

    private ApiInfo apiV2Info() {
        return new ApiInfoBuilder().title("Dolphin Scheduler Api Docs").description("Dolphin Scheduler Api Docs").version("V2").build();
    }

    @Bean
    public static BeanPostProcessor springfoxHandlerProviderBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof WebMvcRequestHandlerProvider || bean instanceof WebFluxRequestHandlerProvider) {
                    this.customizeSpringfoxHandlerMappings(this.getHandlerMappings(bean));
                }
                return bean;
            }

            private <T extends RequestMappingInfoHandlerMapping> void customizeSpringfoxHandlerMappings(List<T> mappings) {
                List copy = mappings.stream().filter(mapping -> mapping.getPatternParser() == null).collect(Collectors.toList());
                mappings.clear();
                mappings.addAll(copy);
            }

            private List<RequestMappingInfoHandlerMapping> getHandlerMappings(Object bean) {
                try {
                    Field field = ReflectionUtils.findField(bean.getClass(), (String)"handlerMappings");
                    field.setAccessible(true);
                    return (List)field.get(bean);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }
}

