/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.resources.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.api.dto.resources.Directory;
import org.apache.dolphinscheduler.api.dto.resources.FileLeaf;
import org.apache.dolphinscheduler.api.dto.resources.ResourceComponent;
import org.apache.dolphinscheduler.api.dto.resources.visitor.Visitor;
import org.apache.dolphinscheduler.dao.entity.Resource;

public class ResourceTreeVisitor
implements Visitor {
    private List<Resource> resourceList;

    public ResourceTreeVisitor() {
    }

    public ResourceTreeVisitor(List<Resource> resourceList) {
        this.resourceList = resourceList;
    }

    @Override
    public ResourceComponent visit() {
        Directory rootDirectory = new Directory();
        for (Resource resource : this.resourceList) {
            if (!this.rootNode(resource)) continue;
            ResourceComponent tempResourceComponent = ResourceTreeVisitor.getResourceComponent(resource);
            rootDirectory.add(tempResourceComponent);
            tempResourceComponent.setChildren(ResourceTreeVisitor.setChildren(tempResourceComponent.getId(), this.resourceList));
        }
        return rootDirectory;
    }

    public static List<ResourceComponent> setChildren(int id, List<Resource> list) {
        ArrayList<ResourceComponent> childList = new ArrayList<ResourceComponent>();
        for (Resource resource : list) {
            if (id != resource.getPid()) continue;
            ResourceComponent tempResourceComponent = ResourceTreeVisitor.getResourceComponent(resource);
            childList.add(tempResourceComponent);
        }
        for (ResourceComponent resourceComponent : childList) {
            resourceComponent.setChildren(ResourceTreeVisitor.setChildren(resourceComponent.getId(), list));
        }
        if (childList.size() == 0) {
            return new ArrayList<ResourceComponent>();
        }
        return childList;
    }

    public boolean rootNode(Resource resource) {
        boolean isRootNode = true;
        if (resource.getPid() != -1) {
            for (Resource parent : this.resourceList) {
                if (resource.getPid() != parent.getId().intValue()) continue;
                isRootNode = false;
                break;
            }
        }
        return isRootNode;
    }

    private static ResourceComponent getResourceComponent(Resource resource) {
        ResourceComponent tempResourceComponent = resource.isDirectory() ? new Directory() : new FileLeaf();
        tempResourceComponent.setName(resource.getAlias());
        tempResourceComponent.setFullName(resource.getFullName().replaceFirst("/", ""));
        tempResourceComponent.setId(resource.getId());
        tempResourceComponent.setPid(resource.getPid());
        tempResourceComponent.setIdValue(resource.getId(), resource.isDirectory());
        tempResourceComponent.setDescription(resource.getDescription());
        tempResourceComponent.setType(resource.getType());
        return tempResourceComponent;
    }
}

