/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.k8s;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Optional;
import org.apache.dolphinscheduler.api.k8s.K8sManager;
import org.apache.dolphinscheduler.dao.entity.K8sNamespace;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.yaml.snakeyaml.Yaml;

@Component
public class K8sClientService {
    private static Yaml yaml = new Yaml();
    @Autowired
    private K8sManager k8sManager;

    public ResourceQuota upsertNamespaceAndResourceToK8s(K8sNamespace k8sNamespace, String yamlStr) throws RemotingException {
        this.upsertNamespaceToK8s(k8sNamespace.getNamespace(), k8sNamespace.getClusterCode());
        return this.upsertNamespacedResourceToK8s(k8sNamespace, yamlStr);
    }

    public Optional<Namespace> deleteNamespaceToK8s(String name, Long clusterCode) throws RemotingException {
        Optional<Namespace> result = this.getNamespaceFromK8s(name, clusterCode);
        if (result.isPresent()) {
            KubernetesClient client = this.k8sManager.getK8sClient(clusterCode);
            Namespace body = new Namespace();
            ObjectMeta meta = new ObjectMeta();
            meta.setNamespace(name);
            meta.setName(name);
            body.setMetadata(meta);
            client.namespaces().delete((Object[])new Namespace[]{body});
        }
        return this.getNamespaceFromK8s(name, clusterCode);
    }

    private ResourceQuota upsertNamespacedResourceToK8s(K8sNamespace k8sNamespace, String yamlStr) throws RemotingException {
        KubernetesClient client = this.k8sManager.getK8sClient(k8sNamespace.getClusterCode());
        ResourceQuota queryExist = (ResourceQuota)((Resource)((NonNamespaceOperation)client.resourceQuotas().inNamespace(k8sNamespace.getNamespace())).withName(k8sNamespace.getNamespace())).get();
        ResourceQuota body = (ResourceQuota)yaml.loadAs(yamlStr, ResourceQuota.class);
        if (queryExist != null && k8sNamespace.getLimitsCpu() == null && k8sNamespace.getLimitsMemory() == null) {
            ((Resource)((NonNamespaceOperation)client.resourceQuotas().inNamespace(k8sNamespace.getNamespace())).withName(k8sNamespace.getNamespace())).delete();
            return null;
        }
        return (ResourceQuota)((Resource)((NonNamespaceOperation)client.resourceQuotas().inNamespace(k8sNamespace.getNamespace())).withName(k8sNamespace.getNamespace())).createOrReplace((Object[])new ResourceQuota[]{body});
    }

    private Optional<Namespace> getNamespaceFromK8s(String name, Long clusterCode) throws RemotingException {
        NamespaceList listNamespace = (NamespaceList)this.k8sManager.getK8sClient(clusterCode).namespaces().list();
        Optional<Namespace> list = listNamespace.getItems().stream().filter(namespace -> namespace.getMetadata().getName().equals(name)).findFirst();
        return list;
    }

    private Namespace upsertNamespaceToK8s(String name, Long clusterCode) throws RemotingException {
        Optional<Namespace> result = this.getNamespaceFromK8s(name, clusterCode);
        if (!result.isPresent()) {
            KubernetesClient client = this.k8sManager.getK8sClient(clusterCode);
            Namespace body = new Namespace();
            ObjectMeta meta = new ObjectMeta();
            meta.setNamespace(name);
            meta.setName(name);
            body.setMetadata(meta);
            return (Namespace)client.namespaces().create((Object)body);
        }
        return result.get();
    }
}

