/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.permission.PermissionCheck;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.TaskDefinitionService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.api.vo.TaskDefinitionVo;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.ConditionType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TaskExecuteType;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskMainInfo;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ParametersNode;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.task.TaskPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskDefinitionServiceImpl
extends BaseServiceImpl
implements TaskDefinitionService {
    private static final Logger logger = LoggerFactory.getLogger(TaskDefinitionServiceImpl.class);
    private static final String RELEASESTATE = "releaseState";
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private ProcessTaskRelationMapper processTaskRelationMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private ProcessService processService;
    @Autowired
    private TaskPluginManager taskPluginManager;

    @Override
    @Transactional
    public Map<String, Object> createTaskDefinition(User loginUser, long projectCode, String taskDefinitionJson) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:create");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List taskDefinitionLogs = JSONUtils.toList((String)taskDefinitionJson, TaskDefinitionLog.class);
        if (CollectionUtils.isEmpty((Collection)taskDefinitionLogs)) {
            logger.warn("Parameter taskDefinitionJson is invalid.");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskDefinitionJson);
            return result;
        }
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogs) {
            if (this.taskPluginManager.checkTaskParameters(ParametersNode.builder().taskType(taskDefinitionLog.getTaskType()).taskParams(taskDefinitionLog.getTaskParams()).dependence(taskDefinitionLog.getDependence()).build())) continue;
            logger.error("task definition {} parameter invalid", (Object)taskDefinitionLog.getName());
            this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskDefinitionLog.getName());
            return result;
        }
        int saveTaskResult = this.processService.saveTaskDefine(loginUser, projectCode, taskDefinitionLogs, Boolean.TRUE);
        if (saveTaskResult == -1) {
            this.putMsg(result, Status.CREATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.CREATE_TASK_DEFINITION_ERROR);
        }
        HashMap<String, Object> resData = new HashMap<String, Object>();
        resData.put("total", taskDefinitionLogs.size());
        resData.put("code", StringUtils.join((Iterable)taskDefinitionLogs.stream().map(TaskDefinition::getCode).collect(Collectors.toList()), (String)","));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", resData);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> createTaskBindsWorkFlow(User loginUser, long projectCode, long processDefinitionCode, String taskDefinitionJsonObj, String upstreamCodes) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:create");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null || projectCode != processDefinition.getProjectCode()) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(processDefinitionCode));
            return result;
        }
        if (processDefinition.getReleaseState() == ReleaseState.ONLINE) {
            this.putMsg(result, Status.PROCESS_DEFINE_STATE_ONLINE, String.valueOf(processDefinitionCode));
            return result;
        }
        TaskDefinitionLog taskDefinition = (TaskDefinitionLog)JSONUtils.parseObject((String)taskDefinitionJsonObj, TaskDefinitionLog.class);
        if (taskDefinition == null) {
            logger.error("taskDefinitionJsonObj is not valid json");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskDefinitionJsonObj);
            return result;
        }
        if (!this.taskPluginManager.checkTaskParameters(ParametersNode.builder().taskType(taskDefinition.getTaskType()).taskParams(taskDefinition.getTaskParams()).dependence(taskDefinition.getDependence()).build())) {
            logger.error("task definition {} parameter invalid", (Object)taskDefinition.getName());
            this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskDefinition.getName());
            return result;
        }
        long taskCode = taskDefinition.getCode();
        if (taskCode == 0L) {
            taskDefinition.setCode(CodeGenerateUtils.getInstance().genCode());
        }
        List processTaskRelationLogList = this.processTaskRelationMapper.queryByProcessCode(projectCode, processDefinitionCode).stream().map(ProcessTaskRelationLog::new).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)upstreamCodes)) {
            Set upstreamTaskCodes = Arrays.stream(upstreamCodes.split(",")).map(Long::parseLong).collect(Collectors.toSet());
            List upstreamTaskDefinitionList = this.taskDefinitionMapper.queryByCodeList(upstreamTaskCodes);
            Set queryUpStreamTaskCodes = upstreamTaskDefinitionList.stream().map(TaskDefinition::getCode).collect(Collectors.toSet());
            Set diffCode = upstreamTaskCodes.stream().filter(code -> !queryUpStreamTaskCodes.contains(code)).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(diffCode)) {
                String taskCodes = StringUtils.join(diffCode, (String)",");
                logger.error("Some task definitions with parameter upstreamCodes do not exist, taskDefinitionCodes:{}.", (Object)taskCodes);
                this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, taskCodes);
                return result;
            }
            for (TaskDefinition upstreamTask : upstreamTaskDefinitionList) {
                ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog();
                processTaskRelationLog.setPreTaskCode(upstreamTask.getCode());
                processTaskRelationLog.setPreTaskVersion(upstreamTask.getVersion());
                processTaskRelationLog.setPostTaskCode(taskCode);
                processTaskRelationLog.setPostTaskVersion(1);
                processTaskRelationLog.setConditionType(ConditionType.NONE);
                processTaskRelationLog.setConditionParams("{}");
                processTaskRelationLogList.add(processTaskRelationLog);
            }
        } else {
            ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog();
            processTaskRelationLog.setPreTaskCode(0L);
            processTaskRelationLog.setPreTaskVersion(0);
            processTaskRelationLog.setPostTaskCode(taskCode);
            processTaskRelationLog.setPostTaskVersion(1);
            processTaskRelationLog.setConditionType(ConditionType.NONE);
            processTaskRelationLog.setConditionParams("{}");
            processTaskRelationLogList.add(processTaskRelationLog);
        }
        int insertResult = this.processService.saveTaskRelation(loginUser, projectCode, processDefinition.getCode(), processDefinition.getVersion(), processTaskRelationLogList, (List)Lists.newArrayList(), Boolean.TRUE);
        if (insertResult != 0) {
            logger.error("Save new version process task relations error, processDefinitionCode:{}, processDefinitionVersion:{}.", (Object)processDefinition.getCode(), (Object)processDefinition.getVersion());
            this.putMsg(result, Status.CREATE_PROCESS_TASK_RELATION_ERROR, new Object[0]);
            throw new ServiceException(Status.CREATE_PROCESS_TASK_RELATION_ERROR);
        }
        logger.info("Save new version process task relations complete, processDefinitionCode:{}, processDefinitionVersion:{}.", (Object)processDefinition.getCode(), (Object)processDefinition.getVersion());
        int saveTaskResult = this.processService.saveTaskDefine(loginUser, projectCode, (List)Lists.newArrayList((Object[])new TaskDefinitionLog[]{taskDefinition}), Boolean.TRUE);
        if (saveTaskResult == -1) {
            logger.error("Save task definition error, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskDefinition.getCode());
            this.putMsg(result, Status.CREATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.CREATE_TASK_DEFINITION_ERROR);
        }
        logger.info("Save task definition complete, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskDefinition.getCode());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", taskDefinition);
        return result;
    }

    @Override
    public Map<String, Object> queryTaskDefinitionByName(User loginUser, long projectCode, long processCode, String taskName) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:view");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByName(project.getCode(), processCode, taskName);
        if (taskDefinition == null) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, taskName);
        } else {
            result.put("data", taskDefinition);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> deleteTaskDefinitionByCode(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:delete");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (taskCode == 0L) {
            this.putMsg(result, Status.DELETE_TASK_DEFINE_BY_CODE_ERROR, new Object[0]);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
            return result;
        }
        if (this.processService.isTaskOnline(taskCode) && taskDefinition.getFlag() == Flag.YES) {
            logger.warn("Task definition can not be deleted due to task state online, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.TASK_DEFINE_STATE_ONLINE, taskCode);
            return result;
        }
        List processTaskRelationList = this.processTaskRelationMapper.queryDownstreamByTaskCode(taskDefinition.getCode());
        if (CollectionUtils.isNotEmpty((Collection)processTaskRelationList)) {
            Set postTaskCodes = processTaskRelationList.stream().map(ProcessTaskRelation::getPostTaskCode).collect(Collectors.toSet());
            String postTaskCodesStr = StringUtils.join(postTaskCodes, (String)",");
            logger.warn("Task definition can not be deleted due to downstream tasks, taskDefinitionCode:{}, downstreamTaskCodes:{}", (Object)taskCode, (Object)postTaskCodesStr);
            this.putMsg(result, Status.TASK_HAS_DOWNSTREAM, postTaskCodesStr);
            return result;
        }
        int delete = this.taskDefinitionMapper.deleteByCode(taskCode);
        if (delete > 0) {
            List taskRelationList = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
            if (!taskRelationList.isEmpty()) {
                logger.info("Task definition has upstream tasks, start handle them after delete task, taskDefinitionCode:{}.", (Object)taskCode);
                long processDefinitionCode = ((ProcessTaskRelation)taskRelationList.get(0)).getProcessDefinitionCode();
                List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(projectCode, processDefinitionCode);
                List<ProcessTaskRelation> relationList = processTaskRelations.stream().filter(r -> r.getPostTaskCode() != taskCode).collect(Collectors.toList());
                this.updateDag(loginUser, result, processDefinitionCode, relationList, Lists.newArrayList());
            } else {
                logger.info("Task definition delete complete, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskCode);
                this.putMsg(result, Status.SUCCESS, new Object[0]);
            }
        } else {
            this.putMsg(result, Status.DELETE_TASK_DEFINE_BY_CODE_ERROR, new Object[0]);
            throw new ServiceException(Status.DELETE_TASK_DEFINE_BY_CODE_ERROR);
        }
        return result;
    }

    private void updateDag(User loginUser, Map<String, Object> result, long processDefinitionCode, List<ProcessTaskRelation> processTaskRelationList, List<TaskDefinitionLog> taskDefinitionLogs) {
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null) {
            throw new ServiceException(Status.PROCESS_DEFINE_NOT_EXIST);
        }
        int insertVersion = this.processService.saveProcessDefine(loginUser, processDefinition, Boolean.TRUE, Boolean.TRUE);
        if (insertVersion <= 0) {
            logger.error("Update process definition error, projectCode:{}, processDefinitionCode:{}.", (Object)processDefinition.getProjectCode(), (Object)processDefinitionCode);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        logger.info("Save new version process definition complete, projectCode:{}, processDefinitionCode:{}, newVersion:{}.", new Object[]{processDefinition.getProjectCode(), processDefinitionCode, insertVersion});
        List relationLogs = processTaskRelationList.stream().map(ProcessTaskRelationLog::new).collect(Collectors.toList());
        int insertResult = this.processService.saveTaskRelation(loginUser, processDefinition.getProjectCode(), processDefinition.getCode(), insertVersion, relationLogs, taskDefinitionLogs, Boolean.TRUE);
        if (insertResult != 0) {
            logger.error("Update task relations error, projectCode:{}, processDefinitionCode:{}.", (Object)processDefinition.getProjectCode(), (Object)processDefinitionCode);
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        logger.info("Save new version task relations complete, projectCode:{}, processDefinitionCode:{}, newVersion:{}.", new Object[]{processDefinition.getProjectCode(), processDefinitionCode, insertVersion});
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", processDefinition);
    }

    @Override
    @Transactional
    public Map<String, Object> updateTaskDefinition(User loginUser, long projectCode, long taskCode, String taskDefinitionJsonObj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TaskDefinitionLog taskDefinitionToUpdate = this.updateTask(loginUser, projectCode, taskCode, taskDefinitionJsonObj, result);
        if (taskDefinitionToUpdate == null) {
            return result;
        }
        List taskRelationList = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        if (CollectionUtils.isNotEmpty((Collection)taskRelationList)) {
            logger.info("Task definition has upstream tasks, start handle them after update task, taskDefinitionCode:{}.", (Object)taskCode);
            long processDefinitionCode = ((ProcessTaskRelation)taskRelationList.get(0)).getProcessDefinitionCode();
            List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(projectCode, processDefinitionCode);
            this.updateDag(loginUser, result, processDefinitionCode, processTaskRelations, Lists.newArrayList((Object[])new TaskDefinitionLog[]{taskDefinitionToUpdate}));
        }
        result.put("data", taskCode);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private TaskDefinitionLog updateTask(User loginUser, long projectCode, long taskCode, String taskDefinitionJsonObj, Map<String, Object> result) {
        Project project = this.projectMapper.queryByCode(projectCode);
        result.putAll(this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:edit"));
        if (result.get("status") != Status.SUCCESS) {
            return null;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
            return null;
        }
        if (this.processService.isTaskOnline(taskCode) && taskDefinition.getFlag() == Flag.YES && taskDefinition.getTaskExecuteType() != TaskExecuteType.STREAM) {
            logger.warn("Only {} type task can be updated without online check, taskDefinitionCode:{}.", (Object)TaskExecuteType.STREAM, (Object)taskCode);
            this.putMsg(result, Status.NOT_SUPPORT_UPDATE_TASK_DEFINITION, new Object[0]);
            return null;
        }
        TaskDefinitionLog taskDefinitionToUpdate = (TaskDefinitionLog)JSONUtils.parseObject((String)taskDefinitionJsonObj, TaskDefinitionLog.class);
        if (taskDefinition.equals((Object)taskDefinitionToUpdate)) {
            return null;
        }
        if (taskDefinitionToUpdate == null) {
            logger.error("taskDefinitionJson is not valid json");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskDefinitionJsonObj);
            return null;
        }
        if (!this.taskPluginManager.checkTaskParameters(ParametersNode.builder().taskType(taskDefinitionToUpdate.getTaskType()).taskParams(taskDefinitionToUpdate.getTaskParams()).dependence(taskDefinitionToUpdate.getDependence()).build())) {
            logger.warn("Task definition parameters are invalid, taskDefinitionName:{}.", (Object)taskDefinitionToUpdate.getName());
            this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskDefinitionToUpdate.getName());
            return null;
        }
        Integer version = this.taskDefinitionLogMapper.queryMaxVersionForDefinition(taskCode);
        if (version == null || version == 0) {
            logger.error("Max version task definitionLog can not be found in database, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskCode);
            return null;
        }
        Date now = new Date();
        taskDefinitionToUpdate.setCode(taskCode);
        taskDefinitionToUpdate.setId(taskDefinition.getId());
        taskDefinitionToUpdate.setProjectCode(projectCode);
        taskDefinitionToUpdate.setUserId(taskDefinition.getUserId());
        version = version + 1;
        taskDefinitionToUpdate.setVersion(version.intValue());
        taskDefinitionToUpdate.setTaskType(taskDefinitionToUpdate.getTaskType().toUpperCase());
        taskDefinitionToUpdate.setResourceIds(this.processService.getResourceIds((TaskDefinition)taskDefinitionToUpdate));
        taskDefinitionToUpdate.setUpdateTime(now);
        int update = this.taskDefinitionMapper.updateById((Object)taskDefinitionToUpdate);
        taskDefinitionToUpdate.setOperator(loginUser.getId().intValue());
        taskDefinitionToUpdate.setOperateTime(now);
        taskDefinitionToUpdate.setCreateTime(now);
        taskDefinitionToUpdate.setId(null);
        int insert = this.taskDefinitionLogMapper.insert((Object)taskDefinitionToUpdate);
        if ((update & insert) != 1) {
            logger.error("Update task definition or definitionLog error, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskCode);
            this.putMsg(result, Status.UPDATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        logger.info("Update task definition and definitionLog complete, projectCode:{}, taskDefinitionCode:{}, newTaskVersion:{}.", new Object[]{projectCode, taskCode, taskDefinitionToUpdate.getVersion()});
        List processTaskRelations = this.processTaskRelationMapper.queryByTaskCode(taskDefinitionToUpdate.getCode());
        if (CollectionUtils.isNotEmpty((Collection)processTaskRelations)) {
            for (ProcessTaskRelation processTaskRelation : processTaskRelations) {
                int count;
                if (taskCode == processTaskRelation.getPreTaskCode()) {
                    processTaskRelation.setPreTaskVersion(version.intValue());
                } else if (taskCode == processTaskRelation.getPostTaskCode()) {
                    processTaskRelation.setPostTaskVersion(version.intValue());
                }
                if ((count = this.processTaskRelationMapper.updateProcessTaskRelationTaskVersion(processTaskRelation)) == 1) continue;
                logger.error("batch update process task relation error, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskCode);
                this.putMsg(result, Status.PROCESS_TASK_RELATION_BATCH_UPDATE_ERROR, new Object[0]);
                throw new ServiceException(Status.PROCESS_TASK_RELATION_BATCH_UPDATE_ERROR);
            }
        }
        return taskDefinitionToUpdate;
    }

    @Override
    public Map<String, Object> updateTaskWithUpstream(User loginUser, long projectCode, long taskCode, String taskDefinitionJsonObj, String upstreamCodes) {
        Map<Object, Object> queryUpStreamTaskCodeMap;
        HashMap<String, Object> result = new HashMap<String, Object>();
        TaskDefinitionLog taskDefinitionToUpdate = this.updateTask(loginUser, projectCode, taskCode, taskDefinitionJsonObj, result);
        List upstreamTaskRelations = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        Set upstreamCodeSet = upstreamTaskRelations.stream().map(ProcessTaskRelation::getPreTaskCode).collect(Collectors.toSet());
        Set upstreamTaskCodes = Collections.emptySet();
        if (StringUtils.isNotEmpty((CharSequence)upstreamCodes)) {
            upstreamTaskCodes = Arrays.stream(upstreamCodes.split(",")).map(Long::parseLong).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEqualCollection(upstreamCodeSet, upstreamTaskCodes) && taskDefinitionToUpdate == null) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        if (CollectionUtils.isNotEmpty(upstreamTaskCodes)) {
            List upstreamTaskDefinitionList = this.taskDefinitionMapper.queryByCodeList(upstreamTaskCodes);
            queryUpStreamTaskCodeMap = upstreamTaskDefinitionList.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinition -> taskDefinition));
            upstreamTaskCodes.removeAll(queryUpStreamTaskCodeMap.keySet());
            if (CollectionUtils.isNotEmpty(upstreamTaskCodes)) {
                String notExistTaskCodes = StringUtils.join(upstreamTaskCodes, (String)",");
                logger.error("Some task definitions in parameter upstreamTaskCodes do not exist, notExistTaskCodes:{}.", (Object)notExistTaskCodes);
                this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, notExistTaskCodes);
                return result;
            }
        } else {
            queryUpStreamTaskCodeMap = new HashMap();
        }
        if (CollectionUtils.isNotEmpty(upstreamTaskCodes)) {
            ProcessTaskRelation taskRelation = (ProcessTaskRelation)upstreamTaskRelations.get(0);
            List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(projectCode, taskRelation.getProcessDefinitionCode());
            ArrayList processTaskRelationList = Lists.newArrayList((Iterable)processTaskRelations);
            ArrayList relationList = Lists.newArrayList();
            for (ProcessTaskRelation processTaskRelation : processTaskRelationList) {
                if (processTaskRelation.getPostTaskCode() != taskCode) continue;
                if (queryUpStreamTaskCodeMap.containsKey(processTaskRelation.getPreTaskCode()) && processTaskRelation.getPreTaskCode() != 0L) {
                    queryUpStreamTaskCodeMap.remove(processTaskRelation.getPreTaskCode());
                    continue;
                }
                processTaskRelation.setPreTaskCode(0L);
                processTaskRelation.setPreTaskVersion(0);
                relationList.add(processTaskRelation);
            }
            processTaskRelationList.removeAll(relationList);
            for (Map.Entry entry : queryUpStreamTaskCodeMap.entrySet()) {
                taskRelation.setPreTaskCode(((Long)entry.getKey()).longValue());
                taskRelation.setPreTaskVersion(((TaskDefinition)entry.getValue()).getVersion());
                processTaskRelationList.add(taskRelation);
            }
            if (MapUtils.isEmpty(queryUpStreamTaskCodeMap) && CollectionUtils.isNotEmpty((Collection)processTaskRelationList)) {
                processTaskRelationList.add(processTaskRelationList.get(0));
            }
            this.updateDag(loginUser, result, taskRelation.getProcessDefinitionCode(), processTaskRelations, Lists.newArrayList((Object[])new TaskDefinitionLog[]{taskDefinitionToUpdate}));
        }
        logger.info("Update task with upstream tasks complete, projectCode:{}, taskDefinitionCode:{}, upstreamTaskCodes:{}.", new Object[]{projectCode, taskCode, upstreamTaskCodes});
        result.put("data", taskCode);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> switchVersion(User loginUser, long projectCode, long taskCode, int version) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:version:switch");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (this.processService.isTaskOnline(taskCode)) {
            logger.warn("Task definition version can not be switched due to process definition is {}, taskDefinitionCode:{}.", (Object)ReleaseState.ONLINE.getDescp(), (Object)taskCode);
            this.putMsg(result, Status.PROCESS_DEFINE_STATE_ONLINE, new Object[0]);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
            return result;
        }
        TaskDefinitionLog taskDefinitionUpdate = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskCode, version);
        taskDefinitionUpdate.setUserId(loginUser.getId().intValue());
        taskDefinitionUpdate.setUpdateTime(new Date());
        taskDefinitionUpdate.setId(taskDefinition.getId());
        int switchVersion = this.taskDefinitionMapper.updateById((Object)taskDefinitionUpdate);
        if (switchVersion > 0) {
            List taskRelationList = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
            if (CollectionUtils.isNotEmpty((Collection)taskRelationList)) {
                logger.info("Task definition has upstream tasks, start handle them after switch task, taskDefinitionCode:{}.", (Object)taskCode);
                long processDefinitionCode = ((ProcessTaskRelation)taskRelationList.get(0)).getProcessDefinitionCode();
                List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(projectCode, processDefinitionCode);
                this.updateDag(loginUser, result, processDefinitionCode, processTaskRelations, Lists.newArrayList((Object[])new TaskDefinitionLog[]{taskDefinitionUpdate}));
            } else {
                logger.info("Task definition version switch complete, switch task version to {}, taskDefinitionCode:{}.", (Object)version, (Object)taskCode);
                this.putMsg(result, Status.SUCCESS, new Object[0]);
            }
        } else {
            this.putMsg(result, Status.SWITCH_TASK_DEFINITION_VERSION_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Result queryTaskDefinitionVersions(User loginUser, long projectCode, long taskCode, int pageNo, int pageSize) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:version");
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            this.putMsg(result, resultStatus, new Object[0]);
            return result;
        }
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage taskDefinitionVersionsPaging = this.taskDefinitionLogMapper.queryTaskDefinitionVersionsPaging(page, taskCode, projectCode);
        List taskDefinitionLogs = taskDefinitionVersionsPaging.getRecords();
        pageInfo.setTotalList(taskDefinitionLogs);
        pageInfo.setTotal((int)taskDefinitionVersionsPaging.getTotal());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> deleteByCodeAndVersion(User loginUser, long projectCode, long taskCode, int version) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:delete");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
        } else {
            if (taskDefinition.getVersion() == version) {
                logger.warn("Task definition can not be deleted due to version is being used, projectCode:{}, taskDefinitionCode:{}, version:{}.", new Object[]{projectCode, taskCode, version});
                this.putMsg(result, Status.MAIN_TABLE_USING_VERSION, new Object[0]);
                return result;
            }
            int delete = this.taskDefinitionLogMapper.deleteByCodeAndVersion(taskCode, version);
            if (delete > 0) {
                logger.info("Task definition version delete complete, projectCode:{}, taskDefinitionCode:{}, version:{}.", new Object[]{projectCode, taskCode, version});
                this.putMsg(result, Status.SUCCESS, new Object[0]);
            } else {
                this.putMsg(result, Status.DELETE_TASK_DEFINITION_VERSION_ERROR, new Object[0]);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> queryTaskDefinitionDetail(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:view");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
        } else {
            List taskRelationList = this.processTaskRelationMapper.queryByCode(projectCode, 0L, 0L, taskCode);
            if (CollectionUtils.isNotEmpty((Collection)taskRelationList)) {
                taskRelationList = taskRelationList.stream().filter(v -> v.getPreTaskCode() != 0L).collect(Collectors.toList());
            }
            TaskDefinitionVo taskDefinitionVo = TaskDefinitionVo.fromTaskDefinition(taskDefinition);
            taskDefinitionVo.setProcessTaskRelationList(taskRelationList);
            result.put("data", (Object)taskDefinitionVo);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Result queryTaskDefinitionListPaging(User loginUser, long projectCode, String searchWorkflowName, String searchTaskName, String taskType, TaskExecuteType taskExecuteType, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:view");
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            this.putMsg(result, resultStatus, new Object[0]);
            return result;
        }
        taskType = taskType == null ? "" : taskType;
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage taskMainInfoIPage = this.taskDefinitionMapper.queryDefineListPaging((IPage)page, projectCode, searchWorkflowName, searchTaskName, taskType, taskExecuteType);
        List records = taskMainInfoIPage.getRecords();
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            HashMap<Long, TaskMainInfo> taskMainInfoMap = new HashMap<Long, TaskMainInfo>();
            for (TaskMainInfo info : records) {
                taskMainInfoMap.compute(info.getTaskCode(), (k, v) -> {
                    if (v == null) {
                        HashMap<Long, String> upstreamTaskMap = new HashMap<Long, String>();
                        if (info.getUpstreamTaskCode() != 0L) {
                            upstreamTaskMap.put(info.getUpstreamTaskCode(), info.getUpstreamTaskName());
                            info.setUpstreamTaskCode(0L);
                            info.setUpstreamTaskName("");
                        }
                        info.setUpstreamTaskMap(upstreamTaskMap);
                        v = info;
                    }
                    if (info.getUpstreamTaskCode() != 0L) {
                        v.getUpstreamTaskMap().put(info.getUpstreamTaskCode(), info.getUpstreamTaskName());
                    }
                    return v;
                });
            }
            taskMainInfoIPage.setRecords((List)Lists.newArrayList(taskMainInfoMap.values()));
        }
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal((int)taskMainInfoIPage.getTotal());
        pageInfo.setTotalList(taskMainInfoIPage.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> genTaskCodeList(Integer genNum) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (genNum == null || genNum < 1 || genNum > 100) {
            logger.error("the genNum must be great than 1 and less than 100");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, genNum);
            return result;
        }
        ArrayList<Long> taskCodes = new ArrayList<Long>();
        try {
            for (int i = 0; i < genNum; ++i) {
                taskCodes.add(CodeGenerateUtils.getInstance().genCode());
            }
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            logger.error("Task code get error, ", (Throwable)e);
            this.putMsg(result, Status.INTERNAL_SERVER_ERROR_ARGS, "Error generating task definition code");
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", taskCodes);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> releaseTaskDefinition(User loginUser, long projectCode, long code, ReleaseState releaseState) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        Status resultStatus = (Status)((Object)result.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return result;
        }
        if (null == releaseState) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, RELEASESTATE);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(code);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(code));
            return result;
        }
        TaskDefinitionLog taskDefinitionLog = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(code, taskDefinition.getVersion());
        if (taskDefinitionLog == null) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(code));
            return result;
        }
        switch (releaseState) {
            case OFFLINE: {
                taskDefinition.setFlag(Flag.NO);
                taskDefinitionLog.setFlag(Flag.NO);
                break;
            }
            case ONLINE: {
                String resourceIds = taskDefinition.getResourceIds();
                if (StringUtils.isNotBlank((CharSequence)resourceIds)) {
                    Integer[] resourceIdArray = (Integer[])Arrays.stream(resourceIds.split(",")).map(Integer::parseInt).toArray(Integer[]::new);
                    PermissionCheck<Integer> permissionCheck = new PermissionCheck<Integer>(AuthorizationType.RESOURCE_FILE_ID, this.processService, resourceIdArray, (int)loginUser.getId(), logger);
                    try {
                        permissionCheck.checkPermission();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        this.putMsg(result, Status.RESOURCE_NOT_EXIST_OR_NO_PERMISSION, new Object[0]);
                        return result;
                    }
                }
                taskDefinition.setFlag(Flag.YES);
                taskDefinitionLog.setFlag(Flag.YES);
                break;
            }
            default: {
                this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, RELEASESTATE);
                return result;
            }
        }
        int update = this.taskDefinitionMapper.updateById((Object)taskDefinition);
        int updateLog = this.taskDefinitionLogMapper.updateById(taskDefinitionLog);
        if (update == 0 && updateLog == 1 || update == 1 && updateLog == 0) {
            this.putMsg(result, Status.UPDATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        logger.error("Update taskDefinition state or taskDefinitionLog state to complete, taskDefinitionCode:{}.", (Object)code);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

