/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.AlertStatus;
import org.apache.dolphinscheduler.common.enums.AlertType;
import org.apache.dolphinscheduler.common.enums.ShowType;
import org.apache.dolphinscheduler.dao.AbstractBaseDao;
import org.apache.dolphinscheduler.dao.datasource.ConnectionFactory;
import org.apache.dolphinscheduler.dao.entity.Alert;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.AlertMapper;
import org.apache.dolphinscheduler.dao.mapper.UserAlertGroupMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlertDao
extends AbstractBaseDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AlertMapper alertMapper;
    @Autowired
    private UserAlertGroupMapper userAlertGroupMapper;

    @Override
    protected void init() {
        this.alertMapper = ConnectionFactory.getMapper(AlertMapper.class);
        this.userAlertGroupMapper = ConnectionFactory.getMapper(UserAlertGroupMapper.class);
    }

    public int addAlert(Alert alert) {
        return this.alertMapper.insert(alert);
    }

    public int updateAlert(AlertStatus alertStatus, String log, int id) {
        Alert alert = (Alert)this.alertMapper.selectById(Integer.valueOf(id));
        alert.setAlertStatus(alertStatus);
        alert.setUpdateTime(new Date());
        alert.setLog(log);
        return this.alertMapper.updateById(alert);
    }

    public List<User> queryUserByAlertGroupId(int alerGroupId) {
        return this.userAlertGroupMapper.listUserByAlertgroupId(alerGroupId);
    }

    public void sendServerStopedAlert(int alertgroupId, String host, String serverType) {
        Alert alert = new Alert();
        String content = String.format("[{'type':'%s','host':'%s','event':'server down','warning level':'serious'}]", serverType, host);
        alert.setTitle("Fault tolerance warning");
        alert.setShowType(ShowType.TABLE);
        alert.setContent(content);
        alert.setAlertType(AlertType.EMAIL);
        alert.setAlertGroupId(alertgroupId);
        alert.setCreateTime(new Date());
        alert.setUpdateTime(new Date());
        this.alertMapper.insert(alert);
    }

    public void sendProcessTimeoutAlert(ProcessInstance processInstance, ProcessDefinition processDefinition) {
        int alertgroupId = processInstance.getWarningGroupId();
        String receivers = processDefinition.getReceivers();
        String receiversCc = processDefinition.getReceiversCc();
        Alert alert = new Alert();
        String content = String.format("[{'id':'%d','name':'%s','event':'timeout','warnLevel':'middle'}]", processInstance.getId(), processInstance.getName());
        alert.setTitle("Process Timeout Warn");
        alert.setShowType(ShowType.TABLE);
        alert.setContent(content);
        alert.setAlertType(AlertType.EMAIL);
        alert.setAlertGroupId(alertgroupId);
        if (StringUtils.isNotEmpty((CharSequence)receivers)) {
            alert.setReceivers(receivers);
        }
        if (StringUtils.isNotEmpty((CharSequence)receiversCc)) {
            alert.setReceiversCc(receiversCc);
        }
        alert.setCreateTime(new Date());
        alert.setUpdateTime(new Date());
        this.alertMapper.insert(alert);
    }

    public void sendTaskTimeoutAlert(int alertgroupId, String receivers, String receiversCc, int taskId, String taskName) {
        Alert alert = new Alert();
        String content = String.format("[{'id':'%d','name':'%s','event':'timeout','warnLevel':'middle'}]", taskId, taskName);
        alert.setTitle("Task Timeout Warn");
        alert.setShowType(ShowType.TABLE);
        alert.setContent(content);
        alert.setAlertType(AlertType.EMAIL);
        alert.setAlertGroupId(alertgroupId);
        if (StringUtils.isNotEmpty((CharSequence)receivers)) {
            alert.setReceivers(receivers);
        }
        if (StringUtils.isNotEmpty((CharSequence)receiversCc)) {
            alert.setReceiversCc(receiversCc);
        }
        alert.setCreateTime(new Date());
        alert.setUpdateTime(new Date());
        this.alertMapper.insert(alert);
    }

    public List<Alert> listWaitExecutionAlert() {
        return this.alertMapper.listAlertByStatus(AlertStatus.WAIT_EXECUTION);
    }

    public List<User> listUserByAlertgroupId(int alertgroupId) {
        return this.userAlertGroupMapper.listUserByAlertgroupId(alertgroupId);
    }
}

