/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.dao.entity.MonitorRecord;
import org.apache.dolphinscheduler.dao.utils.MysqlPerformance;
import org.apache.dolphinscheduler.dao.utils.PostgrePerformance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MonitorDBDao {
    private static Logger logger = LoggerFactory.getLogger(MonitorDBDao.class);
    public static final String VARIABLE_NAME = "variable_name";
    @Autowired
    private DruidDataSource dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitorRecord getCurrentDbPerformance() {
        MonitorRecord monitorRecord = null;
        DruidPooledConnection conn = null;
        try {
            conn = this.dataSource.getConnection();
            String driverClassName = this.dataSource.getDriverClassName();
            if (driverClassName.contains(DbType.MYSQL.toString().toLowerCase())) {
                MonitorRecord monitorRecord2 = new MysqlPerformance().getMonitorRecord((Connection)conn);
                return monitorRecord2;
            }
            if (driverClassName.contains(DbType.POSTGRESQL.toString().toLowerCase())) {
                MonitorRecord monitorRecord3 = new PostgrePerformance().getMonitorRecord((Connection)conn);
                return monitorRecord3;
            }
        }
        catch (Exception e) {
            logger.error("SQLException " + e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error("SQLException ", (Throwable)e);
            }
        }
        return monitorRecord;
    }

    public List<MonitorRecord> queryDatabaseState() {
        ArrayList<MonitorRecord> list = new ArrayList<MonitorRecord>(1);
        MonitorRecord monitorRecord = this.getCurrentDbPerformance();
        if (monitorRecord != null) {
            list.add(monitorRecord);
        }
        return list;
    }
}

