/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import javax.sql.DataSource;
import org.apache.dolphinscheduler.dao.datasource.SpringConnectionFactory;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory
extends SpringConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private static SqlSessionFactory sqlSessionFactory;
    private static SqlSessionTemplate sqlSessionTemplate;

    public static DruidDataSource getDataSource() {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setDriverClassName(conf.getString("spring.datasource.driver-class-name"));
        druidDataSource.setUrl(conf.getString("spring.datasource.url"));
        druidDataSource.setUsername(conf.getString("spring.datasource.username"));
        druidDataSource.setPassword(conf.getString("spring.datasource.password"));
        druidDataSource.setValidationQuery(conf.getString("spring.datasource.validationQuery"));
        druidDataSource.setPoolPreparedStatements(conf.getBoolean("spring.datasource.poolPreparedStatements"));
        druidDataSource.setTestWhileIdle(conf.getBoolean("spring.datasource.testWhileIdle"));
        druidDataSource.setTestOnBorrow(conf.getBoolean("spring.datasource.testOnBorrow"));
        druidDataSource.setTestOnReturn(conf.getBoolean("spring.datasource.testOnReturn"));
        druidDataSource.setKeepAlive(conf.getBoolean("spring.datasource.keepAlive"));
        druidDataSource.setMinIdle(conf.getInt("spring.datasource.minIdle"));
        druidDataSource.setMaxActive(conf.getInt("spring.datasource.maxActive"));
        druidDataSource.setMaxWait((long)conf.getInt("spring.datasource.maxWait"));
        druidDataSource.setMaxPoolPreparedStatementPerConnectionSize(conf.getInt("spring.datasource.maxPoolPreparedStatementPerConnectionSize"));
        druidDataSource.setInitialSize(conf.getInt("spring.datasource.initialSize"));
        druidDataSource.setTimeBetweenEvictionRunsMillis(conf.getLong("spring.datasource.timeBetweenEvictionRunsMillis"));
        druidDataSource.setTimeBetweenConnectErrorMillis(conf.getLong("spring.datasource.timeBetweenConnectErrorMillis"));
        druidDataSource.setMinEvictableIdleTimeMillis(conf.getLong("spring.datasource.minEvictableIdleTimeMillis"));
        druidDataSource.setValidationQueryTimeout(conf.getInt("spring.datasource.validationQueryTimeout"));
        druidDataSource.setDefaultAutoCommit(conf.getBoolean("spring.datasource.defaultAutoCommit"));
        return druidDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlSessionFactory getSqlSessionFactory() throws Exception {
        if (sqlSessionFactory != null) return sqlSessionFactory;
        Class<ConnectionFactory> clazz = ConnectionFactory.class;
        synchronized (ConnectionFactory.class) {
            if (sqlSessionFactory != null) return sqlSessionFactory;
            DruidDataSource dataSource = ConnectionFactory.getDataSource();
            JdbcTransactionFactory transactionFactory = new JdbcTransactionFactory();
            Environment environment = new Environment("development", (TransactionFactory)transactionFactory, (DataSource)dataSource);
            MybatisConfiguration configuration = new MybatisConfiguration();
            configuration.setEnvironment(environment);
            configuration.setLazyLoadingEnabled(true);
            configuration.addMappers("org.apache.dolphinscheduler.dao.mapper");
            configuration.addInterceptor((Interceptor)new PaginationInterceptor());
            MybatisSqlSessionFactoryBean sqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
            sqlSessionFactoryBean.setConfiguration(configuration);
            sqlSessionFactoryBean.setDataSource((DataSource)dataSource);
            sqlSessionFactoryBean.setTypeEnumsPackage("org.apache.dolphinscheduler.*.enums");
            sqlSessionFactory = sqlSessionFactoryBean.getObject();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sqlSessionFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlSession getSqlSession() {
        if (sqlSessionTemplate != null) return sqlSessionTemplate;
        Class<ConnectionFactory> clazz = ConnectionFactory.class;
        synchronized (ConnectionFactory.class) {
            if (sqlSessionTemplate != null) return sqlSessionTemplate;
            try {
                sqlSessionTemplate = new SqlSessionTemplate(ConnectionFactory.getSqlSessionFactory());
                // ** MonitorExit[var0] (shouldn't be in output)
                return sqlSessionTemplate;
            }
            catch (Exception e) {
                logger.error("getSqlSession error", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static <T> T getMapper(Class<T> type) {
        try {
            return (T)ConnectionFactory.getSqlSession().getMapper(type);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("get mapper failed");
        }
    }
}

